package com.cloud.hisavana.sdk.sign;

import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.core.utils.EncoderUtil;
import com.transsion.json.Tson;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HttpSigner {
    private final Signer signer;
    public static boolean isTest = false;
    private static final String TEST_SECRET = "Xqn2nnO41/L92o1iuXhSLHTbXvY4Z5ZZ62m8mSLA";
    private static final String RELEASE_SECRET = "76iRl07s0xSN9jqmEWAt79EBJZulIQIsV64FZr2O";

    public HttpSigner(Signer signer) {
        this.signer = signer;
    }

    public static void setTest(boolean flag){
        isTest = flag;
    }

    public static String getSecret(){
        return isTest ? TEST_SECRET : RELEASE_SECRET;
    }

    public static String doSign(String method, String accept, String contentType, String url,
                                String body) {
        long timenow = System.currentTimeMillis();
        BasicSigner basicSigner;
        HttpSigner httpSigner;
        long offset = AdxPreferencesHelper.getInstance().getLong("time_offset");
        long timeStamp = System.currentTimeMillis() + offset;
        String secret = getSecret();
        basicSigner = new BasicSigner(secret);
        httpSigner = new HttpSigner(basicSigner);
        String sign = httpSigner.sign(method, accept, contentType, url, body, timeStamp);
        AdLogUtil.LOG.d("x-tr-signature: " + timeStamp + "|2|" + sign);
        AdLogUtil.LOG.d("doSign latency: " + (System.currentTimeMillis() - timenow));
        return timeStamp + "|2|" + sign;
    }


    public String sign(String method, String accept, String contentType, String url,
                       String body, long timeStamp) {
        String content = generateContent(method, accept, contentType, url, body, timeStamp);
        return signer.sign(SignAlgorithm.HmacMD5, content);
    }




    private String generateContent(String method, String accept, String contentType, String url,
                                   String body, long timeStamp) {
        StringBuilder stringBuilder = new StringBuilder();
        String md5 = "";
        long contentLength = 0;


        if (!TextUtils.isEmpty(body)) {
            AdLogUtil.LOG.d("request body is not null");
            try {
                contentLength = body.length();
                long timenow = System.currentTimeMillis();
                if (body.length() > 102400) {
                    md5 = EncoderUtil.EncoderByAlgorithm(body.substring(0, 102400),EncoderUtil.ALGORITHM_MD5);
                } else {
                    md5 = EncoderUtil.EncoderByAlgorithm(body,EncoderUtil.ALGORITHM_MD5);
                }
                AdLogUtil.LOG.d("md5 duration" + (System.currentTimeMillis() - timenow));
            } catch (final Exception e) {
                AdLogUtil.LOG.d("generateContent exception" + e.toString());
            }
        } else {
            AdLogUtil.LOG.d("request body is null");
        }


        stringBuilder.append(method.toUpperCase()).append("\n")
                .append(accept == null ? "" : accept).append("\n")
                .append(contentType == null ? "" : contentType).append("\n")
                .append(contentLength == 0 ? "" : contentLength).append("\n")
                .append(timeStamp).append("\n")
                .append(TextUtils.isEmpty(md5) ? "" : md5).append("\n")
                .append(buildPathAndParameters(url));
        AdLogUtil.LOG.d(stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String formatUrlMap(Map<String, String> paraMap) {
        String buff;
        try {
            List<Map.Entry<String, String>> infoIds = new ArrayList<>(paraMap.entrySet());
            // 对所有传入参数按照字段名的 ASCII 码从小到大排序（字典序）
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>() {
                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return (o1.getKey()).compareTo(o2.getKey());
                }
            });

            // 构造URL 键值对的格式
            StringBuilder buf = new StringBuilder();
            for (Map.Entry<String, String> item : infoIds) {
                if (!"".equals(item.getKey())) {
                    String key = item.getKey();
                    String val = item.getValue();
                    buf.append(key).append("=").append(val);
                    buf.append("&");
                }
            }
            if (buf.length() > 0) {
                buf.deleteCharAt(buf.length() - 1);
            }

            buff = buf.toString();
        } catch (Exception e) {
            return null;
        }
        return buff;
    }

    private String splitQuery(String queryString) {
        Map<String, String> queryPairs = new HashMap<>();
        String[] pairs = queryString.split("&");
        for (String pair : pairs) {
            int idx = pair.indexOf("=");
            try {
                queryPairs.put(URLDecoder.decode(pair.substring(0, idx), "UTF-8"), URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formatUrlMap(queryPairs);
    }

    private String buildPathAndParameters(String url) {
        StringBuilder stringBuilder = new StringBuilder();
        URI uri;
        try {
            uri = new URI(url);
        } catch (URISyntaxException e) {
            e.printStackTrace();
            return "";
        }


        stringBuilder.append(uri.getPath());

        if (!TextUtils.isEmpty(uri.getQuery())) {
            String formatedUrl = splitQuery(uri.getQuery());

            if (!TextUtils.isEmpty(formatedUrl)) {
                AdLogUtil.LOG.d("formatedUrl" + formatedUrl);
                stringBuilder.append("?").append(formatedUrl);
            }

        }
        return stringBuilder.toString();
    }

    public static boolean needRetryForTimeIssue(int code, String response) {
        if (code!= 500 && TextUtils.isEmpty(response)) {
            return false;
        }
        try {
            AdLogUtil.LOG.d("response" + response);
            GatewayResponse gatewayResponse = Tson.fromJson(response, GatewayResponse.class);
            String errorMsg = "GW.4410";
            if (errorMsg.equals(gatewayResponse.errorCode)) {
                AdLogUtil.LOG.d("verify sign failed, retrying update time");
                String msg = gatewayResponse.errorMsg;
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.KITKAT) {
                    TimeBean time = Tson.fromJson(Crypto.Decrypt(msg), TimeBean.class);
                    if (time.time > 0) {
                        AdxPreferencesHelper.getInstance().putLong("time_offset", (time.time - System.currentTimeMillis()));
                        return true;
                    }
                }
            }
        } catch (Exception e) {
            AdLogUtil.LOG.d(Log.getStackTraceString(e));
        }
        return false;
    }

}
