package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.transsion.core.utils.ScreenUtil;

/**
 * ADX开屏对外提供的接口
 * 仅仅提供容器的能力 不参与数据处理
 */
public class ASplash extends RelativeLayout {

    /**
     * 这个对象里面 解决了 数据哪里来的问题
     */
    private TranSplash mSplash = null;

    private RelativeLayout mSplashLayout = null;
    private FrameLayout mLogoLayout = null;

    /**
     * 加载 logo的类型
     */
    public static final int FLAG_APPLY_LOGO_LAYOUT = 0;
    public static final int FLAG_NO_LOGO_LAYOUT = 1;
    public static final int FLAG_FULL_SCREEN = 2;


    // =============================================================================================


    public ASplash(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ASplash(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, "");
    }

    public ASplash(Context context, String placementId) {
        super(context, null);
        init(context, placementId);
    }

    /**
     * 初始化 创建了容器
     * 数据处理对象
     */
    private void init(Context context, String placementId) {
        mSplashLayout = new RelativeLayout(this.getContext());
        this.addView(mSplashLayout, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mSplash = new TranSplash(context, mSplashLayout, placementId);
    }


    // =============================================================================================


    private int mFlag;

    /**
     * 设置了加载logo的 类型
     */
    public void setFlag(int flag) {
        this.mFlag = flag;
    }

    /**
     * 将媒体的logo 添加进来
     */
    @Deprecated
    private void addLogoLayout(View logoView) {
        if (mLogoLayout != null) {
            this.removeView(mLogoLayout);
        }
        int logoHeight = 0;
        if (mFlag == FLAG_APPLY_LOGO_LAYOUT) {
            mLogoLayout = new FrameLayout(this.getContext());
            int screenWidth = ScreenUtil.getWinWidth();
            int screenHeight = ScreenUtil.getWinHeight();
            logoHeight = 200;  //默认值
            if (screenWidth >= 320 && screenWidth < 720) {
                logoHeight = (int) (screenWidth * ((float) 118 / 480) + 0.5F);
                AdLogUtil.LOG.d("logo_480_118");
            } else if (screenWidth >= 720 && screenWidth < 1080) {
                logoHeight = (int) (screenWidth * ((float) 216 / 720) + 0.5F);
                AdLogUtil.LOG.d("logo_720_216");
            } else if (screenWidth >= 1080) {
                if (screenHeight < 2040) {
                    logoHeight = (int) (screenWidth * ((float) 286 / 1080) + 0.5F);
                    AdLogUtil.LOG.d("logo_1080_286");
                } else if (screenHeight >= 2040) {
                    logoHeight = (int) (screenWidth * ((float) 416 / 1080) + 0.5F);
                    AdLogUtil.LOG.d("logo_1080_416");
                }
            }
            mLogoLayout.addView(logoView);
            RelativeLayout.LayoutParams logoParam = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, logoHeight);
            logoParam.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
            this.addView(mLogoLayout, logoParam);
        }
        LayoutParams splashParams = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT);
        splashParams.setMargins(0, 0, 0, logoHeight);
        mSplashLayout.setLayoutParams(splashParams);
    }


    // =============================================================================================

    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        if (isNullApi()) {
            return;
        }
        mSplash.setPlacementId(placementId);
    }

    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        if (isNullApi()) {
            return;
        }
        mSplash.setDefaultAd(isDefaultAd);
    }

    /**
     * 开屏允许外部 deeplink
     */
    public void setAllowSkipOut(boolean mIsOpenDpl) {
        mSplash.setAllowSkipOut(mIsOpenDpl);
    }

    /**
     * 设置跳过的监听器
     */
    public void setSkipListener(OnSkipListener listener) {
        if (isNullApi()) {
            return;
        }
        mSplash.setSkipListener(listener);
    }

    /**
     * 设置广告的请求
     */
    public void setAdRequest(@NonNull TaRequest adRequest) {
        if (isNullApi()) {
            return;
        }
        mSplash.setAdRequest(adRequest);
    }

    /**
     * 加载广告
     */
    public void loadAd() {
        if (isNullApi()) {
            return;
        }
        mSplash.loadAd();
    }
    public boolean isAdValid() {
        if(isNullApi()){
            return false;
        }
        return mSplash.isAdValid();
    }
    /**
     * 显示广告 --> 在广告加载完成之后显示
     */
    public void show(View logoView) {
        if (isNullApi()) {
            return;
        }
        Preconditions.checkIsOnMainThread();

        // 没有这个逻辑了
        //addLogoLayout(logoView);
        mSplash.show();
    }

    /**
     * 在调用界面销毁的时候调用
     */
    public void destroy() {
        if (isNullApi()) {
            return;
        }
        mSplash.destroy();
    }

    private boolean isNullApi() {
        if (mSplash == null) {
            AdLogUtil.LOG.e("no api found");
            return true;
        }
        return false;
    }

}

