package com.cloud.hisavana.sdk.ad.base;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.IAdPoly;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by jianbing.yu on 2019/3/26.
 */

public abstract class AdxBaseAd implements IAdPoly {

    protected InternalAdListener mBridgeListener = null;
    private AdServerRequest adServerRequest;
    private int mAdType;
    protected int mAdCount;
    protected String mPlacementId;
    protected List<AdsDTO> mAdBeans = null;
    private AdxImpBean impBean;

    public AdxBaseAd(String placementId, int adType) {
        this.mPlacementId = placementId;
        this.mAdType = adType;
        this.mAdCount = 1;
    }

    protected void setAdCount(int adCount) throws IndexOutOfBoundsException {
        if (adCount > 5) {
            this.mAdCount = 5;
        } else if (adCount < 1) {
            this.mAdCount = 1;
        } else {
            this.mAdCount = adCount;
        }
    }

    /**
     * 所有的广告点击 都走这里
     */
    @Override
    public boolean startLandingPage(Context context, String admLandingUrl, AdsDTO adBean, DownUpPointBean pointBean) {
        if (adBean != null) {
            return PlatformUtil.startActivity(context, adBean, mAdType, admLandingUrl, pointBean);
        }
        return false;
    }

    @Override
    public void setAdListener(@NonNull InternalAdListener bridgeListener) {
        this.mBridgeListener = bridgeListener;
    }

    /**
     * 加载广告
     */
    public boolean loadAd(final String requestId) {
        /**
         * 申请广告
         */
        reset();

        AdLogUtil.adLoadLog( "start load ad...");

        /**
         * 广告请求信息
         */
        impBean = new AdxImpBean();
        impBean.adt = mAdType;
        impBean.pmid = mPlacementId;
        impBean.mAdCount = mAdCount;
        impBean.defaultAd = false;

        AdLogUtil.adLoadLog("start load ad...  当前环境 url = " + AdxServerConfig.getServerUrl());

        /**
         * 网络请求
         */
        adServerRequest = new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>() {
            @Override
            protected void onRequestSuccess(int statusCode, AdResponseBody response) {

                AdLogUtil.adLoadLog("start load ad...  impBean = " + impBean);

                if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                    AdLogUtil.adLoadLog("got data from net, response is :" + response.toString());

                    if (response.data != null
                            && response.data.ads != null
                            && response.data.ads.size() > 0) {
                        mAdBeans = response.data.ads;
                        if (!TextUtils.equals(response.data.codeSeatId, mPlacementId)) {
                            AdLogUtil.adLoadLog("response pmid is diffrent with request's");

                            if (mBridgeListener != null) {
                                mBridgeListener.onError(TaErrorCode.RESPONSE_PMID_DIFFRENT_ERROR);
                            }
                            return;
                        }
                        if (mAdType != response.data.getCodeSeatType()) {
                            AdLogUtil.adLoadLog("response adt is diffrent with request's");

                            if (mBridgeListener != null) {
                                mBridgeListener.onError(TaErrorCode.RESPONSE_ADT_DIFFRENT_ERROR);
                            }
                            return;
                        }
                        Iterator<AdsDTO> it = mAdBeans.iterator();
                        while (it.hasNext()) {
                            final AdsDTO adBean = it.next();
                            if (adBean == null) {
                                AdLogUtil.adLoadLog("ad is null,remove from list");

                                it.remove();
                                continue;
                            }
                            if (adBean.getCodeSeatType() == AdType.NATIVE
                                    && (adBean.nativeBean == null
                                    || adBean.nativeBean.mainImages == null
                                    || adBean.nativeBean.mainImages.size() == 0
                                    || TextUtils.isEmpty(adBean.nativeBean.mainImages.get(0).url))) {
                                AdLogUtil.adLoadLog("Native ad's image is empty,remove from list");

                                it.remove();
                                continue;
                            }
                            adBean.codeSeatId = response.data.codeSeatId;
                            adBean.codeSeatType = response.data.getCodeSeatType();
                            adBean.rid = response.data.requestId;
                            adBean.fill_ts = System.currentTimeMillis();
                            adBean.cacheTime = response.data.getCacheTime();
                            adBean.isDefaultAd = 0;
                            adBean.abTest = response.data.abTest;
                            adBean.extInfo = response.data.extInfo;
                        }
                        if (mBridgeListener != null) {
                            if (mAdBeans.size() > 0) {
                                mBridgeListener.onAdResponse(mAdBeans);
                            } else {
                                mBridgeListener.onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
                            }
                        }

                    } else {
                        /**
                         * 没有AD数据
                         */
                        AdLogUtil.adLoadLog("a ds list is empty");

                        if (mBridgeListener != null) {
                            mBridgeListener.onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
                        }
                    }
                } else {
                    /**
                     * 业务错误
                     */
                    AdLogUtil.adLoadLog("业务错误 --> " + response != null ? "error,response code is :" + response.getCode() + "," + "response msg is " + response.message : "error, response is null");

                    if (mBridgeListener != null) {
                        if (response != null) {
                            mBridgeListener.onError(new TaErrorCode(response.getCode(), response.message));
                        } else {
                            mBridgeListener.onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_1, "response is null"));
                        }
                    }
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                if (mBridgeListener != null) {
                    mBridgeListener.onError(adError);
                }

                if (null != adError) {
                    AdLogUtil.adLoadLog("load ad error adError=" + adError.getErrorMessage());
                }
            }

        }).setPostBody(new AdServerRequest.IAdPostBody() {
            @Override
            public String getPostBody() {
                return PostBody.getAdPostBody(impBean,requestId);
            }
        })
                .setDebug(SspAd.isDebug())
                .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getServerApi())
                .setPlacementId(mPlacementId);
        if (adServerRequest != null) {
            adServerRequest.netRequestPreExecute();
        }
        return true;
    }

    /**
     * 重置
     */
    private void reset() {
        if (adServerRequest != null) {
            AdLogUtil.adLoadLog( "Called AdxBannerView more than once. Auto reset request.");

            adServerRequest.cancelRequest();
            adServerRequest = null;
        }
    }


    @Override
    public long getResidualExpirationTime() {
        return Constants.NO_CACHE_EXPIRA_TIME;
    }

    /**
     * 销毁view
     */
    @Override
    public void destroy() {
        reset();
        mBridgeListener = null;
        AdLogUtil.adLoadLog( "adx ad destroy");
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
    }

    @Override
    public AAdChoicesView getAdChoicesView(Context context, AdsDTO adsDTO) {
        return getAdChoicesView(context, adsDTO, true);
    }

    //adchocieview的宽高
    private int width, height;

    /**
     * 创建AdChocieView
     *
     * @param context
     * @param isBig
     * @return
     */
    private AAdChoicesView createAdChoicesView(Context context, boolean isBig) {
        AAdChoicesView adChoicesView = new AAdChoicesView(context);

        //设置adChoicesView大小
        width = height = ScreenUtil.dip2px(Constants.adChoiceViewSizeBig);//正常尺寸adChoicesView
        if (!isBig) {
            width = height = ScreenUtil.dip2px(Constants.adChoiceViewSize);//小尺寸adChoicesView
        }

        if (adChoicesView.getLayoutParams() == null) {
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(width, height);
            adChoicesView.setLayoutParams(layoutParams);
            adChoicesView.setMinimumWidth(width);
            adChoicesView.setMinimumHeight(height);
        }
        AdLogUtil.adChoicesLog("AdChoice is create!!!width-" + width + "-height-" + height);
        return adChoicesView;
    }

    @Override
    public AAdChoicesView getAdChoicesView(Context context, final AdsDTO adsDTO, final boolean isBig) {
        if (null == context) {
            return null;
        }
        if (adsDTO != null && adsDTO.getACReady() != null && adsDTO.getACReady()) {
            AdLogUtil.adChoicesLog("AdChoice is ready!!!  开始加载 ");
            final AAdChoicesView adChoicesView = createAdChoicesView(context, isBig);
            ImageDownloadHelper.loadImageView(adsDTO.adChoiceImageUrl, adChoicesView, adsDTO, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached() {
                    //设置adChoicesView大小
                    if (adChoicesView.getDrawable() != null) {
                        width = adChoicesView.getDrawable().getIntrinsicWidth() * height / adChoicesView.getDrawable().getIntrinsicHeight();
                    }

                    if (adChoicesView.getLayoutParams() != null && width != 0 && height != 0) {
                        adChoicesView.getLayoutParams().width = width;
                        adChoicesView.getLayoutParams().height = height;
                        adChoicesView.setMinimumWidth(width);
                        adChoicesView.setMinimumHeight(height);
                    }

                    AdLogUtil.adChoicesLog("AdChoice is resize!!! width-" + width + "-height-" + height);
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {

                }
            });

            adChoicesView.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    PlatformUtil.startPageByWebView(CoreUtil.getContext(), adsDTO.adChoiceClickUrl);
                    if (mBridgeListener != null) mBridgeListener.onAdChoiceClick();
                }
            });

            return adChoicesView;
        }

        AdLogUtil.adChoicesLog("AdChoice is not ready!!!   adsDTO == null && adsDTO.isACReady == null && adsDTO.isACReady");
        return null;
    }
}
