package com.cloud.hisavana.sdk.common.constant;

/**
 * @author: wenjing.luo
 * @date: 2021/08/09
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class Constants {
    public interface ResponseCode {
        /**
         * 业务成功
        a */
        int BUSINESS_SUCCESS_CODE = 0;
    }

    public interface HOST {
        //TEST环境
        String ADN_TEST_SERVER_ADDRESS = "http://api.test.hisavana.com";
        //DEV环境
        String ADN_DEV_SERVER_ADDRESS = "http://10.150.109.97:8081";
        //MOCK数据地址
//        String ADN_TEST_SERVER_ADDRESS = "http://mock-tmc.shalltry.com/mock/612f2bd843705e112b38e3b8/ssp-mock";
        //RELEASE环境
        String ADN_RELEASE_SERVER_ADDRESS = "https://api.hisavana.com";
        String API = "/isavana/trafficdispatch/v1/consumer-not-login/addispatch/query/getAdData";
    }

    public interface AdBannerSize {
        /**
         * 320x50
         */
        int AD_BANNER_SIZE_320x50 = 0;
        /**
         * 320x100
         */
        int AD_BANNER_SIZE_320x100 = 1;
        /**
         * 320x200
         */
        int AD_BANNER_SIZE_320x200 = 2;
        /**
         * 自适应
         */
        int AD_BANNER_SIZE_300x250 = 3;
    }

    public static int adChoiceViewSize = 9;
    public static int adChoiceViewSizeBig = 17;
    //代码位类型，1 native，2 banner，3插屏， 4 开屏
    public interface AdType{
        /**
         * Banner广告类型
         */
        int BANNER = 2;
        /**
         * 插屏广告类型
         */
        int INTERSTITIAL = 3;
        /**
         * Native广告类型
         */
        int NATIVE = 1;
        /**
         * Splash-Native广告类型
         */
        int SPLASH_NATIVE = 4;
    }

    public static String ACTION_INTERSTITIAL_PREIMP= "_pre_imp";
    public static String ACTION_INTERSTITIAL_SHOW = "_show";
    public static String ACTION_INTERSTITIAL_ERROR = "_error";
    public static String ACTION_INTERSTITIAL_CLOSE = "_close";
    public static String ACTION_INTERSTITIAL_CLICK = "_click";
    public static String ACTION_INTERSTITIAL_ADCHOICE_CLICK = "_adchoice_click";
    /**
     * 约定无缓存是返回1
     */
    public static final long NO_CACHE_EXPIRA_TIME = 1;

    public interface LoadType {

        int CACHE = 0;
        int NET = 1;
    }
    /**
     * Media类型
     */
    public interface MIME{

        int IMG = 1;
        int GIF = 2;
        int VIDEO = 3;
    }

    public static final String JAVASCRIPT_INTERFACE = "VideoLoadInterface";

    /**
     * MediaView Tag
     */
    public interface ImageTag {

        String IMAGE_WEBVIEW = "image_webview";

        String ADX_CHOICE = "adxAdChoice";

        String DEFULT_BG = "#000000";
    }


    /**
     * MediaView Tag
     */
    public interface ImageLoadType {

        // 1 no cache/memory || 2 cache no memory || 3 cache memory

        int IMAGE_RAM_INCLUDED = 1;

        int IMAGE_PARSE = 2;

        int IMAGE_DISK_INCLUDED = 3;
    }

    public interface Config{
        String ALLOW_SKIP_OUT = "isAllowSkipOut";
        boolean ALLOW_SKIP_OUT_DEFAULT = true;
        String SENSITIVE_KEYWORDS = "sensitive_keywords";
    }

    public final static String PREF_NEW_CLOUD_CONTROL_VERSION = "new_config_ver";
    public final static String CLOUD_CONTROL_VERSION = "cloudControlVersion";

    /**
     * 保存 手机本地时间戳和 服务器差值
     */
    public final static String SERVICES_TIME_DIFFERENCE_VALUE="services_time_difference_value";
}
