/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http.listener;

import android.util.Log;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.listener.ResponseBaseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.json.Tson;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;

public abstract class CommonResponseListener<E>
extends ResponseBaseListener {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String UTF8_BOM = "\ufeff";

    protected CommonResponseListener() {
    }

    protected abstract void onRequestSuccess(int var1, E var2);

    public void onServerRequestSuccess(int statusCode, String response) {
        this.parseResponse(statusCode, response);
    }

    private void parseResponse(final int statusCode, String responseString) {
        try {
            AdLogUtil.LOG.d((Object)("post responseString :" + responseString));
            Type superclass = this.getClass().getGenericSuperclass();
            if (!(superclass instanceof ParameterizedType)) {
                throw new RuntimeException("Missing type parameter.");
            }
            ParameterizedType parameterized = (ParameterizedType)superclass;
            Type type = parameterized.getActualTypeArguments()[0];
            Object bean = null;
            if ("class java.lang.String".equals(type.toString())) {
                bean = responseString;
            } else if (type instanceof Class) {
                bean = Tson.fromJson((String)responseString, (Class)((Class)type));
            }
            final String final_bean = bean;
            if (final_bean instanceof AdResponseBody && null != ((AdResponseBody)((Object)final_bean)).data) {
                String tt = ((AdResponseBody)((Object)final_bean)).data.time;
                try {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                    long defaultAdExpirationTime = format.parse(tt).getTime();
                    AdxPreferencesHelper.getInstance().putLong("services_time_difference_value", System.currentTimeMillis() - defaultAdExpirationTime);
                }
                catch (Exception e2) {
                    AdLogUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e2));
                }
                AdxPreferencesHelper.getInstance().putString("services_time", tt);
            }
            if (this.handler != null) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        CommonResponseListener.this.onRequestSuccess(statusCode, final_bean);
                    }
                });
            } else {
                this.onRequestSuccess(statusCode, final_bean);
            }
        }
        catch (Throwable e3) {
            e3.printStackTrace();
            AdLogUtil.netLog(Log.getStackTraceString((Throwable)e3));
            AdLogUtil.netLog("\u89e3\u6790\u7f51\u7edc\u8bf7\u6c42\u6570\u636e\u5f02\u5e38 --> CommonResponseListener --> parseResponse --> catch");
            this.onRequestError(TaErrorCode.AD_DATA_PARSE_RESPONSE_ERROR);
        }
    }

    private String getResponseString(byte[] stringBytes, String charset) throws UnsupportedEncodingException {
        String toReturn;
        String string2 = toReturn = stringBytes == null ? null : new String(stringBytes, charset);
        if (toReturn != null && toReturn.startsWith(UTF8_BOM)) {
            return toReturn.substring(1);
        }
        return toReturn;
    }
}

