/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.annotation.SuppressLint;
import android.location.Location;
import android.location.LocationManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.CoreUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GPSTracker {
    private Location location;
    private double latitude;
    private double longitude;
    private int accu = 0;
    private long coordTime = 0L;
    private String coordTimeStr = "";
    protected LocationManager locationManager;

    public GPSTracker() {
        this.getLocation();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public int getAccu() {
        return this.accu;
    }

    public long getCoordTime() {
        return this.coordTime;
    }

    public String getCoordTimeStr() {
        return this.coordTimeStr;
    }

    @SuppressLint(value={"MissingPermission"})
    private void getLocation() {
        try {
            if (CoreUtil.getContext() != null) {
                this.locationManager = (LocationManager)CoreUtil.getContext().getSystemService("location");
                boolean isGPSEnabled = this.locationManager.isProviderEnabled("gps");
                boolean isNetworkEnabled = this.locationManager.isProviderEnabled("network");
                if (!isGPSEnabled && !isNetworkEnabled) {
                    return;
                }
                boolean canGetLocation = true;
                if (isGPSEnabled && this.locationManager != null) {
                    AdLogUtil.LOG.d((Object)"Positioning through the GPS");
                    this.location = this.locationManager.getLastKnownLocation("gps");
                    this.updateGPSCoordinates(this.location);
                }
                if (isNetworkEnabled && this.location == null) {
                    AdLogUtil.LOG.d((Object)"Positioning through the network");
                    if (this.locationManager != null) {
                        this.location = this.locationManager.getLastKnownLocation("network");
                        this.updateGPSCoordinates(this.location);
                    }
                }
            }
        }
        catch (Throwable e2) {
            AdLogUtil.LOG.d((Object)"Location Impossible to connect to LocationManager");
        }
        if (this.location != null) {
            this.updateGPSCoordinates(this.location);
        }
    }

    private void updateGPSCoordinates(Location location) {
        if (location != null) {
            this.latitude = location.getLatitude();
            this.longitude = location.getLongitude();
            this.accu = (int)location.getAccuracy();
            this.coordTime = location.getTime();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(this.coordTime);
                this.coordTimeStr = format.format(date);
            }
            catch (Exception e2) {
                AdLogUtil.LOG.e((Object)e2.getMessage());
            }
        }
    }
}

