package com.cloud.hisavana.sdk.ad;

import com.cloud.hisavana.sdk.ad.base.AdxBaseAd;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.adapter.INative;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.constant.Constants;

import java.util.List;

/**
 * 聚合原生广告
 *
 * @author 孙志刚.
 * @date 2016/12/9.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AdxNative extends AdxBaseAd implements INative {

    /**
     * 构造方法
     *
     * @param placementId
     */
    public AdxNative(String placementId) {
        super(placementId, Constants.AdType.NATIVE);
    }

    @Override
    public void setAdCount(int adCount) {
        super.setAdCount(adCount);
    }

    @Override
    public List<TaNativeInfo> getNativeInfoList(List<AdsDTO> adBeanList) {
        if (adBeanList != null) {
            return PlatformUtil.getTadNativeInfoList(adBeanList);
        }
        return null;
    }
}
