package com.cloud.hisavana.sdk.data.bean.response;


import com.transsion.json.annotations.TserializedName;

import java.io.Serializable;
import java.util.List;

/**
 *
 * Created by jianbing.yu on 2018/8/30.
 */

public class NativeBean implements Serializable {


    public String version;
    public Integer rating;
    public TitleDTO title;
    public DescriptDTO descript;
    public ButtonDTO button;
    public LogoDTO logo;
    @TserializedName(name = "mainImages")
    public List<MainImagesDTO> mainImages;

    public Integer getRating() {
        return rating == null ? 0 : rating;
    }

    public static class TitleDTO implements Serializable {
        public String text;
    }

    public static class ButtonDTO implements Serializable{
        public String text;
    }
    public static class LogoDTO implements Serializable{
        public String url;
        public Integer width;
        public Integer height;

    }

    public static class DescriptDTO implements Serializable{
        public String text;

        @Override
        public String toString() {
            return "DescriptDTO{" +
                    "text='" + text + '\'' +
                    '}';
        }
    }

    public static class MainImagesDTO implements Serializable{
        public String url;
        public Integer width;
        public Integer height;

        @Override
        public String toString() {
            return "MainImagesDTO{" +
                    "url='" + url + '\'' +
                    ", width=" + width +
                    ", height=" + height +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "NativeBean{" +
                "version='" + version + '\'' +
                ", rating=" + rating +
                ", title=" + title +
                ", descript=" + descript +
                ", button=" + button +
                ", logo=" + logo +
                ", mainImages=" + mainImages +
                '}';
    }
}
