package com.cloud.hisavana.sdk.internal.interstitial;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.listener.AdListener;
import com.cloud.hisavana.sdk.common.activity.TAdActivity;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.InterstitialBean;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.transsion.core.CoreUtil;

import java.lang.ref.WeakReference;

/**
 * Created by jianbing.yu on 2019/3/27.
 */
public class InterstitialGemini {

    private InterstitialAdBroadcastReceiver receiver;
    private InterstitialBean mInterstitialBean = null;
    private TranInterstitial mInterstitial;
    private AdsDTO mAdBean;


    // =============================================================================================


    public InterstitialGemini(TranInterstitial interstitial) {
        this.mInterstitial = interstitial;
    }

    /**
     * 插屏广告是一个独立的Activity 这里用广播通讯
     */
    private static class InterstitialAdBroadcastReceiver extends BroadcastReceiver {

        private WeakReference<InterstitialGemini> weakReference;
        private WeakReference<AdListener> listener;

        InterstitialAdBroadcastReceiver(InterstitialGemini gemini, AdListener tAdListener) {
            weakReference = new WeakReference<>(gemini);
            listener = new WeakReference<>(tAdListener);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                String action = intent.getAction();
                if (action == null) {
                    return;
                }
                InterstitialGemini gemini = weakReference.get();
                if (gemini != null) {
                    if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK)) {
                        AdLogUtil.LOG.d("receive interstitial click");
                        if (weakReference.get() != null) {
                            String admLandingUrl = intent.getStringExtra(TAdActivity.LANDING_URL);
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            if (!TextUtils.isEmpty(admLandingUrl)) {
                                weakReference.get().clickToAdmLandingPage(admLandingUrl, pointBean);
                            } else {
                                weakReference.get().clickToLandingPage(pointBean);
                            }
                        }

                        if (listener.get() != null) {
                            DownUpPointBean pointBean = (DownUpPointBean) intent.getSerializableExtra("pointBean");
                            listener.get().onAdClicked(pointBean);
                        }

                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE)) {
                        AdLogUtil.LOG.d("receive interstitial ad_close");
                        if (listener.get() != null) {
                            listener.get().onAdClosed();
                            gemini.unRegisterInterstitalAdReceiver();
                            gemini.receiver = null;
                        }
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR)) {
                        AdLogUtil.LOG.d("receive interstitial error");
                        if (listener.get() != null) {
                            listener.get().onError(new TaErrorCode(intent.getIntExtra(TAdActivity.ERROR_CODE, TaErrorCode.UNKNOWN_ERROR_CODE_2),
                                    intent.getStringExtra(TAdActivity.ERROR_MSG)));
                        }
                        gemini.unRegisterInterstitalAdReceiver();
                        gemini.receiver = null;
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW)) {
                        AdLogUtil.LOG.d("receive interstitial show");
                        //gemini.mInterstitial.polyInterstitial().impressionTrack(gemini.mAdBean);
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP)) {
                        AdLogUtil.LOG.d("receive interstitial pre impression");
                    } else if (action.equals(gemini.getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK)) {
                        AdLogUtil.LOG.d("receive interstitial adchocie click");
                        if (listener.get() != null) listener.get().onAdChoiceClick();
                    }
                }
            }
        }
    }


    // =============================================================================================


    private void clickToLandingPage(DownUpPointBean pointBean) {
        mInterstitial.polyInterstitial().startLandingPage(CoreUtil.getContext(), null, mAdBean, pointBean);
    }

    private void clickToAdmLandingPage(String url, DownUpPointBean pointBean) {
        mInterstitial.polyInterstitial().startLandingPage(CoreUtil.getContext(), url, mAdBean, pointBean);
    }


    // =============================================================================================


    public void loadAd() {
        mAdBean = mInterstitial.adBean();
        if (mAdBean != null) {
            mInterstitialBean = new InterstitialBean();
            mInterstitialBean.setDpl(mAdBean.deepLinkUrl);
            mInterstitialBean.adChoiceClickUrl = mAdBean.adChoiceClickUrl;
            mInterstitialBean.adChoiceImageUrl = mAdBean.adChoiceImageUrl;
            mInterstitialBean.setBroadCastPrefix(getBroadCastPrefix());
            if (!TextUtils.isEmpty(mAdBean.imageUrl)) {  //图片插屏
                mInterstitialBean.setRenderContent(mAdBean.imageUrl);
                AdLogUtil.LOG.d("imageView impression");
                ImageDownloadHelper.downloadImage(mAdBean.imageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                    @Override
                    public void onImagesCached() {
                        if (mInterstitial.adListener() != null) {
                            mInterstitial.adListener().onAdLoaded();
                        }
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        if (mInterstitial.adListener() != null) {
                            mInterstitial.adListener().onError(errorCode);
                        }
                    }
                });
            } else {
                if (mInterstitial.adListener() != null) {
                    mInterstitial.adListener().onError(TaErrorCode.INVALID_CRVT_TYPE);
                }
            }
        } else {
            if (mInterstitial.adListener() != null) {
                mInterstitial.adListener().onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_2, "mAdBean is null"));
            }
        }
    }

    public void show() {
        if (mAdBean != null) {

            if (receiver == null) {
                receiver = new InterstitialAdBroadcastReceiver(InterstitialGemini.this, mInterstitial.adListener());
            }
            registerInterstitialAdReceiver();

            Intent intent = new Intent(CoreUtil.getContext(), TAdActivity.class);
            intent.setFlags(Intent.FLAG_ACTIVITY_NO_ANIMATION | Intent.FLAG_ACTIVITY_NEW_TASK);
            intent.putExtra("InterstitialBean", mInterstitialBean);
            intent.putExtra("mAdBean", mAdBean);
            CoreUtil.getContext().startActivity(intent);
        }
    }

    private void registerInterstitialAdReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLICK);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_CLOSE);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_SHOW);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_PREIMP);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ERROR);
        intentFilter.addAction(getBroadCastPrefix() + Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK);
        CoreUtil.getContext().registerReceiver(receiver, intentFilter);
        AdLogUtil.LOG.d("registerInterstitialAdReceiver");
    }

    public void destroy() {
        unRegisterInterstitalAdReceiver();
        AdLogUtil.LOG.d("destroy");
    }

    private String getBroadCastPrefix() {
        return mInterstitial.polyInterstitial().getBroadCastPrefix(mAdBean);
    }

    private void unRegisterInterstitalAdReceiver() {
        if (receiver != null) {
            CoreUtil.getContext().unregisterReceiver(receiver);
            receiver = null;
        }
    }
}
