/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;

public class DrawableUtil {
    public static int getDrawableWidth(Drawable drawable2, int def) {
        if (drawable2 != null) {
            if (drawable2 instanceof BitmapDrawable) {
                if (((BitmapDrawable)drawable2).getBitmap() == null) {
                    return def;
                }
                int width = ((BitmapDrawable)drawable2).getBitmap().getWidth();
                AdLogUtil.LOG.d((Object)("BitmapDrawable width:=" + width));
                return width > 0 ? width : 0;
            }
            if (drawable2 instanceof Drawable) {
                int width = drawable2.getIntrinsicWidth();
                AdLogUtil.LOG.d((Object)("Drawable width:=" + width));
                return width > 0 ? width : 0;
            }
        }
        return def;
    }

    public static int getDrawableHeight(Drawable drawable2, int def) {
        if (drawable2 != null) {
            if (drawable2 instanceof BitmapDrawable) {
                Bitmap bitmap = ((BitmapDrawable)drawable2).getBitmap();
                if (bitmap != null) {
                    int height = bitmap.getHeight();
                    AdLogUtil.LOG.d((Object)("BitmapDrawable height:=" + height));
                    return height > 0 ? height : 0;
                }
            } else if (drawable2 instanceof Drawable) {
                int height = drawable2.getIntrinsicHeight();
                AdLogUtil.LOG.d((Object)("Drawable height:=" + height));
                return height > 0 ? height : 0;
            }
        }
        return def;
    }
}

