package com.cloud.hisavana.sdk.internal.banner;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.widget.TAdWebView;

/**
 * 传音banner类广告
 *
 * @author 孙志刚.
 * @date 2016/12/12.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BannerGemini {

    private ImageView imageView;
    private TAdWebView webview;
    private long oldTime;
    private TranBanner mBannerView;
    private AdsDTO mAdBean = null;

    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;


    // =============================================================================================


    public BannerGemini(TranBanner bannerView) {
        this.mBannerView = bannerView;
    }

    public View getBannerView(final Context context) {
        mAdBean = mBannerView.adBean();
        if (mAdBean != null) {
            if (!TextUtils.isEmpty(mAdBean.imageUrl)) {
                if (imageView == null) {
                    imageView = new ImageView(context);
                }

                AdLogUtil.LOG.d("imageview impression");
                ImageDownloadHelper.downloadImage(mAdBean.imageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                    @Override
                    public void onImagesCached() {
                        if (mBannerView.adListener() != null) {
                            mBannerView.adListener().onAdLoaded();
                        }
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        if (mBannerView.adListener() != null) {
                            mBannerView.adListener().onError(errorCode);
                        }
                    }
                });

                // 点击事件
                imageView.setOnTouchListener(new TAdOnTouchListener());
                imageView.setOnClickListener(new TAdImageOnClickListener());

                //预加载AdChoiceImgUrl
                downloadAdChoice();
                return imageView;
            } else {
                AdLogUtil.LOG.e("Not found the render type");
            }
        }
        return null;
    }

    /**
     * 下载AdChoices
     */
    public void downloadAdChoice() {
        if (!TextUtils.isEmpty(mAdBean.adChoiceImageUrl)) {
            AdLogUtil.LOG.d("textView impression");
            ImageDownloadHelper.downloadImage(mAdBean.adChoiceImageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached() {
                    mAdBean.isACReady = true;
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {
                    mAdBean.isACReady = false;
                }
            });
        } else {
            AdLogUtil.LOG.e("Not found adChoiceImageUrl");
        }
    }

    /**
     * 展示广告
     */
    public void showAd() {
        if (imageView != null) {
            DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener() {
                @Override
                public void onRequestSuccess(int statusCode, AdImage adMedia) {
                    AdLogUtil.LOG.d("bind drawable to imageView success");
                    mBannerView.attachBannerToViewTree(adMedia);
                }

                @Override
                protected void onRequestError(TaErrorCode adError) {
                    AdLogUtil.LOG.d("bind drawable to imageView failed, code: " + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
                }
            }).setUrl(mAdBean.imageUrl).setAdsDTO(mAdBean, AthenaTracker.M_TYPE_LARGE_IMG);
            downLoadRequest.netRequestPreExecute();
        }
    }

    public void destroy() {
        AdLogUtil.LOG.d("Destroy gemini banner ad.");
        if (imageView != null) {
            if (imageView.getDrawable() != null) {
                if (imageView.getDrawable() instanceof BitmapDrawable) {
                    BitmapDrawable bd = (BitmapDrawable) imageView.getDrawable();
                    if (bd != null) {
                        Bitmap bitmap = bd.getBitmap();
                        if (bitmap != null && !bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                    }
                    imageView.setImageDrawable(null);
                } else if (imageView.getDrawable() instanceof Drawable) {
                    imageView.setImageDrawable(null);
                }
            }
        }
        if (webview != null) {
            webview.stopLoading();
            webview.removeAllViews();
            webview.destroy();
            if (webview.getParent() != null) {
                ((ViewGroup) webview.getParent()).removeView(webview);
            }
            webview = null;
        }
        AdLogUtil.LOG.d("destroy");
    }


    // =============================================================================================


    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

            }
            return false;
        }
    }

    private class TAdImageOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View view) {
            asyncAction(view, null);
        }
    }

    private void asyncAction(View view, String landingUrl) {
        try {
            if (mAdBean != null) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - oldTime > 2 * 1000) {  //防止重复点击

                    mBannerView.polyBanner().startLandingPage(view.getContext(),
                            landingUrl, mAdBean, new DownUpPointBean(downX, downY, upX, upY,
                                    view.getMeasuredHeight(), view.getMeasuredWidth()));
                    if (mBannerView.adListener() != null) {
                        mBannerView.adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                view.getMeasuredHeight(), view.getMeasuredWidth()));
                    }
                    oldTime = currentTime;
                }
            }
        } catch (Throwable e) {
            AdLogUtil.LOG.e(e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

}
