package com.cloud.hisavana.sdk.internal.banner;

import android.content.Context;
import android.graphics.Matrix;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.AdxAdFactory;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.IBanner;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DrawableUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.base.BaseAd;
import com.transsion.core.utils.ScreenUtil;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/25.
 */

public class TranBanner extends BaseAd {

    BannerGemini mBannerPlatform;
    private AdsDTO mAdBean = null;
    private ViewGroup mViewGroup;
    private Context mContext;
    private View mRenderView = null;
    private IBanner mBanner;

    //ad标识和adchoice的位置
    private int rightMargin;
    private int topMargin;
    private boolean isBig = false;


    // =============================================================================================


    CallbackStub mStub = new CallbackStub() {

        @Override
        protected void onAdResponse(List<AdsDTO> adBeanList) {
            if (mAdBean != null) {
                MeasureSessionManager.getInstance().destroySession(mAdBean);
            }
            mAdBean = adBeanList.get(0);
            if (mAdBean == null) {
                AdLogUtil.LOG.e("mAdBean is null,terminate flow");
                return;
            }

            loadPlatformAd();
        }
    };

    /**
     * 渲染Banner界面
     */
    private void loadPlatformAd() {
        mRenderView = mBannerPlatform.getBannerView(mContext);
        AdLogUtil.LOG.d("start load ad");
    }

    /**
     * 曝光测量 回调
     */
    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<AdsDTO>() {
        @Override
        public void onViewImpressed(AdsDTO adBean) {
            AdLogUtil.LOG.d("view has impression,start report track---------------------------------");
            if (adListener() != null) {
                adListener().onAdShow();
            }
        }
    };


    // =============================================================================================


    public TranBanner(Context context, ViewGroup viewGroup, String placementId) {
        super(Constants.AdType.BANNER, placementId);
        this.mViewGroup = viewGroup;
        this.mContext = context.getApplicationContext();

        mBanner = AdxAdFactory.newInstance().getBanner(placementId);
        mBanner.setAdListener(mInternalListener);
        mBannerPlatform = new BannerGemini(this);
    }


    // =============================================================================================


    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mBanner.setPlacementId(placementId);
    }

    @Override
    protected CallbackStub callbackStub() {
        return mStub;
    }

    @Override
    protected boolean loadPolyAd() {
        if (mBanner.loadAd(mRequestId)) {
            if (mViewGroup != null) {
                mViewGroup.removeAllViews();
            }
            return true;
        }
        return false;
    }

    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                mBanner.destroy();
                TranBanner.super.destroy();
                if (mViewGroup != null) {
                    mViewGroup.removeAllViews();
                }
                mBannerPlatform.destroy();
                MeasureSessionManager.getInstance().destroySession(mAdBean);
            }
        });
    }

    @Override
    public int getAdType() {
        return Constants.AdType.BANNER;
    }


    // =============================================================================================


    AdsDTO adBean() {
        return mAdBean;
    }

    IBanner polyBanner() {
        return mBanner;
    }

    /**
     * 展示回调
     */
    public void show() {
        Preconditions.checkIsOnMainThread();
        if (mViewGroup == null || mAdBean == null) {
            AdLogUtil.LOG.e("mViewGroup or mAdBean = null");
            return;
        }
        boolean isAdValid = isAdValid();
        //打底广告是否有效，是看打底广告的有效期
        if (isDefaultAd) isAdValid = true;
        if (isAdValid && !mShowed) {
            doImpressionLogic();
        } else if (isAdValid) {
            mShowed = false;
            MeasureSessionManager.getInstance().destroySession(mAdBean);
            doImpressionLogic();
        } else {
            AdLogUtil.LOG.e("ad not condition to use");
        }
    }

    // =============================================================================================


    /**
     * 在这里开始 组装 View
     *
     * @param adImage
     */
    void attachBannerToViewTree(AdImage adImage) {
        /**
         *  素材比例：3:2；20:3
         *  mAdchoiceView  24  15
         **/
        if (mAdBean == null || mViewGroup == null || mRenderView == null) {
            return;
        }

        // 获取图片的真实的宽高比 --> TODO 服务器下发的比例 ========= 这个后面修改
        final int imageWidth = DrawableUtil.getDrawableWidth(adImage.getDrawable(), 0);
        final int imageHeight = DrawableUtil.getDrawableHeight(adImage.getDrawable(), 0);

        if (imageWidth == 0 || imageHeight == 0) {
            AdLogUtil.LOG.e("TranBanner--imageWidth == 0 || imageHeight == 0");
            return;
        }

        // 默认 屏幕的宽度就是 父容器的宽度 --> 推出 容器的高度 TODO 直接从下发数据里面获取 广告位的比例
        int expectedWidth = Math.min(ScreenUtil.getWinWidth(), ScreenUtil.getWinHeight());
        int expectedHeight = (int) (imageHeight * ((float) expectedWidth / imageWidth));

        AdLogUtil.LOG.d("expectedWidth: " + expectedWidth + " px,expectedHeight: "
                + expectedHeight + " px, screen width is: " + ScreenUtil.getWinWidth());

        mViewGroup.removeAllViews();
        ((RelativeLayout) mViewGroup).setGravity(Gravity.CENTER);

        // TODO 这里做区分 =================================
        // TODO 测试 =================
        //
//        mRenderView=LayoutInflater.from(mViewGroup.getContext()).inflate(R.layout.banner_style_2_layout,mViewGroup,false);
//        ImageView ivBanner=mRenderView.findViewById(R.id.ivBanner);
//        adImage.attachView(ivBanner);

        // 当前广告的 adChoices
//       FrameLayout flAdChoices= mRenderView.findViewById(R.id.flAdChoices);
//       flAdChoices.addView(mBanner.getAdChoicesView(mContext, mAdBean, isBig));


        // 加载 布局样式
        mViewGroup.addView(mRenderView,
                ViewGroup.LayoutParams.MATCH_PARENT,
                expectedHeight);

        if (mRenderView instanceof ImageView) {
            ((ImageView) mRenderView).setScaleType(ImageView.ScaleType.FIT_CENTER);
            adImage.attachView((ImageView) mRenderView);
        }

        // TODO 这个后面设计会给图 统一用一种比例的 =======================================================
        // 动态加载 ad 和 adChoice
        ViewTreeObserver vto2 = mRenderView.getViewTreeObserver();
        vto2.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener() {
            @Override
            public void onGlobalLayout() {
                mRenderView.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                getDrawablePosition((ImageView) mRenderView);
                if (imageHeight != 0) isBig = imageWidth / imageHeight == 3 / 2;
                //广告来源
                setAdChoice();
                //添加广告标识
                addAdMark();
            }
        });

        if (mViewGroup.getBackground() != null) {
            mViewGroup.getBackground().setAlpha(0);
        }
        mViewGroup.setVisibility(View.VISIBLE);
        AdLogUtil.LOG.d("ad banner show...");
    }

    /**
     * 获取ad标识和adchoice的margin
     *
     * @param v
     */
    private void getDrawablePosition(final ImageView v) {
        // view的实际宽高
        float vWidth = v.getWidth();
        float vHeight = v.getHeight();

        // 得到imageview中的矩阵，准备得到drawable的拉伸比率
        Matrix m = v.getImageMatrix();
        float[] values = new float[10];
        m.getValues(values);

        // drawable的本身宽高
        if (v.getDrawable() == null) {
            return;
        }
        float dOriginalWidth = v.getDrawable().getIntrinsicWidth();
        float dOriginalHeight = v.getDrawable().getIntrinsicHeight();
        float dRatio = dOriginalWidth / dOriginalHeight;//如果大于1，表示drawable宽>高

        //Image在绘制过程中的变换矩阵，从中获得x和y方向的缩放系数  value[0],[4]
        //得到drawable的实际显示时的宽高
        int dWidth = (int) (dOriginalWidth * values[0]);
        int dHeight = (int) (dOriginalHeight * values[4]);

        //得到imageview的宽高和drawable的宽高的差值
        float w = vWidth - dWidth;
        float h = vHeight - dHeight;

        topMargin = (int) ((h / 2) + 0.5f);
        rightMargin = (int) ((w / 2) + 0.5f);
    }

    public boolean isAdValid(){
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice(){
        if(mAdBean != null){
            return mAdBean.getBidPrice();
        }
        return 0;
    }

    /**
     * 添加广告标识
     */
    private void addAdMark() {
        ImageView imageView = new ImageView(mContext);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(
                RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        if (isBig) {
            imageView.setImageResource(R.drawable.hisavana_ad_big);
        } else {
            imageView.setImageResource(R.drawable.hisavana_ad);
        }
        params.leftMargin = rightMargin + imageView.getWidth();
        params.topMargin = topMargin;
        mViewGroup.addView(imageView, params);
    }

    /**
     * 广告来源
     */
    private void setAdChoice() {
        //广告宽高比是3/2时 adchoiceview是24  广告宽高比是30/2时 adchoiceview是15
        AAdChoicesView choicesView = mBanner.getAdChoicesView(mContext, mAdBean, isBig);
        if (mViewGroup.indexOfChild(choicesView) < 0) {
            if (choicesView != null) {
                RelativeLayout.LayoutParams params;
                if (choicesView.getLayoutParams() != null) {
                    params = (RelativeLayout.LayoutParams) choicesView.getLayoutParams();
                } else {
                    params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                }
                params.addRule(RelativeLayout.ALIGN_PARENT_END);
                params.rightMargin = rightMargin;
                params.topMargin = topMargin;
                mViewGroup.addView(choicesView, params);
            }
        }
    }

    private void doImpressionLogic() {
        if (mRenderView != null && mLoaded && mAdBean != null) {
            MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
            session.setAdValid(AdsConfig.isAdValid(mAdBean));
            session.registerView(mRenderView, impressionListener);
            mBannerPlatform.showAd();
        } else {
            AdLogUtil.LOG.e("no ad show, set visible gone");
            mViewGroup.setVisibility(View.GONE);
        }
    }


}
