package com.cloud.hisavana.sdk.ad;

import android.os.Bundle;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.ad.base.AdxBaseAd;
import com.cloud.hisavana.sdk.ad.base.AdxDefault;
import com.cloud.hisavana.sdk.ad.base.PostBody;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.athena.TrackingKeySsp;
import com.cloud.hisavana.sdk.common.util.BlurBgUtils;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.DiskAdBean;
import com.cloud.hisavana.sdk.data.control.AdBodyPersistenceHelper;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.adapter.ISplash;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.transsion.json.Tson;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by jianbing.yu on 2019/3/7.
 */
public class AdxSplash extends AdxBaseAd implements ISplash {

    /**
     * 当前是不是打底广告
     */
    private boolean isDefaultAd = false;

    public AdxSplash(String placementId) {
        super(placementId, Constants.AdType.SPLASH_NATIVE);
    }

    private int adListSize = 0; // 当前缓存的广告条数  用于判断是否需要网络请求更多的数据

    @Override
    public int getAdListSize() {
        return adListSize;
    }

// =============================================================================================


    /**
     * 重写父类的方法
     *
     * @return
     */
    @Override
    public boolean loadAd(final String requestId) {
        AdsDTO adItem = null;
        adListSize = 0;
        if (isDefaultAd) {
            //打底广告
            List<AdsDTO> adsDTOS = AdxDefault.getDefaultAdItem(mPlacementId, true);
            if (adsDTOS.size() > 0) {
                adItem = adsDTOS.get(0);
                AdLogUtil.splashLog("打底广告");
                //判断广告类型是否一样
                if (adItem != null && adItem.codeSeatType != Constants.AdType.SPLASH_NATIVE) {
                    AdLogUtil.splashLog("AdxSplash --> loadAd() -->打底广告类型不一致");
                    return false;
                }
            }
        } else {
            // 从缓存中获取广告数据
            adItem = getSplashItem(mPlacementId);
        }

        AdLogUtil.splashLog("AdxSplash --> loadAd() --> 从缓存中获取到广告 adItem=" + adItem);

        if (adItem != null) {
            List<AdsDTO> adBeanList = new ArrayList<>();
            adBeanList.add(adItem);
            // 从缓存中获取到数据
            AdLogUtil.splashLog("AdxSplash --> loadAd() --> 获取到缓存数据 getSplashItem --> adItem=" + adItem.toString());
            mBridgeListener.onSplashCacheGet(adBeanList);
            return true;
        }

        return false;
    }


    // =============================================================================================


    @Override
    public AdsDTO getSplashItem(String key) {
        String jsonStr = AdBodyPersistenceHelper.getInstance().getString(key, null);
        AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 从缓存中 获取数据 key=" + key + " jsonStr=" + jsonStr);

        if (!TextUtils.isEmpty(jsonStr)) {
            try {
                // 数据容器
                List<AdsDTO> list = new ArrayList<>();
                // 1.取出数据
                DiskAdBean diskAdBean = Tson.fromJson(jsonStr, DiskAdBean.class);
                // 判空
                if (diskAdBean == null) {
                    return null;
                }
                List<AdsDTO> dtoList = diskAdBean.list;
                if (dtoList == null) {
                    return null;
                }
                AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 获取全量数据 list.size()=" + dtoList.size());
                // 2.过期排查
                AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 检查一下是否过期 获取没有过期的数据 ");
                for (AdsDTO ob : dtoList) {
                    if (ob == null) {
                        continue;
                    }
                    if (isAdValid(ob)) {
                        list.add(ob);
                    } else {
                        BlurBgUtils.deleteBlurBgFromFile(ob.imageUrl);
                        AdLogUtil.splashLog("广告过期了 --> id=" + ob.id);
                    }
                }
                // 没有获取到数据 返回 null
                if (list.size() < 1) {
                    AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 没有获取到数据 返回 null ");
                    //return null;
                }

                // 5.保存一下 当前全局的广告素材的数量
                adListSize = list.size();
                AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 保存一下 当前全局的广告素材的数量 TranSplash.adListSize=" + adListSize);

                // 优化
                if (list.size() == dtoList.size()) {
                    AdLogUtil.splashLog("都没有过期 --> 直接返回第一个数据");
                    return list.get(0);
                }

                // 4.将检查后的数据保存起来
                if (SplashNetRequest.cacheSplashList(key, list, false)) {
                    AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 将检查过后的数据保存起来 --> 去除过期的数据 --> 覆盖保存");
                    return list.get(0);
                }

            } catch (Throwable e) {
                e.printStackTrace();
                AdLogUtil.splashLog("AdxSplash --> getSplashItem() --> 解析异常 mag=" + e.getMessage());
            }
        }
        return null;
    }

    @Override
    public void setDefaultAd(boolean defaultAd) {
        isDefaultAd = defaultAd;
    }

    /**
     * 广告有效
     */
    private boolean isAdValid(AdsDTO adItem) {
        return AdsConfig.isAdValid(adItem);
    }


    // =============================================================================================


    /**
     * 内部类 请求网络+获取本地缓存
     */
    public static class SplashNetRequest {

        private static AdServerRequest sAdServerRequest = null;

        /**
         * 缓存 List 数据
         *
         * @param placementId
         * @param adItem
         * @return
         */
        public static boolean cacheSplashList(String placementId, List<AdsDTO> adItem, boolean isNetwork) {
            boolean flag = true;

            if (adItem != null) {
                try {
                    DiskAdBean diskAdBean = new DiskAdBean();
                    // 如果是 网络请求追加的话 先获取原始数据 追加之后在保存
                    if (isNetwork) {
                        String jsonStr = AdBodyPersistenceHelper.getInstance().getString(placementId, null);
                        if (!TextUtils.isEmpty(jsonStr)) {
                            try {
                                DiskAdBean diskAdBean2 = Tson.fromJson(jsonStr, DiskAdBean.class);
                                List<AdsDTO> object = diskAdBean2.list;
                                // 追加
                                if (object != null) {
                                    object.addAll(adItem);
                                    diskAdBean.list = object;
                                } else {
                                    diskAdBean.list = adItem;
                                }

                                AdLogUtil.splashLog("cacheSplashList --> 取出之前保存的数据 --> 将网络请求获取到的数据追加在后面 --> 追加完成");
                            } catch (Throwable e) {
                                e.printStackTrace();
                                AdLogUtil.splashLog("cacheSplashList --> getSplashItem --> 解析异常 mag=" + e.getMessage());
                                diskAdBean.list = adItem;
                            }
                        } else {
                            diskAdBean.list = adItem;
                        }

                    } else {
                        diskAdBean.list = adItem;
                    }

                    // 将数据保存到磁盘
                    String jsonStr = Tson.toJson(diskAdBean);//JsonHelper.parseObjectToJsonStr(ad);

                    AdBodyPersistenceHelper.getInstance().putString(placementId, jsonStr);
                    AdLogUtil.splashLog("cacheSplashList --> 数据保存本地成功 --> 时间戳=" + System.currentTimeMillis());
                } catch (Throwable e) {
                    e.printStackTrace();
                    flag = false;
                    AdLogUtil.splashLog("cacheSplashList --> 广告数据缓存失败 --> msg=" + e.getMessage());
                }
            } else {
                AdLogUtil.splashLog("cacheSplashList --> 需要缓存的数据是空的");
            }
            return flag;
        }

        /**
         * 广告网络请求
         *
         * @param placementId    广告位id
         * @param splashListener
         * @return
         */
        public static boolean loadByNet(final String placementId, final InternalAdListener splashListener, final String requestId, final int requestType) {
            //requestType 请求类型1=媒体触发 2=预加载 3=请求失败重试
            if (sAdServerRequest != null && requestType == Constants.ReturnType.TYPE_MEDIA_TRIGGER) {
                AdLogUtil.splashLog("Splash ad is being request,current request will be drop");
                return false;
            }

            AdLogUtil.splashLog("start load ad...");
            /**
             * 广告请求信息
             * */
            final AdxImpBean impBean = new AdxImpBean();
            impBean.adt = Constants.AdType.SPLASH_NATIVE;
            impBean.pmid = placementId;

            AdLogUtil.splashLog("AdxSplash --> loadByNet() 封装数据完成 发起请求");
            sAdServerRequest = new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>() {
                @Override
                protected void onRequestSuccess(int statusCode, AdResponseBody response) {
                    /**
                     * 业务成功
                     */
                    if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                        AdLogUtil.splashLog("AdxSplash --> onRequestSuccess --> 广告素材请求成功 --> 接下来会回调出去 加载图片");

                        if (response.data != null && response.data.ads != null && response.data.ads.size() > 0) {
                            List<AdsDTO> mAdBeans = response.data.ads;
                            //return埋点需要
                            if (mAdBeans.get(0) != null)
                                bundle.putInt(TrackingKeySsp.BIDDING_PRICE, mAdBeans.get(0).getPrice());

                            for (AdsDTO adBean : mAdBeans) {
                                if (adBean != null) {
                                    adBean.codeSeatId = response.data.codeSeatId;
                                    adBean.codeSeatType = response.data.getCodeSeatType();
                                    adBean.rid = response.data.requestId;
                                    adBean.fill_ts = System.currentTimeMillis();
                                    adBean.cacheTime = response.data.getCacheTime();
                                    adBean.isDefaultAd = 0;
                                    adBean.abTest = response.data.abTest;
                                    adBean.extInfo = response.data.extInfo;
                                }
                            }
                            if (splashListener != null) {
                                // 网络请求成功
                                splashListener.onAdResponse(mAdBeans);
                            }
                        } else {
                            //没有AD数据
                            AdLogUtil.splashLog("广告请求 --> 没有AD数据 --> RESPONSE_AD_IS_EMPTY   a ds list is empty ");

                            if (splashListener != null) {
                                splashListener.onError(TaErrorCode.RESPONSE_AD_IS_EMPTY);
                            }
                        }
                        //请求返回埋点
                        bundle.putInt(TrackingKeySsp.ERROR_CODE, 0);
                        AthenaTracker.trackReturn(bundle);
                    } else {
                        //请求返回埋点
                        bundle.putInt(TrackingKeySsp.IS_TIMEOUT, 0);
                        bundle.putInt(TrackingKeySsp.ERROR_CODE, 101);
                        bundle.putString(TrackingKeySsp.ERROR_MESSAGE, "response == null || response.getCode() != 0");
                        AthenaTracker.trackReturn(bundle);
                        //业务错误
                        AdLogUtil.splashLog("广告请求 --> 业务错误 ");
                        AdLogUtil.splashLog(response != null ? "error,response code is :" + response.getCode() + "," + "response msg is " + response.message : "error, response is null");

                        if (splashListener != null) {
                            if (response != null) {
                                splashListener.onError(new TaErrorCode(response.getCode(), response.message.toString()));
                            } else {
                                splashListener.onError(new TaErrorCode(TaErrorCode.UNKNOWN_ERROR_CODE_1, "response is null"));
                            }
                        }
                    }
                    sAdServerRequest = null;
                }

                @Override
                protected void onRequestError(TaErrorCode adError) {
                    AdLogUtil.splashLog("这个广告的网络请求 加载失败 adError=" + adError);
                    //请求返回埋点
                    if (null != adError) {
                        //有些错误code =0 ， 因此为了区分对code  为0 的改为100
                        bundle.putInt(TrackingKeySsp.ERROR_CODE, adError.getErrorCode() == 0 ? 100 : adError.getErrorCode());
                        //error_message	errormessage，错误信息	null	string
                        bundle.putString(TrackingKeySsp.ERROR_MESSAGE, adError.getErrorMessage());
                    } else {
                        //errorcode，错误码	null	string
                        bundle.putInt(TrackingKeySsp.ERROR_CODE, 100);
                        bundle.putString(TrackingKeySsp.ERROR_MESSAGE, "");
                    }
                    //is_timeout	"本次广告返回是否超过设定的返回超时时长0、否1、是"	"0=否 1=是"	int
                    bundle.putInt(TrackingKeySsp.IS_TIMEOUT, 0);
                    AthenaTracker.trackReturn(bundle);
                    if (splashListener != null) {
                        splashListener.onError(adError);
                    }
                    sAdServerRequest = null;
                }

            }).setPostBody(new AdServerRequest.IAdPostBody() {
                @Override
                public String getPostBody() {
                    return PostBody.getAdPostBody(impBean, requestId);
                }
            })
                    .setDebug(SspAd.isDebug())
                    .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getServerApi())
                    .setPlacementId(placementId);
            if (sAdServerRequest != null) {
                sAdServerRequest.netRequestPreExecute();
                //广告请求埋点
                AthenaTracker.trackRequest(getRequestBundle(impBean, requestId, requestType));
            }
            return true;
        }

        //请求埋点所需要的bundle
        private static Bundle bundle;

        private static Bundle getRequestBundle(AdxImpBean impBean, String requestId, int requestType) {
            bundle = new Bundle();
            bundle.putLong(TrackingKeySsp.REQUEST_TS, System.currentTimeMillis());
            bundle.putInt(TrackingKeySsp.REQUEST_TYPE, requestType);
            bundle.putString(TrackingKeySsp.REQUEST_ID, requestId);
            bundle.putInt(TrackingKeySsp.AD_TYPE, impBean.adt);
            bundle.putString(TrackingKeySsp.CODE_SEAT_ID, impBean.pmid);
            bundle.putInt(TrackingKeySsp.AD_COUNT, impBean.mAdCount);
            bundle.putInt(TrackingKeySsp.IS_DEFAULT_AD, 0);//是否是打底广告 0 否 1 是
            return bundle;
        }
    }

}

