/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.athena;

import android.os.Bundle;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.PostConstant;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.GPSTracker;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.athenacust.AthenaCust;
import com.transsion.json.Tson;

public class AthenaTracker {
    public static final int DOWNLOAD_WAY_HTTP_URL_CONNECTION = 1;
    public static final int DOWNLOAD_WAY_OKHTTP = 2;
    public static final int M_STATUS_STAR = 1;
    public static final int M_STATUS_SUCCESS = 2;
    public static final int M_STATUS_ERROR = 3;
    public static final int M_TYPE_LOGO = 1;
    public static final int M_TYPE_LARGE_IMG = 2;
    public static final int M_TYPE_AD_CHOICE_VIEW = 3;

    public static Bundle getBundle() {
        Bundle bundle = new Bundle();
        bundle.putString("session_id", PostConstant.getSessionId());
        bundle.putString("sdk_version", PostConstant.getSdkVersion());
        bundle.putString("user_agent", PostConstant.getUserAgent());
        bundle.putInt("type", PostConstant.getType());
        bundle.putString("make", PostConstant.getMake());
        bundle.putString("ostype", "Android");
        bundle.putString("imei_sha1", PostConstant.getImeiSha1());
        bundle.putString("imei_md5", PostConstant.getImeiMd5());
        bundle.putString("androidId_sha1", PostConstant.getAndroidIdSha1());
        bundle.putString("androidId_md5", PostConstant.getAndroidIdMd5());
        bundle.putInt("screen_width", PostConstant.getScreenWidth());
        bundle.putInt("screen_height", PostConstant.getScreenHeight());
        bundle.putInt("screen_density", PostConstant.getScreenDensity());
        bundle.putString("base_station", DeviceUtil.getGsmCellLocation());
        GPSTracker gps = new GPSTracker();
        bundle.putDouble("latitude", gps.getLatitude());
        bundle.putDouble("longitude", gps.getLongitude());
        bundle.putLong("coordtime", gps.getCoordTime());
        bundle.putString("imsi", PostConstant.getImsi());
        bundle.putString("mac", PostConstant.getMac());
        return bundle;
    }

    public static void track(AdsDTO info) {
        Bundle bundle = AthenaTracker.getBundle();
        bundle.putString("request_id", info.rid);
        bundle.putString("code_seat_id", info.codeSeatId);
        bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        bundle.putInt("cache_time", info.getCacheTime().intValue());
        bundle.putInt("id", info.getId().intValue());
        bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
        bundle.putLong("plan_id", info.getPlanId().longValue());
        bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
        bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
        bundle.putFloat("price", (float)info.getPrice().intValue());
        bundle.putString("package_name", info.packageName);
        bundle.putString("click_url", info.landingPageUrl);
        bundle.putString("deep_link_url", info.deepLinkUrl);
        bundle.putString("tracking_secret_key", info.showTrackingSecretKey);
        bundle.putString("default_ad_expiration_time", info.defaultAdExpirationTime);
        bundle.putInt("default_ad_show_count", info.getDefaultAdShowCount().intValue());
        bundle.putInt("is_default_ad_first_show", info.getIsDefaultAdFirstShow().intValue());
        bundle.putString("image_url", info.imageUrl);
        bundle.putInt("image_width", info.getImageWidth().intValue());
        bundle.putInt("image_height", info.getImageHeight().intValue());
        if (info.nativeBean != null) {
            bundle.putString("version", info.nativeBean.version);
            bundle.putInt("rating", info.nativeBean.getRating().intValue());
            if (info.nativeBean.title != null) {
                bundle.putString("title_text", info.nativeBean.title.text);
                bundle.putString("descript_text", info.nativeBean.descript.text);
            }
            if (info.nativeBean.button != null) {
                bundle.putString("button_text", info.nativeBean.button.text);
            }
            if (info.nativeBean.logo != null) {
                bundle.putString("logo_url", info.nativeBean.logo.url);
                bundle.putInt("logo_width", info.nativeBean.logo.width.intValue());
                bundle.putInt("logo_height", info.nativeBean.logo.height.intValue());
            }
            if (info.nativeBean.mainImages != null && info.nativeBean.mainImages.size() > 0) {
                bundle.putString("main_image_url", info.nativeBean.mainImages.get((int)0).url);
                bundle.putInt("main_image_width", info.nativeBean.mainImages.get((int)0).width.intValue());
                bundle.putInt("main_image_height", info.nativeBean.mainImages.get((int)0).height.intValue());
            }
        }
        bundle.putLong("login_time", System.currentTimeMillis());
        bundle.putInt("is_default_ad", info.getIsDefaultAd().intValue());
        bundle.putInt("actual_show_rate", info.getActualShowRate().intValue());
        bundle.putLong("show_ts", System.currentTimeMillis());
        bundle.putInt("is_effective_show", info.getIsEffectiveShow().intValue());
        bundle.putString("app_id", SspAd.AppId);
        if (SspAd.isTestRequest()) {
            bundle.putInt("is_test_request", 1);
        } else {
            bundle.putInt("is_test_request", 0);
        }
        if (info.abTest != null) {
            bundle.putString("abTest", Tson.toJson(info.abTest));
        }
        bundle.putString("extInfo", info.extInfo);
        new AthenaCust("ad_ssp_show", 2411).trackCommon(bundle, null).submit();
    }

    public static void trackImageDownload(AdsDTO info, int download_way, int m_status, String errorcode, int m_type) {
        if (null == info) {
            AdLogUtil.imgLog("SSP SDK \u7269\u6599\u52a0\u8f7d\u65e5\u5fd7 --> info==null  download_way = " + download_way + " m_status = " + m_status + " m_type = " + m_type);
            return;
        }
        AdLogUtil.imgLog("SSP SDK \u7269\u6599\u52a0\u8f7d\u65e5\u5fd7 --> download_way = " + download_way + " m_status = " + m_status + " m_type = " + m_type + " info = " + info.toString());
        Bundle bundle = AthenaTracker.getBundle();
        bundle.putString("request_id", info.rid);
        bundle.putString("code_seat_id", info.codeSeatId);
        bundle.putInt("code_seat_type", info.getCodeSeatType().intValue());
        bundle.putLong("advertiser_id", info.getAdvertiserId().longValue());
        bundle.putLong("plan_id", info.getPlanId().longValue());
        bundle.putLong("ad_group_id", info.getAdGroupId().longValue());
        bundle.putLong("ad_creative_id", info.getAdCreativeId().longValue());
        bundle.putString("package_name", info.packageName);
        bundle.putString("image_url", info.getImageUrl());
        bundle.putInt("image_width", info.getImageWidth().intValue());
        bundle.putInt("image_height", info.getImageHeight().intValue());
        bundle.putLong("login_time", System.currentTimeMillis());
        bundle.putInt("is_default_ad", info.getIsDefaultAd().intValue());
        bundle.putInt("download_way ", download_way);
        bundle.putInt("m_status", m_status);
        bundle.putString("error_code", errorcode);
        bundle.putInt("m_type", m_type);
        new AthenaCust("material_load", 2411).trackCommon(bundle, null).submit();
    }

    public static void trackRequest(Bundle mBundle) {
        AdLogUtil.requestLog("SSP SDK request track--> ");
        Bundle bundle = AthenaTracker.getBundle();
        bundle.putInt("request_type", mBundle.getInt("request_type"));
        bundle.putLong("request_ts", mBundle.getLong("request_ts"));
        bundle.putString("request_id", mBundle.getString("request_id"));
        AdLogUtil.requestLog("trackRequest/type" + mBundle.getString("request_id") + "/" + mBundle.getInt("request_type"));
        bundle.putInt("ad_type", mBundle.getInt("ad_type"));
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", mBundle.getString("code_seat_id"));
        bundle.putInt("ad_count", mBundle.getInt("ad_count"));
        bundle.putInt("is_retreatad", 0);
        bundle.putInt("is_default_ad", mBundle.getInt("is_default_ad"));
        new AthenaCust("ad_ssp_request", 2411).trackCommon(bundle, null).submit();
    }

    public static void trackReturn(Bundle mBundle) {
        AdLogUtil.requestLog("SSP SDK return track--> ");
        Bundle bundle = AthenaTracker.getBundle();
        bundle.putLong("request_ts", mBundle.getLong("request_ts"));
        bundle.putString("request_id", mBundle.getString("request_id"));
        AdLogUtil.requestLog("trackReturn" + mBundle.getString("request_id"));
        bundle.putLong("return_ts", System.currentTimeMillis());
        bundle.putInt("return_time", (int)(System.currentTimeMillis() - mBundle.getLong("request_ts")));
        bundle.putInt("ad_type", mBundle.getInt("ad_type"));
        bundle.putString("app_id", SspAd.AppId);
        bundle.putString("code_seat_id", mBundle.getString("code_seat_id"));
        bundle.putFloat("bidding_price", (float)mBundle.getInt("bidding_price"));
        bundle.putInt("ad_count", mBundle.getInt("ad_count"));
        bundle.putInt("is_default_ad", mBundle.getInt("is_default_ad"));
        bundle.putInt("is_timeout", mBundle.getInt("is_timeout"));
        bundle.putString("error_code", String.valueOf(mBundle.getInt("error_code")));
        bundle.putString("error_message", mBundle.getString("error_message"));
        new AthenaCust("ad_ssp_return", 2411).trackCommon(bundle, null).submit();
    }
}

