package com.cloud.hisavana.sdk.config;
/* Top Secret */

import com.cloud.hisavana.sdk.common.constant.Constants;

public class AdxServerConfig {

    public static final int RELEASE = 0;
    public static final int DEV = 2;
    public static final int TEST = 1;
    public static final int PRE_RELEASE = 3;

    private static int app_Modle = RELEASE;

    public static int getAppModle() {
        return app_Modle;
    }

    //release版本关闭此接口
    public static void setAppModle(int app_Modle) {
        AdxServerConfig.app_Modle = app_Modle;
    }

    public static String getServerUrl() {
        switch (AdxServerConfig.getAppModle()) {
            case AdxServerConfig.RELEASE:
                return Constants.HOST.ADN_RELEASE_SERVER_ADDRESS;
            case AdxServerConfig.TEST:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
            case AdxServerConfig.DEV:
                return Constants.HOST.ADN_DEV_SERVER_ADDRESS;
            case AdxServerConfig.PRE_RELEASE:
                return Constants.HOST.ADN_PRE_SERVER_ADDRESS;
            default:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
        }
    }

    public static String getServerApi() {
        return Constants.HOST.API;
    }
}
