package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.splash.TranSplash;
import com.transsion.core.utils.ScreenUtil;

/**
 * ADX开屏对外提供的接口
 * 仅仅提供容器的能力 不参与数据处理
 */
public class ASplash extends RelativeLayout {

    /**
     * 这个对象里面 解决了 数据哪里来的问题
     */
    private TranSplash mSplash = null;

    private RelativeLayout mSplashLayout = null;


    // =============================================================================================


    public ASplash(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ASplash(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context, "");
    }

    public ASplash(Context context, String placementId) {
        super(context, null);
        init(context, placementId);
    }

    /**
     * 初始化 创建了容器
     * 数据处理对象
     */
    private void init(Context context, String placementId) {
        mSplashLayout = new RelativeLayout(this.getContext());
        this.addView(mSplashLayout, ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        mSplash = new TranSplash(context, mSplashLayout, placementId);
    }


    // =============================================================================================

    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        if (isNullApi()) {
            return;
        }
        mSplash.setPlacementId(placementId);
    }

    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        if (isNullApi()) {
            return;
        }
        mSplash.setDefaultAd(isDefaultAd);
    }
    /**
     * 设置是否是预加载
     *
     * @param isPreLoad
     */
    public void setIsPreLoad(boolean isPreLoad) {
        if (isNullApi()) {
            return;
        }
        mSplash.setIsPreLoad(isPreLoad);
    }

    /**
     * 开屏允许外部 跳过
     */
    public void setAllowSkipOut(boolean mIsOpenDpl) {
        mSplash.setAllowSkipOut(mIsOpenDpl);
    }

    /**
     * 设置跳过的监听器
     */
    public void setSkipListener(OnSkipListener listener) {
        if (isNullApi()) {
            return;
        }
        mSplash.setSkipListener(listener);
    }

    /**
     * 设置广告的请求
     */
    public void setAdRequest(@NonNull TaRequest adRequest) {
        if (isNullApi()) {
            return;
        }
        mSplash.setAdRequest(adRequest);
    }

    /**
     * 加载广告
     */
    public void loadAd(String requestId) {
        if (isNullApi()) {
            return;
        }
        mSplash.loadAd(requestId);
    }

    /**
     * 广告是否有效
     *
     * @return
     */
    public boolean isAdValid() {
        if (isNullApi()) {
            return false;
        }
        return mSplash.isAdValid();
    }

    public static boolean isAdReady(String codeSeatId){
        return TranSplash.isAdReady(codeSeatId);
    }

    public double getBidPrice(){
        if (isNullApi()) {
            return 0;
        }
        return mSplash.getBidPrice();
    }

    /**
     * 显示广告 --> 在广告加载完成之后显示
     */
    public void show() {
        if (isNullApi()) {
            return;
        }

        Preconditions.checkIsOnMainThread();
        mSplash.show();
    }

    /**
     * 在调用界面销毁的时候调用
     */
    public void destroy() {
        if (isNullApi()) {
            return;
        }
        mSplash.destroy();
    }

    private boolean isNullApi() {
        if (mSplash == null) {
            AdLogUtil.LOG.e("ASplash --> mSplash == null --> no api found");
            return true;
        }
        return false;
    }

}

