package com.cloud.hisavana.sdk.common.activity;
/* Top Secret */

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.bean.InterstitialBean;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.widget.TAdWebView;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;


/**
 * 显示插屏广告的Activity
 * TAdInterstitial加载完广告之后判断进入自有插屏广告处理类AdInterstitialGemini
 * AdInterstitialGemini下载图片并缓存至本地
 * 通过Intent将解析出来的AdItem传过来
 *
 * @author $韦明微
 * @data 2016/11/25
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class TAdActivity extends Activity {

    private ImageView adImg;  // 主图
    private TAdWebView webview;
    private long oldTime;
    private AAdChoicesView ad_choices_view;
    private static final String TAG_CLOSE = "ad_close";
    private InterstitialBean mInterstitialBean = null;
    private AdsDTO mAdBean = null;

    /**
     * broadcast constants
     */
    public static final String ERROR_CODE = "error_code";
    public static final String ERROR_MSG = "error_msg";
    public static final String LANDING_URL = "ad_clicked_url";
    //private Object mKey = new Object();

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.interstitial_ad_layout);

        ImageView closeImage = this.findViewById(R.id.close_image);
        closeImage.setOnClickListener(mCloseListener);

        ad_choices_view = findViewById(R.id.ad_choices_view);
        adImg = this.findViewById(R.id.interstitial_img);
        if (getIntent() != null) {
            mInterstitialBean = (InterstitialBean) getIntent().getSerializableExtra("InterstitialBean");
            mAdBean = (AdsDTO) getIntent().getSerializableExtra("mAdBean");
        }
        if (null == mInterstitialBean || null == mAdBean) {
            AdLogUtil.LOG.e("TAdActivity --> null == mInterstitialBean || null == mAdBean");
            this.finish();
            return;
        }

        // 注册View的显示测量
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
        session.setAdValid(AdsConfig.isAdValid(mAdBean));
        session.registerView(adImg, impressionListener);

        DownLoadRequest downLoadRequest = new DownLoadRequest()
                .setPreCache(Constants.ImageLoadType.IMAGE_RAM_INCLUDED)
                .setListener(new DrawableResponseListener() {
                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        onAdError(adError.getErrorCode(), adError.getErrorMessage());
                        TAdActivity.this.finish();
                    }

                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data,  AdImage adMedia) {
                        if (adMedia == null || adMedia.isAdImageRecycled()) {
                            onAdError(statusCode, "bitmap is null");
                            TAdActivity.this.finish();
                            return;
                        }
                        adMedia.attachView(adImg);
                        adImg.setOnClickListener(new TAdOnClickListener());
                        adImg.setOnTouchListener(new TAdOnTouchListener());
                    }

                }).setUrl(mInterstitialBean.getRenderContent()).setAdsDTO(mAdBean, AthenaTracker.M_TYPE_LARGE_IMG);
        AdLogUtil.LOG.d("use image to show ad adm is:= " + mInterstitialBean.getRenderContent());
        downLoadRequest.netRequestPreExecute();

        //广告来源
        ImageDownloadHelper.loadImageView(mInterstitialBean.adChoiceImageUrl, ad_choices_view, mAdBean, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
            @Override
            public void onImagesCached(byte[] data) {
                //设置adChoicesView大小
                int height = ScreenUtil.dip2px(Constants.adChoiceViewSizeBig);//正常尺寸adChoicesView
                int width = height;
                //设置adChoicesView大小
                if (ad_choices_view.getDrawable() != null) {
                    width = ad_choices_view.getDrawable().getIntrinsicWidth() * height / ad_choices_view.getDrawable().getIntrinsicHeight();
                }
                if (ad_choices_view.getLayoutParams() != null){
                    ad_choices_view.getLayoutParams().width = width;
                    ad_choices_view.getLayoutParams().height =  height;
                }else {
                    ViewGroup.LayoutParams layoutParams = new ViewGroup.LayoutParams(width, height);
                    ad_choices_view.setLayoutParams(layoutParams);
                }
                ad_choices_view.setMinimumWidth(width);
                ad_choices_view.setMinimumHeight(height);
            }

            @Override
            public void onImagesFailedToCache(TaErrorCode errorCode) {

            }
        });
        ad_choices_view.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent showIntent = new Intent();
                sendBroadcast(Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK, showIntent);
                PlatformUtil.startPageByWebView(CoreUtil.getContext(), mInterstitialBean.adChoiceClickUrl);
            }
        });
    }

    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<Object>() {
        @Override
        public void onViewImpressed(Object key) {
            AdLogUtil.LOG.d("view has impression");
            onAdShow();
        }
    };

    private View.OnClickListener mCloseListener = new View.OnClickListener() {
        @Override
        public void onClick(View v) {
            v.setTag(TAG_CLOSE);
            asyncAction(v, null);
            finish();
        }
    };

    /**
     * 展示统计，发送广告通知开发者广告已展示
     */
    private void onAdShow() {
        AdLogUtil.LOG.d("track = onAdShow");
        Intent showIntent = new Intent();
        sendBroadcast(Constants.ACTION_INTERSTITIAL_SHOW, showIntent);
    }

    /**
     * 如果错误就发送错误回调
     *
     * @param errorCode
     * @param msg
     */
    private void onAdError(int errorCode, String msg) {
        Intent errorIntent = new Intent();
        errorIntent.putExtra(ERROR_MSG, msg);
        errorIntent.putExtra(ERROR_CODE, errorCode);
        sendBroadcast(Constants.ACTION_INTERSTITIAL_ERROR, errorIntent);
    }

    /**
     * view分别有两种，一种渲染广告的view，一种是关闭按钮
     * view.getTag()用来区别点击的view属于哪一种view，响应不同行为
     * ad_close view 关闭广告，点击日志上报
     * ad view 响应点击，跳转着陆页或者deeplink，点击日志上报
     * 2秒内发生的重复点击不做处理，避免点击响应问题
     *
     * @param view 发生点击事件的view
     * @author 韦明微
     * @time 2017/4/10 17:02
     */
    private void asyncAction(View view, String admUrl) {
        try {
            AdLogUtil.LOG.d("asyncAction");
            long currentTime = System.currentTimeMillis();
            if (currentTime - oldTime > 2 * 1000) {
                if (view.getTag() instanceof String && TAG_CLOSE.equals(view.getTag())) {
                    sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
                    if (!isFinishing()) {
                        finish();
                    }
                } else {
                    Intent intent = new Intent();
                    // 点击的坐标点
                    intent.putExtra("pointBean", new DownUpPointBean(downX, downY, upX, upY,
                            view.getMeasuredHeight(),view.getMeasuredWidth()));
                    if (!TextUtils.isEmpty(admUrl)) {  //adm
                        intent.putExtra(LANDING_URL, admUrl);
                        sendBroadcast(Constants.ACTION_INTERSTITIAL_CLICK, intent);
                    } else {
                        sendBroadcast(Constants.ACTION_INTERSTITIAL_CLICK, intent);
                    }
                }
                oldTime = currentTime;
            }
        } catch (Throwable e) {
            AdLogUtil.LOG.d(e.getLocalizedMessage());
        }
    }

    private void sendBroadcast(String action, Intent intent) {
        if (intent == null) {
            intent = new Intent();
        }
        intent.setAction(mInterstitialBean.getBroadCastPrefix() + action);
        AdLogUtil.LOG.d("sendBroadcast action: " + intent.getAction());
        sendBroadcast(intent);
    }


    // =============================================================================================

    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;


    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

            }
            return false;
        }
    }

    protected class TAdOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View v) {
            asyncAction(v, null);
        }
    }


    // =============================================================================================


    @TargetApi(Build.VERSION_CODES.ECLAIR)
    @Override
    protected void onPause() {
        super.onPause();
        overridePendingTransition(0, 0);
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MeasureSessionManager.getInstance().destroySession(mAdBean);
        if (adImg != null) {
            if (adImg.getDrawable() != null) {
                if (adImg.getDrawable() instanceof BitmapDrawable) {
                    BitmapDrawable bd = (BitmapDrawable) adImg.getDrawable();
                    if (bd != null) {
                        Bitmap bitmap = bd.getBitmap();
                        if (bitmap != null && !bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                    }
                    adImg.setImageDrawable(null);
                } else if (adImg.getDrawable() instanceof Drawable) {
                    adImg.setImageDrawable(null);
                }
            }
        }
        if (webview != null) {
            webview.stopLoading();
            webview.removeAllViews();
            webview.destroy();
            ((ViewGroup) webview.getParent()).removeView(webview);
            webview = null;
        }
    }

    @Override
    public void onBackPressed() {
        AdLogUtil.LOG.d("sendBroadcast(TAG_CLOSE);");
        sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
        super.onBackPressed();
    }
}
