package com.cloud.hisavana.sdk.common.athena;

import android.os.Build;
import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.common.util.DeviceUtil;
import com.cloud.hisavana.sdk.common.util.UserAgentUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.utils.AppUtil;
import com.transsion.core.utils.ScreenUtil;

import java.util.concurrent.atomic.AtomicInteger;

/**
 * Created by wenjing.luo on 2021/8/24.
 */

public class PostConstant {
    public static final int TID = 2411;
    public static final String EVENT = "ad_ssp_show";
    public static final String EVENT_IMG = "material_load";
    public static final String EVENT_REQUEST = "ad_ssp_request";
    public static final String EVENT_RETURN = "ad_ssp_return";

    private static String sessionId;
    private static String sdkVersion;
    private static String userAgent;
    private static int type = -1;
    private static String make;

    private static int screenWidth = -1;
    private static int screenHeight = -1;
    private static int screenDensity = -1;
    private static String mcc;
    private static String mnc;


    private static String brand;
    private static String model;
    private static String osVersion;
    private static String versionName;

    /**
     * 本次启动唯一ID：每次启动时生成一个唯一批次号，直到下次启动才变更
     */
    public static String getSessionId() {
        if (TextUtils.isEmpty(sessionId)) sessionId = DeviceUtil.getUUID();
        return sessionId;
    }

    /**
     * sdkVersion
     */
    public static String getSdkVersion(){
        if (TextUtils.isEmpty(sdkVersion)){
            sdkVersion= BuildConfig.VERSION_NAME;
        }
        return sdkVersion;
    }

    /**
     * 终端用户HTTP请求头中的User-Agent字段
     */
    public static String getUserAgent() {
        if (TextUtils.isEmpty(userAgent)) userAgent = UserAgentUtil.getUserAgent();
        return userAgent;
    }

    /**
     * 设备类型   1=PHONE(手机,含iTouch)
     *          2=TABLET(平板)
     */
    public static int getType() {
        if (type == -1) type = DeviceInfo.isPad() ? 2 : 1;
        return type;
    }

    /**
     * 设备制造商
     */
    public static String getMake() {
        if (TextUtils.isEmpty(make)) make = Build.MANUFACTURER;
        return make;
    }

    /**
     * 安卓idSHA1
     */
    public static String getAndroidIdSha1(){
        return DeviceUtil.getAndroidIDSHA1();
    }

    /**
     * 安卓idMd5
     */
    public static String getAndroidIdMd5(){
        return DeviceUtil.getAndroidIDMd5();
    }


    public static int getScreenWidth() {
        if (screenWidth == -1) screenWidth = ScreenUtil.getWinWidth();
        return screenWidth;
    }

    public static int getScreenHeight() {
        if (screenHeight == -1) screenHeight = ScreenUtil.getWinHeight();
        return screenHeight;
    }

    public static int getScreenDensity() {
        if (screenDensity == -1) screenDensity = (int) ScreenUtil.getDensity();
        return screenDensity;
    }

    public static String getMcc() {
        if (TextUtils.isEmpty(mcc)) {
            String deviceOperator = DeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mcc = deviceOperator.substring(0, 3);
            }
        }
        return mcc;
    }

    public static String getMnc() {
        if (TextUtils.isEmpty(mnc)) {
            String deviceOperator = DeviceInfo.getSimOperator();
            if (!TextUtils.isEmpty(deviceOperator) && deviceOperator.length() >= 3) {
                mnc = deviceOperator.substring(3);
            }
        }
        return mnc;
    }

    public static String getBrand() {
        if (TextUtils.isEmpty(brand)) brand = Build.BRAND;
        return brand;
    }

    public static String getModel() {
        if (TextUtils.isEmpty(model)) model = Build.MODEL;
        return model;
    }

    public static String getOsVersion() {
        if (TextUtils.isEmpty(osVersion)) osVersion = DeviceUtil.getSystemVersion();
        return osVersion;
    }

    public static String getVersionName() {
        if (TextUtils.isEmpty(versionName)) versionName = String.valueOf(AppUtil.getVersionName());
        return versionName;
    }
}
