package com.cloud.hisavana.sdk.internal.splash;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.common.util.BlurBgUtils;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.BitmapUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;

import java.io.File;


/**
 * Created by jianbing.yu on 2019/3/5.
 * 开屏大图加载 点击 曝光测量
 */
public class SplashImage {

    private View adView;
    private ImageView adBgView;
    private long oldTime;

    private TranSplash mSplashAd = null;
    private String mImageUrl = null;

    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;
    private boolean mIsImpression = false;

    // =============================================================================================


    public SplashImage(TranSplash splashAd) {
        mSplashAd = splashAd;
    }


    // =============================================================================================


    /**
     * View展示监听回调
     */
    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<AdsDTO>() {
        @Override
        public void onViewImpressed(AdsDTO adBean) {
            AdLogUtil.measureLog("onViewImpressed --> view has impression");

            if (mSplashAd.adListener() != null && !mIsImpression) {
                mIsImpression = true;
                AdLogUtil.measureLog("mSplashAd.adListener().onAdShow()");
                mSplashAd.adListener().onAdShow();
            }
        }
    };

    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;

            }
            return false;
        }
    }

    private class TAdOnClickListener implements View.OnClickListener {
        @Override
        public void onClick(View view) {
            try {
                long currentTime = System.currentTimeMillis();
                if (currentTime - oldTime > 2 * 1000) {
                    if (mSplashAd.adListener() != null) {
                        // 点击之后将坐标传出
                        mSplashAd.adListener().onAdClicked(new DownUpPointBean(downX, downY, upX, upY,
                                view.getMeasuredHeight(), view.getMeasuredWidth()));
                    }
                    oldTime = currentTime;
                }
            } catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }


    // =============================================================================================


    public View getView() {
        return adView;
    }

    public ImageView getAdBgView() {
        return adBgView;
    }

    /**
     * 加载 开屏大图
     *
     * @param isPreCache 是否是预加载
     */
    public void loadImage(final int isPreCache) {
        if (mSplashAd.splashItem() != null) {
            mImageUrl = mSplashAd.splashItem().imageUrl;
            if (!TextUtils.isEmpty(mImageUrl)) {
                DownLoadRequest downLoadRequest = new DownLoadRequest().setPreCache(isPreCache).
                        setListener(new DrawableResponseListener() {
                            @Override
                            public void onRequestSuccess(int statusCode, byte[] data,  AdImage adMedia) {
                                if (isPreCache == Constants.ImageLoadType.IMAGE_DISK_INCLUDED) {
                                    if (mSplashAd.adListener() != null) {
                                        // 传递出去
                                        mSplashAd.adListener().onAdLoaded();
                                    }
                                } else if (isPreCache == Constants.ImageLoadType.IMAGE_RAM_INCLUDED) {
                                    if (adMedia == null) {
                                        return;
                                    }
                                    if (adView == null) {
                                        adView = new ImageView(mSplashAd.context());
                                    }
                                    if (adBgView == null){
                                        adBgView = new ImageView(mSplashAd.context());
                                    }
                                    if (mSplashAd != null && mSplashAd.mAdBean != null) {
                                        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mSplashAd.mAdBean);
                                        session.setAdValid(AdsConfig.isAdValid(mSplashAd.splashItem()));
                                        session.registerView(adView, impressionListener);
                                    }

                                    // 点击事件
                                    adView.setOnTouchListener(new TAdOnTouchListener());
                                    adView.setOnClickListener(new TAdOnClickListener());

                                    adBgView.setOnTouchListener(new TAdOnTouchListener());
                                    adBgView.setOnClickListener(new TAdOnClickListener());

                                    if (adView instanceof ImageView) {
                                        // 开屏页 图片显示的模式
                                        // 先把当前的图片放置到ImageView的中间，执行缩放，
                                        // 将图片的宽度和高度按照相同比例缩放到宽度大于或者等于ImageView的宽度，同时高度大于或者等于ImageView的高度
                                        ((ImageView)adView).setScaleType(ImageView.ScaleType.FIT_CENTER);
                                        adBgView.setScaleType(ImageView.ScaleType.FIT_XY);
                                        if (adMedia.getMime() == Constants.MIME.IMG) {
                                            if (adMedia.getDrawable() == null) {
                                                AdLogUtil.LOG.w("bitmap is null");
                                                return;
                                            }

                                            ((ImageView) adView).setImageDrawable(adMedia.getDrawable());

                                            long start = System.currentTimeMillis();
                                            Bitmap bitmap = BlurBgUtils.getBlurBgBitmap(mImageUrl);
                                            if (bitmap == null) {
                                                bitmap = BlurBgUtils.doBlur(((BitmapDrawable) adMedia.getDrawable()).getBitmap());
                                            }
                                            AdLogUtil.LOG.d("SplashActivity blur image == " + (System.currentTimeMillis() - start));
                                            adBgView.setImageBitmap(bitmap);
//                                            int measureWidth = ScreenUtil.getWinWidth();
//                                            Bitmap bitmap = ((BitmapDrawable) adMedia.getDrawable()).getBitmap();
//                                            if (bitmap != null) {
//                                                int width = bitmap.getWidth();
//                                                Bitmap newBitmap = BitmapUtil.scaleBitmap(bitmap, (float) width / (float) measureWidth);
//                                                if (newBitmap != null) {
//                                                    ((ImageView) adView).setImageBitmap(newBitmap);
//                                                }
//                                            }
                                        } else {
                                            adMedia.attachView(((ImageView) adView));
                                        }
                                    }
                                    mSplashAd.fillSplash();
                                }
                            }

                            @Override
                            protected void onRequestError(TaErrorCode adError) {
                                AdLogUtil.LOG.e(adError.getErrorMessage());
                                if (mSplashAd.adListener() != null) {
                                    mSplashAd.adListener().onError(adError);
                                }
                            }
                        }).setUrl(mImageUrl).setAdsDTO(mSplashAd.splashItem(), AthenaTracker.M_TYPE_LARGE_IMG);
                downLoadRequest.netRequestPreExecute();
            }
        }
    }

    public void destroy() {

        // 优化 --> show 之后就可以不检测了
        if (mSplashAd != null && mSplashAd.mAdBean != null) {
            MeasureSessionManager.getInstance().destroySession(mSplashAd.mAdBean);
        }
        destroyView(adView);
        destroyView(adBgView);
        AdLogUtil.LOG.d("destroy");
    }

    private void destroyView(View view) {
        if (view instanceof ImageView){
            ImageView imageView = (ImageView) view;
            destroyImageView(imageView);
        }
    }

    private void destroyImageView(ImageView imageView) {
        if (imageView != null && imageView.getDrawable() != null) {
            if (imageView.getDrawable() instanceof BitmapDrawable) {
                BitmapDrawable drawable = (BitmapDrawable) imageView.getDrawable();
                if (drawable != null) {
                    Bitmap bitmap = drawable.getBitmap();
                    if (bitmap != null && !bitmap.isRecycled()) {
                        bitmap.recycle();
                    }
                }
            } else {
                imageView.setImageDrawable(null);
            }
        }
    }
}
