/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.transsion.core.CoreUtil;

public class MitNetUtil {
    private static final int NETWORK_TYPE_UNAVAILABLE = -1;
    private static final int NETWORK_TYPE_ETHERNET = 102;
    private static final int NETWORK_TYPE_WIFI = 103;
    public static final int NETWORK_CLASS_2_G = 2;
    public static final int NETWORK_CLASS_3_G = 3;
    public static final int NETWORK_CLASS_4_G = 4;
    public static final int NETWORK_CLASS_5_G = 5;
    private static final int NETWORK_TYPE_UNKNOWN = 0;
    private static final int NETWORK_TYPE_GPRS = 1;
    private static final int NETWORK_TYPE_EDGE = 2;
    private static final int NETWORK_TYPE_UMTS = 3;
    private static final int NETWORK_TYPE_CDMA = 4;
    private static final int NETWORK_TYPE_EVDO_0 = 5;
    private static final int NETWORK_TYPE_EVDO_A = 6;
    private static final int NETWORK_TYPE_1xRTT = 7;
    private static final int NETWORK_TYPE_HSDPA = 8;
    private static final int NETWORK_TYPE_HSUPA = 9;
    private static final int NETWORK_TYPE_HSPA = 10;
    private static final int NETWORK_TYPE_IDEN = 11;
    private static final int NETWORK_TYPE_EVDO_B = 12;
    private static final int NETWORK_TYPE_LTE = 13;
    private static final int NETWORK_TYPE_EHRPD = 14;
    private static final int NETWORK_TYPE_HSPAP = 15;
    private static final int NETWORK_TYPE_NR = 20;

    public static boolean isNetWorkAvailable() {
        if (CoreUtil.getContext().getApplicationContext() == null) {
            return false;
        }
        ConnectivityManager connectMgr = (ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity");
        if (connectMgr == null) {
            return false;
        }
        NetworkInfo nwInfo = connectMgr.getActiveNetworkInfo();
        return nwInfo != null && nwInfo.isAvailable();
    }

    public static int getNetType() {
        int networkType = MitNetUtil.getNetworkType();
        switch (networkType) {
            case -1: 
            case 0: {
                return 0;
            }
            case 102: {
                return 6;
            }
            case 103: {
                return 1;
            }
        }
        return networkType;
    }

    public static int getWifiOrMobile() {
        int networkType = MitNetUtil.getNetworkType();
        switch (networkType) {
            case -1: 
            case 0: {
                return 0;
            }
            case 103: {
                return 1;
            }
        }
        return 2;
    }

    private static int getNetworkType() {
        int networkType = 0;
        try {
            if (CoreUtil.getContext().getApplicationContext() == null && CoreUtil.getContext().getApplicationContext().getSystemService("connectivity") == null) {
                return 0;
            }
            NetworkInfo network = ((ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity")).getActiveNetworkInfo();
            if (network != null && network.isAvailable() && network.isConnected()) {
                int type = network.getType();
                if (type == 1) {
                    networkType = 103;
                } else if (type == 0) {
                    TelephonyManager telephonyManager = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
                    networkType = telephonyManager.getNetworkType();
                } else if (type == 9) {
                    networkType = 102;
                }
            } else {
                networkType = -1;
            }
        }
        catch (Throwable ex) {
            AdLogUtil.LOG.d((Object)("get NetworkType is error: " + ex.getMessage()));
        }
        return MitNetUtil.classifyNetType(networkType);
    }

    private static int classifyNetType(int networkType) {
        switch (networkType) {
            case -1: {
                return -1;
            }
            case 102: {
                return 102;
            }
            case 103: {
                return 103;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 20: {
                return 5;
            }
        }
        return 0;
    }

    public static String getOperatorName() {
        if (CoreUtil.getContext().getApplicationContext() != null) {
            TelephonyManager telephonyManager = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
            return telephonyManager.getSimOperatorName();
        }
        return "";
    }

    public static interface net_type {
        public static final int net_type_unavailable = 0;
        public static final int net_type_ethernet = 6;
        public static final int net_type_wifi = 1;
    }
}

