package com.cloud.hisavana.sdk.internal.splash;

import static android.view.View.LAYOUT_DIRECTION_LTR;
import static com.cloud.hisavana.sdk.common.constant.TaErrorCode.UNKNOWN_ERROR_CODE_2;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.AdxSplash;
import com.cloud.hisavana.sdk.ad.base.AdxAdFactory;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.listener.OnSkipListener;
import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.adapter.ISplash;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.callback.InternalAdListener;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.common.widget.CountTimeView;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.DiskAdBean;
import com.cloud.hisavana.sdk.data.control.AdBodyPersistenceHelper;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.core.utils.NetUtil;
import com.transsion.json.Tson;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 广告数据处理类
 * 在这里 请求了广告
 * 从缓存中获取了广告
 */
public class TranSplash {

    private CountTimeView mCountTimeView;
    private OnSkipListener mSkipListener;
    private ViewGroup mViewGroup = null;

    private Context mContext = null;
    private SplashImage mSplashImage = null;
    protected AdsDTO mAdBean;
    private ISplash mSplash = null;  // AdxSplash

    public String mSdkVersion = "";
    protected String mPlacementId = "";
    public static boolean mIsAllowSkip = true;
    protected boolean mSplashClicked;
    protected TaRequest mTaRequest = new TaRequest.TaRequestBuild().build();

    public static int adListSize = 0; // 全局保存 当前缓存的广告条数  用于判断是否需要网络请求更多的数据
    private int currentAdId = 0;  // 当前显示的广告的id 用于移除已经显示过的广告
    private boolean isDefaultAd = false; //是否是打底广告
    private String mRequestId;

    /**
     * 标识 从缓存中有没有获取数据
     * true 从缓存中获取到了数据
     * false 从缓存中没有获取到数据
     */
    private static Boolean isLoadAd;


    // =============================================================================================


    /**
     * 状态回调
     */
    private InternalAdListener mInternalListener = new InternalAdListener() {

        @Override
        public void onAdLoaded() {
            if (mTaRequest != null && mTaRequest.getListener() != null) {
                AdLogUtil.LOG.d("TranSplash --> onAdLoaded");
                mTaRequest.getListener().onAdLoaded();
            }
        }

        /**
         * 1.从缓存中获取到数据
         * 2.刚开始没有获取到缓存数据 --> 进行网络请求 --> 获取到数据 --> 回调当前
         * ----------------------
         * 1.从打底广告缓存中获取到数据
         *
         */
        @Override
        public void onSplashCacheGet(List<AdsDTO> adBeans) {
            if (adBeans != null && adBeans.size() > 0) {
                mAdBean = adBeans.get(0);
                if (mAdBean == null) {
                    if (mTaRequest != null && mTaRequest.getListener() != null) {
                        AdLogUtil.LOG.d("onError,AdBean is null");
                        mTaRequest.getListener().onError(new TaErrorCode(UNKNOWN_ERROR_CODE_2, "AdBean is empty"));
                    }
                    return;
                }
                loadPlatformAd();
            }
        }

        @Override
        public void onAdShow() {
            if (mAdBean != null && mAdBean instanceof AdsDTO) {
                ((AdsDTO) mAdBean).imp_ts = System.currentTimeMillis();
            }
            //mSplash.impressionTrack(mAdBean);
            // 当前获取到的广告数据 将要显示的id
            currentAdId = mAdBean.getId();
            AdLogUtil.splashLog("当前获取到的广告数据 将要显示的id currentAdId=" + currentAdId);

            if (mTaRequest != null && mTaRequest.getListener() != null) {
                AdLogUtil.LOG.d("onAdShow");
                mTaRequest.getListener().onAdShow();
            }

            // 这条广告显示过了 将他从磁盘中清除
            if (!isDefaultAd) removeAdWithIdAboutDisk(mPlacementId);
        }

        /**
         * 当一个广告展示之后就从本地缓存清除
         *
         * @param key 广告位置id
         */
        private void removeAdWithIdAboutDisk(String key) {

            AdLogUtil.splashLog("这条广告显示过了 将他从磁盘中清除 mPlacementId=" + key + " currentAdId=" + currentAdId);

            if (currentAdId == 0) {
                AdLogUtil.splashLog("currentAdId==0 --> 说明没有显示广告 --> 直接返回");
                return;
            }

            // 获取所有数据
            String jsonStr = AdBodyPersistenceHelper.getInstance().getString(key, null);
            if (!TextUtils.isEmpty(jsonStr)) {
                try {
                    // 数据容器
                    List<AdsDTO> list = new ArrayList<>();
                    // 1.取出数据
                    DiskAdBean diskAdBean = Tson.fromJson(jsonStr, DiskAdBean.class);

                    if (diskAdBean != null && diskAdBean.list != null) {
                        List<AdsDTO> object = diskAdBean.list;
                        AdLogUtil.splashLog("现有的数据 条数 --> size=" + object.size());

                        // 2.排除已经显示过的广告数据
                        for (AdsDTO ob : object) {
                            if (ob.id != currentAdId) {
                                list.add(ob);
                            }
                        }
                        AdLogUtil.splashLog("将已经展现的数据 移除磁盘缓存 剩余 list=" + list.size());

                        // 4.将检查后的数据保存起来
                        if (AdxSplash.SplashNetRequest.cacheSplashList(key, list, false)) {
                            AdLogUtil.splashLog("数据保存成功 --> 将检查过后的数据保存起来 --> 去除已经显示过的数据了 剩余 list=" + list.size());
                        } else {
                            AdLogUtil.splashLog("数据保存失败 --> ");
                        }
                    }
                } catch (Throwable e) {
                    AdLogUtil.LOG.e(Log.getStackTraceString(e));
                }
            }
        }

        @Override
        public void onError(TaErrorCode adError) {
            // 动画
            dismissSplash(0l);
            // 回调
            if (mTaRequest != null && mTaRequest.getListener() != null) {
                AdLogUtil.LOG.d("onError");
                mTaRequest.getListener().onError(adError);
            }
        }

        @Override
        public void onAdClicked(DownUpPointBean pointBean) {

            // 处理开屏图片点击事件
            boolean isSuccess = mSplash.startLandingPage(mViewGroup.getContext(), null, mAdBean, pointBean);
            if (isSuccess) {
                mSplashClicked = true;
                if (mTaRequest != null && mTaRequest.getListener() != null) {
                    AdLogUtil.LOG.d("onAdClicked");
                    mTaRequest.getListener().onAdClicked(pointBean);
                }
            } else {
                AdLogUtil.LOG.d("splash is not skip// " +
                        "dpl=" + mAdBean.deepLinkUrl + "landingPage=" + mAdBean.landingPageUrl
                        + "isAllow=" + TranSplash.mIsAllowSkip);
            }
        }

        @Override
        public void onAdClosed() {
            dismissSplash(100l);
        }

        @Override
        public void onTimeOut() {
            dismissSplash(100l);
        }
    };

    /**
     * 开屏缓存广告，和Splash View生命周期分开
     */
    private static SplashRequestListener sRequestCallback = null;

    /**
     * 广告加载的回调 内部弱引用持有 媒体传进来的广告加载回调
     * 当前回调之后 将事件通过弱引用持有的回调将事件传递出去
     */
    private static class SplashRequestListener extends InternalAdListener {

        WeakReference<InternalAdListener> listener;

        String placementId = null;
        String rid;
        long startTime = 0L;

        AtomicInteger imageCounter;
        AtomicInteger imageList;

        SplashRequestListener(String placementId, InternalAdListener mInternalListener) {
            startTime = System.currentTimeMillis();
            this.placementId = placementId;
            listener = new WeakReference<>(mInternalListener);
        }

        @Override
        public void onError(TaErrorCode adError) {
            AdLogUtil.splashLog("TranSplash --> onError --> adError=" + adError.getErrorMessage());

            // 缓存中没有获取到数据 --> 网络请求 --> 网络请求失败了 --> 回调给媒体处理
            // 错误回调出去给媒体处理
            if (null !=listener && listener.get() != null && !isLoadAd) {
                listener.get().onError(adError);
                AdLogUtil.splashLog("缓存中没有获取到数据 --> 网络请求 --> 网络请求失败了 --> 回调给媒体处理");
            }
        }

        @Override
        public void onAdResponse(final List<AdsDTO> adBeans) {
            // 返回多条数据 的处理  --> 到这里 广告请求的数据返回了
            if (adBeans != null && adBeans.size() > 0) {

                // 记录一下 一共有多少条数据
                imageCounter = new AtomicInteger(adBeans.size());
                imageList = new AtomicInteger();

                AdLogUtil.splashLog("网络请求 广告素材成功 --> adBeans.size()=" + adBeans.size());

                // 循环处理每一条数据 下载每一个素材对应的图片
                for (final AdsDTO adItem : adBeans) {

                    if (adItem == null) {
                        AdLogUtil.splashLog("adItem is null,terminate flow");
                        return;
                    }
                    AdLogUtil.splashLog("循环处理每一条素材 --> adItem=" + adItem.toString());

                    rid = adItem.rid;
                    AdLogUtil.splashLog("onAdResponse // " + "dpl=" + adItem.deepLinkUrl + "ldp=" + adItem.landingPageUrl + "isAllow=" + TranSplash.mIsAllowSkip);
                    TranSplash.mIsAllowSkip = AdxPreferencesHelper.getInstance().getBoolean(Constants.Config.ALLOW_SKIP_OUT, Constants.Config.ALLOW_SKIP_OUT_DEFAULT);

                    List<String> imageUrls = new ArrayList<>();
                    //final String imageUrl = adItem.imageUrl;
                    final String imageUrl = adItem.getAdImgUrl();
                    imageUrls.add(imageUrl);

                    //AdLogUtil.splashLog("相关逻辑都处理完成了 --> 开始异步下载图片 --> imageUrl=" + adItem.imageUrl);
                    AdLogUtil.splashLog("相关逻辑都处理完成了 --> 开始异步下载图片 --> imageUrl=" + adItem.getAdImgUrl());
                    AdLogUtil.splashLog("adItem.id=" + adItem.getId());

                    // 广告数据加载成功之后 开始下载图片 缓存到本地
                    ImageDownloadHelper.preCacheSplashImages(imageUrls, adItem, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                        @Override
                        public void onImagesCached() {

                            if (null != adItem && null != imageList) {
                                AdLogUtil.splashLog("数据缓存成功 图片缓存成功 adItem.id=" + adItem.getId());
                                // 设置标识 当前图片缓存成功
                                adItem.imageIsDownload = true;
                                // 刷新一下 数据源 用于记录当前有多少图片下载成功
                                imageList.incrementAndGet();
                                doAdResponse(adBeans);
                            }
                        }

                        @Override
                        public void onImagesFailedToCache(TaErrorCode errorCode) {
                            // 图片下载失败 整个广告数据都不保存
                            if (null != adItem) {
                                AdLogUtil.splashLog("数据缓存成功 图片缓存失败 adItem.id=" + adItem.getId());
                                // 刷新一下 数据源
                                doAdResponse(adBeans);
                            }
                        }
                    });
                }
            }
        }

        /**
         * 处理广告素材
         *
         * @param adBeans
         */
        private synchronized void doAdResponse(List<AdsDTO> adBeans) {
            int count = imageCounter.decrementAndGet();

            if (adBeans == null) {
                return;
            }

            // 所有的请求都回来了 成功+失败
            if (count == 0) {
                if (imageList.get() > 0) {
                    // 至少一个成功了
                    AdLogUtil.splashLog("doAdResponse() --> 至少一个成功了 imageList=" + imageList.get());

                    // 图片下载完成之后 将图片下载成功的 广告数据保存到本地
                    List<AdsDTO> list = new ArrayList<>();
                    for (AdsDTO ad : adBeans) {
                        if (null != ad && ad.getImageIsDownload()) {
                            list.add(ad);
                        }
                    }
                    AdLogUtil.splashLog("将成功下载的数据 搜索出来 --> 保存到本地 ");

                    // 将图片下载成功的数据保存到本地
                    Boolean flag = AdxAdFactory.newInstance().getDataImpl().cacheSplashList(placementId, list);
                    //true 保存成功 false 保存失败
                    //在加载广告的时候 没有获取到缓存，等网络获取到数据之后在返回
                    if (flag && !isLoadAd && null != listener && null != listener.get()) {
                        //将数据回调出去 通知媒体 数据加载完成
                        AdLogUtil.splashLog("doAdResponse() --> 数据缓存成功 并且之前没有获取到数据 isLoadAd=" + isLoadAd + "回调给媒体");
                        listener.get().onSplashCacheGet(list);
                    }

                    //错误回调出去给媒体处理
                    if (null != listener && listener.get() != null && !flag && !isLoadAd) {
                        AdLogUtil.splashLog("doAdResponse() --> cacheSplash 失败 --> 通知媒体");
                        listener.get().onError(new TaErrorCode(101, "cacheSplash is false"));
                    }

                } else {
                    // 失败了
                    AdLogUtil.splashLog("doAdResponse() --> 都没有成功 errorAll");
                    if (null != listener && listener.get() != null && !isLoadAd) {
                        AdLogUtil.splashLog("doAdResponse() --> 图片缓存失败 并且 之前没有获取到数据 --> 交给媒体处理");
                        listener.get().onError(new TaErrorCode(101, ""));
                    } else {
                        AdLogUtil.splashLog("doAdResponse() --> 数据缓存成功 图片缓存失败 --> 之前已经获取到缓存了 不做处理");
                    }
                }
            }

        }

    }


    // =============================================================================================


    /**
     * 构造方法
     *
     * @param context
     * @param
     */
    public TranSplash(Context context, ViewGroup viewGroup, String placementId) {
        this.mViewGroup = viewGroup;
        this.mContext = context;
        this.mPlacementId = placementId;

        // 当前SDK版本号
        mSdkVersion = AdxAdFactory.newInstance().getDataImpl().getSdkVersion();

        // 这个才是正真发起请求的对象
        mSplash = AdxAdFactory.newInstance().getSplash(placementId);
        mSplash.setAdListener(mInternalListener);
    }


    // =============================================================================================


    /**
     * 展示广告item , 目前只支持自有大图和Naive 开屏
     */
    private void loadPlatformAd() {
        mSplashImage = new SplashImage(this);
        // 缓存开屏大图
        mSplashImage.loadImage(Constants.ImageLoadType.IMAGE_DISK_INCLUDED);
    }


    // =============================================================================================


    /**
     * 加载广告
     * 1.本地缓存中获取
     * 2.发起网络请求
     */
    public void loadAd(String requestId) {
        mRequestId = requestId;
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                loadAdInternal();
            }
        });
    }

    private void loadAdInternal() {
        AdLogUtil.splashLog("------ 开始加载开屏广告了 ------ ");

        // 没有网络
        if (!NetUtil.checkNetworkState()) {
            if (mInternalListener != null) {
                // 当前没有网络 回调给媒体
                AdLogUtil.splashLog("TranSplash --> loadAdInternal --> 当前没有网络 回调给媒体 --> NETWORK_ERROR");
                mInternalListener.onError(TaErrorCode.NETWORK_ERROR);
            }
            return;
        }

        // 1. 从本地缓存中加载广告
        isLoadAd = false; // 重置数据
        TranSplash.adListSize = 0;

        isLoadAd = mSplash.loadAd(mRequestId);
        AdLogUtil.splashLog("TranSplash --> loadAdInternal --> 先从本地获取 --> 是否获取到缓存数据=" + isLoadAd);

        if (isDefaultAd) {
            //如果是打底广告，就不需要继续从网络获取
            if (mTaRequest != null && mTaRequest.getListener() != null && !isLoadAd) {
                mTaRequest.getListener().onError(new TaErrorCode(100, "load default ad error"));
                AdLogUtil.splashLog("TranSplash --> loadAdInternal --> 取打底广告结束 -------");
            }
        } else {
            // 如果本地数据小于等于1条 就发起网络请求
            if (isLoadAd && adListSize > 1) {
                AdLogUtil.splashLog("TranSplash --> loadAdInternal --> 如果本地缓存数据大于1条 --> 不发起网络请求");
                return;
            }
            AdLogUtil.splashLog("TranSplash --> loadAdInternal --> 如果本地缓存数据小于等于1条 --> 发起网络请求");
            // 2.发起网络请求
            AdLogUtil.splashLog("----- 开始网络请求 -------");
            sRequestCallback = new SplashRequestListener(mPlacementId, mInternalListener);
            AdxAdFactory.newInstance().getDataImpl().requestSplash(mPlacementId, sRequestCallback,mRequestId);
        }
    }


    // =============================================================================================


    /**
     * 设置广告位id
     */
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mSplash.setPlacementId(placementId);
    }

    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        this.isDefaultAd = isDefaultAd;
        mSplash.setDefaultAd(isDefaultAd);
    }

    /**
     * 是否允许跳过
     */
    public void setAllowSkipOut(boolean flag) {
        this.mIsAllowSkip = flag;
    }

    /**
     * 设置广告的请求
     */
    public void setAdRequest(@NonNull TaRequest adRequest) {
        this.mTaRequest = adRequest;
    }

    /**
     * 显示广告 --> 在广告素材加载成功之后调用
     */
    public void show() {
        if (mContext == null || mAdBean == null || mSplashImage == null) {
            AdLogUtil.LOG.w("contex is null or mAdBean is null");
            return;
        }

        // 显示图片
        mSplashImage.loadImage(Constants.ImageLoadType.IMAGE_RAM_INCLUDED);
    }

    /**
     * 设置"跳过" 监听
     */
    public void setSkipListener(OnSkipListener listener) {
        this.mSkipListener = listener;
    }

    /**
     * 销毁
     */
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                if (mSplashImage != null) {
                    mSplashImage.destroy();
                }
                mSplash.destroy();
                if (mCountTimeView != null) {
                    mCountTimeView.cancel();
                    mCountTimeView.setCountDownTimerListener(null);
                    mCountTimeView = null;
                }
                mViewGroup.removeAllViews();
                AdLogUtil.LOG.d("TranSplash --> destroy");
            }
        });
    }

    public Context context() {
        return mContext;
    }

    AdsDTO splashItem() {
        return mAdBean;
    }

    InternalAdListener adListener() {
        return mInternalListener;
    }

    String placementId() {
        return mPlacementId;
    }


    // =============================================================================================


    /**
     * 所有素材准备好了之后 就可以开始显示广告了
     */
    void fillSplash() {
        View renderView = null;
        View renderBgView = null;
        if (mSplashImage != null) {
            renderView = mSplashImage.getView();
            renderBgView = mSplashImage.getAdBgView();
        }
        if (renderView == null || renderBgView == null) {
            AdLogUtil.splashLog("Splash view or bg view is null");
            return;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(FrameLayout.LayoutParams.MATCH_PARENT,
                FrameLayout.LayoutParams.MATCH_PARENT);
        if (renderView.getParent() != null) {
            ((ViewGroup) renderView.getParent()).removeView(renderView);
            ((ViewGroup) renderView.getParent()).removeView(renderBgView);
        }
        mViewGroup.addView(renderBgView, layoutParams);
        mViewGroup.addView(renderView, layoutParams);
        addAdMark(); //ad 角标
        addAdMark2(); //ad 角标
        mViewGroup.postDelayed(new Runnable() {
            @Override
            public void run() {
                addSkipView();  //skip 标识
            }
        }, 1000);

    }

    /**
     * 添加广告标识
     */
    private void addAdMark() {
        ImageView imageView = new ImageView(mContext);
        imageView.setId(R.id.splash_ad);
        imageView.setImageResource(R.drawable.hisavana_ad_big);
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(
                mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_13),
                mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_12)
        );
        int layoutDirection = imageView.getLayoutDirection();
        if (layoutDirection == LAYOUT_DIRECTION_LTR) {
            layoutParams.setMarginEnd(mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16));
        } else {
            layoutParams.setMarginStart(mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16));
        }
        layoutParams.bottomMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_END);
        mViewGroup.addView(imageView, layoutParams);
    }

    /**
     * 先弄个占位的
     */
    private void addAdMark2() {
        mAdBean.isACReady = true;
        AAdChoicesView choicesView = mSplash.getAdChoicesView(mContext, mAdBean);
        if (mViewGroup.indexOfChild(choicesView) < 0) {
            if (choicesView != null) {
                RelativeLayout.LayoutParams params;
                if (choicesView.getLayoutParams() != null) {
                    params = (RelativeLayout.LayoutParams) choicesView.getLayoutParams();
                } else {
                    params = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
                }
                params.height = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_12);
                params.width = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_12);
                params.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM);
                int layoutDirection = choicesView.getLayoutDirection();
                if (layoutDirection == LAYOUT_DIRECTION_LTR) {
                    params.addRule(RelativeLayout.START_OF, R.id.splash_ad);
                } else {
                    params.addRule(RelativeLayout.END_OF, R.id.splash_ad);
                }
                params.bottomMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.dimens_16);
                mViewGroup.addView(choicesView, params);
            }
        }
    }

    /**
     * 添加跳过按钮
     */
    private void addSkipView() {
        mCountTimeView = new CountTimeView(mContext);
        mCountTimeView.setStartTime(mAdBean.getSplashCountTime());
        mCountTimeView.setCountDownTimerListener(new CountTimeView.CountDownTimerListener() {
            @Override
            public void onStart() {

            }

            @Override
            public void onFinish() {
                if (mSkipListener != null && !mSplashClicked) {
                    mSkipListener.onTimeEnd();
                }
            }

            @Override
            public void onClick() {
                if (mCountTimeView != null) {
                    mCountTimeView.cancel();
                }
                if (mSkipListener != null) {
                    mSkipListener.onClick();
                }
            }
        });
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        int layoutDirection = mCountTimeView.getLayoutDirection();
        if (layoutDirection == LAYOUT_DIRECTION_LTR) {
            layoutParams.setMarginEnd(mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_start));
        } else {
            layoutParams.setMarginStart(mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_start));
        }
        layoutParams.topMargin = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_mark_margin_top);
        final int width = mContext.getResources().getDimensionPixelSize(R.dimen.ad_skip_view_width);
        final int height = mContext.getResources().getDimensionPixelOffset(R.dimen.ad_skip_view_height);
        layoutParams.width = width;
        layoutParams.height = height;
        layoutParams.addRule(RelativeLayout.ALIGN_PARENT_END);
        mViewGroup.addView(mCountTimeView, layoutParams);
    }

    /**
     * ad_close ad
     *
     * @param duration 动画时间
     */
    private void dismissSplash(long duration) {
        final AlphaAnimation localAlphaAnimation = new AlphaAnimation(1.0F, 0.0F);
        localAlphaAnimation.setDuration(duration);
        localAlphaAnimation.start();
        mViewGroup.postDelayed(new Runnable() {
            @Override
            public void run() {
                mViewGroup.removeAllViews();
            }
        }, duration);

    }

    public boolean isAdValid() {
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice(){
        if(mAdBean != null){
            return mAdBean.getBidPrice();
        }
        return 0;
    }

}
