package com.cloud.hisavana.sdk.api.adx;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.View;
import android.view.ViewGroup;

import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.api.view.AAdChoicesView;
import com.cloud.hisavana.sdk.common.bean.TaNativeInfo;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.internal.native_.TranNative;

import java.util.List;

/**
 * Created by jianbing.yu on 2019/2/22.
 */
public class ANative {

    private TranNative mNative;
    private static final String TAG = "NativeApi";


    // =============================================================================================


    public ANative(String placementId) {
        mNative = new TranNative(placementId);
    }


    // =============================================================================================


    public void setPlacementId(String placementId) {
        if (isNullApi()) {
            return;
        }
        mNative.setPlacementId(placementId);
    }

    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        if (isNullApi()) {
            return;
        }
        mNative.setDefaultAd(isDefaultAd);
    }

    /**
     * 设置一次加载多少条
     *
     * @param adCount
     */
    public void setAdCount(int adCount) {
        if (isNullApi()) {
            return;
        }
        mNative.setAdCount(adCount);
    }

    public void setAdRequest(@NonNull TaRequest taRequest) {
        if (isNullApi()) {
            return;
        }
        mNative.setAdRequest(taRequest);
    }

    public void loadAd(String requestId) {
        if (isNullApi()) {
            return;
        }
        mNative.loadAd(requestId);
    }

    public boolean isAdValid(TaNativeInfo taNativeInfo) {
        if (isNullApi()) {
            return false;
        }
        return mNative.isAdValid(taNativeInfo);
    }

    public boolean isLoading() {
        if (isNullApi()) {
            return false;
        }
        return mNative.isLoading();
    }

    public void downloadMedia(TaNativeInfo ad) {
        if (isNullApi()) {
            return;
        }
        mNative.downloadMedia(ad);
    }

    /**
     * 给广告相关的View注册监听事件
     */
    public void registerViews(@NonNull ViewGroup view, List<View> adContains, TaNativeInfo taNativeInfo) {
        if (isNullApi()) {
            return;
        }
        mNative.registerViews(view, adContains, taNativeInfo);
    }

    /**
     * 媒体端自己定义AdChoicesView的位置
     *
     * @param context
     * @param taNativeInfo
     * @return
     */
    public AAdChoicesView getAdChoicesView(Context context, TaNativeInfo taNativeInfo) {
        if (isNullApi()) {
            return null;
        }
        return mNative.getAdChoicesView(context, taNativeInfo);
    }

    /**
     * 释放资源
     */
    public void destroy() {
        if (isNullApi()) {
            return;
        }
        mNative.destroy();
    }

    private boolean isNullApi() {
        if (mNative == null) {
            AdLogUtil.LOG.e(TAG, "no api found");
            return true;
        }
        return false;
    }
}