package com.cloud.hisavana.sdk.common.widget;

import android.content.Context;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

import com.cloud.hisavana.sdk.common.util.AdLogUtil;


/**
 * Created by jianbing.yu on 2019/1/25.
 */

public class ViewGestureDetector extends GestureDetector {
    private final View mView;
    private ViewGestureListener mGestureListener = null;
    private boolean mTouchOutOfView = false;

    public interface UserClickListener {
        void onUserClick(float x, float y);
    }

    private UserClickListener mUserClickListener;

    public ViewGestureDetector(Context context, View view) {
        this(context, view,new ViewGestureListener());
    }

    private ViewGestureDetector(Context context, View view,ViewGestureListener listener) {
        super(context, listener);
        mGestureListener = listener;
        mView = view;
        setIsLongpressEnabled(false);
    }

    public void sendTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case MotionEvent.ACTION_UP:
                if (!mTouchOutOfView && mUserClickListener != null) {
                    mUserClickListener.onUserClick(motionEvent.getX(),motionEvent.getY());
                } else {
                    AdLogUtil.LOG.w("View's onUserClick() is not registered.");
                }
                break;

            case MotionEvent.ACTION_DOWN:
                mTouchOutOfView = false;
                onTouchEvent(motionEvent);
                break;

            case MotionEvent.ACTION_MOVE:
                if (isMotionEventInView(motionEvent, mView)) {
                    onTouchEvent(motionEvent);
                } else {
                    mTouchOutOfView = true;
                }
                break;

            default:
                break;
        }
    }

    public void setUserClickListener(UserClickListener listener) {
        mUserClickListener = listener;
    }

    void resetAdFlaggingGesture() {

    }

    private boolean isMotionEventInView(MotionEvent motionEvent, View view) {
        if (motionEvent == null || view == null) {
            return false;
        }

        float x = motionEvent.getX();
        float y = motionEvent.getY();

        return (x >= 0 && x <= view.getWidth())
                && (y >= 0 && y <= view.getHeight());
    }
}
