package com.cloud.hisavana.sdk.internal.banner;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;


/**
 * 传音banner类广告
 *
 * @author 孙志刚.
 * @date 2016/12/12.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class BannerGemini {


    private TranBanner mBannerView;
    private AdsDTO mAdBean = null;


    // =============================================================================================


    public BannerGemini(TranBanner bannerView) {
        this.mBannerView = bannerView;
    }

    /**
     * 加载 BannerView
     */
    public void getBannerView() {
        mAdBean = mBannerView.adBean();
        if (mAdBean != null) {

            // 需要考虑 没有大图 只有logo的 Banner 广告样式
            // Banner 大图地址
            String url = mAdBean.getAdImgUrl();
            int type = AthenaTracker.M_TYPE_LARGE_IMG;
            if (TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20301)
                    || TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20302)
                    || TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20303)) {
                // 没有Banner 大图的 下载logo 图片
                if (null != mAdBean.nativeBean) {
                    url = mAdBean.nativeBean.getLogoUrl();
                    type = AthenaTracker.M_TYPE_LOGO;
                }
            }

            if (!TextUtils.isEmpty(url)) {

                AdLogUtil.LOG.d("imageview impression");
                ImageDownloadHelper.downloadImage(url, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, type, new ImageDownloadHelper.ImageListener() {
                    @Override
                    public void onImagesCached(byte[] data) {
                        if (mBannerView.adListener() != null) {
                            mBannerView.adListener().onAdLoaded();
                        }
                    }

                    @Override
                    public void onImagesFailedToCache(TaErrorCode errorCode) {
                        if (mBannerView.adListener() != null) {
                            mBannerView.adListener().onError(errorCode);
                        }
                    }
                });

                //预加载AdChoiceImgUrl
                downloadAdChoice();
            } else {
                AdLogUtil.LOG.e("Not found the render type");
            }
        }
    }

    /**
     * 下载AdChoices
     */
    public void downloadAdChoice() {
        if (!TextUtils.isEmpty(mAdBean.adChoiceImageUrl)) {
            AdLogUtil.LOG.d("textView impression");
            ImageDownloadHelper.downloadImage(mAdBean.adChoiceImageUrl, Constants.ImageLoadType.IMAGE_DISK_INCLUDED, mAdBean, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached(byte[] data) {
                    mAdBean.isACReady = true;
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {
                    mAdBean.isACReady = false;
                }
            });
        } else {
            AdLogUtil.LOG.e("Not found adChoiceImageUrl");
        }
    }

    /**
     * 展示广告
     */
    public void showAd() {
        if (null != mAdBean) {

            // Banner 大图地址
            String url = mAdBean.getAdImgUrl();
            int type = AthenaTracker.M_TYPE_LARGE_IMG;

            // 1.5 版本 适配没有大图只有logo的广告样式
            if (TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20301)
                    || TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20302)
                    || TextUtils.equals(mAdBean.materialStyle, Constants.BANNER_MATERIAL_STYLE_B20303)) {
                if (null != mAdBean.nativeBean) {
                    url = mAdBean.nativeBean.getLogoUrl();
                    type = AthenaTracker.M_TYPE_LOGO;
                }
            }

            // 这里怎么又重新下载了一次
            DownLoadRequest downLoadRequest = new DownLoadRequest().setListener(new DrawableResponseListener() {
                @Override
                public void onRequestSuccess(int statusCode, byte[] data, AdImage adMedia) {
                    AdLogUtil.LOG.d("bind drawable to imageView success");
                    mBannerView.attachBannerToViewTree(adMedia);
                }

                @Override
                protected void onRequestError(TaErrorCode adError) {
                    AdLogUtil.LOG.d("bind drawable to imageView failed, code: " + adError.getErrorCode() + ",message:" + adError.getErrorMessage());
                }
            }).setUrl(url).setAdsDTO(mAdBean, type);
            downLoadRequest.netRequestPreExecute();
        }
    }


}
