package com.cloud.hisavana.sdk.common.tranmeasure;

import android.os.SystemClock;

import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.tracking.ADExposureManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;

/**
 * 检测在这里完成的
 */
public class ImpressionValidChecker {

    private MeasureSession session;

    /**
     * 转交给这个来处理的
     */
    private VisibilityChecker visibilityChecker = null;

    /**
     * 计时用的时间戳
     */
    private long periodStartTimeStamp;

    /**
     * View 展示的累计时间
     */
    private long totalImpressionTime;


    // =============================================================================================


    protected ImpressionValidChecker(MeasureSession session) {
        this.session = session;
        visibilityChecker = VisibilityChecker.getChecker(session.mMeasureInfo);
    }


    // =============================================================================================

    /**
     * 是否已经曝光了
     */
    private boolean hasExposure = false;

    /**
     * 历史上一次测量过程中曝光面积大于50%
     */
    private boolean hasExposureAreaExceed50=false;

    /**
     * 历史出现过的最高曝光比例
     */
    private int historyHighestStatus=0;

    /**
     * 检查有效性
     */
    protected boolean checkValid() {
        if (visibilityChecker == null || session == null || session.mMeasureInfo == null) {
            return false;
        }
        boolean flag = false;

        // 检查View在Window的可见性 返回百分比
        int status = visibilityChecker.check(session.mMeasureInfo, session.getAdView());
        //Monitor.log("checkVisible return value: "+(status == 1 ?  "1........................."+totalImpressionTime:status));
        if (status>=50){
            hasExposureAreaExceed50=true;
        }

        // 保存历史出现过的最大曝光比例
        if (status>historyHighestStatus){
            historyHighestStatus = status;
        }

        if (status > 0 && !hasExposure) {
            AdLogUtil.measureLog("检查View在Window的可见性 返回百分比 --> status = " + status + " totalImpressionTime=" + totalImpressionTime);
        }

        // 可见一个像素，即可开始计时
        if (status > 0) {
            if (periodStartTimeStamp > 0 && !hasExposure) {
                totalImpressionTime = totalImpressionTime + (SystemClock.uptimeMillis() - periodStartTimeStamp);
            }
            periodStartTimeStamp = SystemClock.uptimeMillis();

            // 曝光时长>1000ms && 曝光面积>50 && 是否有效曝光过
            if (checkImpressionTime() && status >= session.mMeasureInfo.minVisiblePercent && !hasExposure) {
                // 有效曝光
                hasExposure = true;
                // 重置数据
                totalImpressionTime = 0;
                periodStartTimeStamp = 0;
                // 上报
                if (session.getmKey() instanceof AdsDTO) {
                    AdsDTO info = (AdsDTO) session.getmKey();
                    if (null != info){
                        info.actualShowRate=historyHighestStatus;
                    }
                    if(session.getAdValid()){
                        ADExposureManager.exposureValid(info);
                    }else{
                        ADExposureManager.exposureInvalid(info);
                    }

                } else {
                    AdLogUtil.measureLog("session.getmKey() instanceof AdsDTO --> false");
                }

                flag = true;
            }
        } else {

            // 不可见的时候判断一下 曾经是否可见过
            if (totalImpressionTime > 0) {

                // 曾经曝光面积大于过 50% --> 有效曝光
                if (hasExposureAreaExceed50 && totalImpressionTime>1000){
                    // 有效曝光
                    if (session.getmKey() instanceof AdsDTO) {
                        AdsDTO info = (AdsDTO) session.getmKey();
                        if (null != info){
                            info.actualShowRate=historyHighestStatus;
                        }
                        if(session.getAdValid()){
                            ADExposureManager.exposureValid(info);
                        }else{
                            ADExposureManager.exposureInvalid(info);
                        }
                    } else {
                        AdLogUtil.measureLog("session.getmKey() instanceof AdsDTO --> false");
                    }
                }else{
                    // 无效曝光
                    if (session.getmKey() instanceof AdsDTO) {
                        AdsDTO info = (AdsDTO) session.getmKey();
                        if (null != info){
                            info.actualShowRate=historyHighestStatus;
                        }
                        ADExposureManager.exposureInvalid(info);
                    } else {
                        AdLogUtil.measureLog("session.getmKey() instanceof AdsDTO --> false");
                    }
                }

                AdLogUtil.measureLog("totalImpressionTime=" + totalImpressionTime);
                // 重置数据
                totalImpressionTime = 0;
            }
            // 重置数据
            hasExposure = false;
            hasExposureAreaExceed50=false;
            periodStartTimeStamp = 0;
            historyHighestStatus=0;
        }

        // 当前目标View可见
//        if(status == VisibilityChecker.AD_VIEW_VISIBLE){
//            if(periodStartTimeStamp > 0){
//                totalImpressionTime = totalImpressionTime + (SystemClock.uptimeMillis() - periodStartTimeStamp);
//            }
//            periodStartTimeStamp = SystemClock.uptimeMillis();
//            return checkImpressionTime();
//
//            // 当前目标View 不可见
//        }else {
//
//            if (totalImpressionTime>0){
//                totalImpressionTime=0;
//                //MeasureSessionManager.getInstance().unregisterSession(session);
//                // 无效曝光
//                ADExposureManager.exposureInvalid();
//            }
//            periodStartTimeStamp = SystemClock.uptimeMillis();
//        }
        //return false;
        return flag;
    }

    /**
     * 检查曝光时间是否满足
     */
    private boolean checkImpressionTime() {
        if (session != null && session.mMeasureInfo != null) {
            return totalImpressionTime >= session.mMeasureInfo.minImpressionTime;
        }
        return false;
    }

    /**
     * 销毁之前 检查一下是否需要销毁
     */
    protected void beforeFinish2Impression() {

        if (hasExposure) {
            AdLogUtil.measureLog("销毁之前 检查一下是否需要销毁 --> 已经曝光过了 ");
            return;
        }

        // 无效曝光
        if (null != session) {
            AdsDTO info = (AdsDTO) session.getmKey();
            if (null != info){
                info.actualShowRate=historyHighestStatus;
            }
            ADExposureManager.exposureInvalid(info);
        }

    }


}
