
package com.cloud.hisavana.sdk.common.bean;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.widget.ImageView;

import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;


public class AdImage {
    private int w;
    private int h;
    private boolean isCached = false;
    public int preCache = Constants.ImageLoadType.IMAGE_RAM_INCLUDED;

    public int getMime() {
        return mime;
    }

    public void setMime(int mime) {
        this.mime = mime;
    }

    // media的类型，1-2-3
    private int mime;

    private String bgPath;
    private String imgUrl;
    private Drawable drawable;
    private String filePath;
    // 埋点用的物料下载类型
    private int mType = AthenaTracker.M_TYPE_LARGE_IMG;
    // 埋点用的
    public AdsDTO adsDTO;

    public AdImage(int mime,Drawable drawable,String filePath) {
        this.mime = mime;
        this.drawable = drawable;
        this.filePath = filePath;
    }

    public AdImage(Drawable drawable,String filePath) {
        this.mime = Constants.MIME.IMG;
        this.drawable = drawable;
        this.filePath = filePath;
    }

    public AdImage(){}

    public void setBgPath(String bgPath) {
        this.bgPath = bgPath;
    }

    public String getBgPath() {
        return bgPath;
    }

    public boolean isCached() {
        return isCached;
    }

    public void setCached(boolean cached) {
        isCached = cached;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }

    public void setW(int w) {
        this.w = w;
    }

    public void setH(int h) {
        this.h = h;
    }

    public String getImgUrl() {
        return imgUrl;
    }

    public void setImgUrl(String imgUrl) {
        this.imgUrl = imgUrl;
    }

    public Drawable getDrawable() {
        return drawable;
    }

    public void setDrawable(Drawable drawable) {
        this.drawable = drawable;
    }

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public int getmType() {
        return mType;
    }

    public void setmType(int mType) {
        this.mType = mType;
    }

    public boolean isAdImageRecycled(){
        return (drawable == null || (getBitmap() != null && getBitmap().isRecycled()));
    }

    public boolean attachView(ImageView imageView){
        if(imageView == null){
            return false;
        }
        if(drawable != null) {
            imageView.setImageDrawable(drawable);
            return true;
        }
        return false;
    }


    private Bitmap getBitmap(){
        if(drawable == null) {
            return null;
        }
        Bitmap bitmap = null;
        try {
            BitmapDrawable bitmapDrawable = (BitmapDrawable) drawable;
            bitmap = bitmapDrawable.getBitmap();
        }catch (Throwable e){
            AdLogUtil.LOG.e(Log.getStackTraceString(e));
        }
        return bitmap;
    }

    public int getByteSize(){
        Bitmap bitmap = getBitmap();
        if (bitmap != null) {
            return bitmap.getByteCount();
        }
        return 0;
    }

}