package com.cloud.hisavana.sdk.common.tracking;

import java.io.Serializable;

/**
 * 广告点击事件 坐标点存储
 */
public class DownUpPointBean implements Serializable {

    private float downX;
    private float downY;
    private float upX;
    private float upY;

    // 素材的宽高
    private int imageH;
    private int imageW;

    public DownUpPointBean() {

    }

    public DownUpPointBean(float downX, float downY, float upX, float upY, int imageH, int imageW) {
        this.downX = downX;
        this.downY = downY;
        this.upX = upX;
        this.upY = upY;
        this.imageH = imageH;
        this.imageW = imageW;
    }

    public float getDownX() {
        return downX;
    }

    public void setDownX(float downX) {
        this.downX = downX;
    }

    public float getDownY() {
        return downY;
    }

    public void setDownY(float downY) {
        this.downY = downY;
    }

    public float getUpX() {
        return upX;
    }

    public void setUpX(float upX) {
        this.upX = upX;
    }

    public float getUpY() {
        return upY;
    }

    public void setUpY(float upY) {
        this.upY = upY;
    }

    public int getImageH() {
        return imageH;
    }

    public void setImageH(int imageH) {
        this.imageH = imageH;
    }

    public int getImageW() {
        return imageW;
    }

    public void setImageW(int imageW) {
        this.imageW = imageW;
    }


    @Override
    public String toString() {
        return "DownUpPointBean{" +
                "downX=" + downX +
                ", downY=" + downY +
                ", upX=" + upX +
                ", upY=" + upY +
                ", imageH=" + imageH +
                ", imageW=" + imageW +
                '}';
    }
}
