package com.cloud.hisavana.sdk.common.util;
/* Top Secret */

import static android.content.Context.LOCATION_SERVICE;

import android.annotation.SuppressLint;
import android.location.Location;
import android.location.LocationManager;

import com.transsion.core.CoreUtil;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * usage
 *
 * @author $韦明微
 * @data 2016/11/25
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class GPSTracker {
    private static Location location;
    private static double latitude;
    private static double longitude;
    private static int accu = 0;
    private static long coordTime = 0;
    private static String coordTimeStr = "";
    private static AtomicInteger mFailTimes = new AtomicInteger(0);

    private GPSTracker() {
        getLocation();
    }

    public static double getLongitude() {
        updateLocation();
        return longitude;
    }

    public static double getLatitude() {
        updateLocation();
        return latitude;
    }

    public static int getAccu() {
        updateLocation();
        return accu;
    }

    public static long getCoordTime() {
        updateLocation();
        return coordTime;
    }
    public static String getCoordTimeStr() {
        updateLocation();
        return coordTimeStr;
    }

    private static void updateLocation(){
        if (checkNeedRetry()) {
            getLocation();
        }
    }

    private static boolean checkNeedRetry() {
        if (latitude == 0 && longitude == 0 && mFailTimes.getAndIncrement() <= 1) {
            return true;
        }
        return false;
    }

    @SuppressLint("MissingPermission")
    private static void getLocation() {
        try {
            if (CoreUtil.getContext() != null) {
                LocationManager locationManager = (LocationManager) CoreUtil.getContext().getSystemService(LOCATION_SERVICE);
                // getting GPS status
                boolean isGPSEnabled = locationManager.isProviderEnabled(LocationManager.GPS_PROVIDER);
                // getting network status
                // flag for network status
                boolean isNetworkEnabled = locationManager.isProviderEnabled(LocationManager.NETWORK_PROVIDER);

                if (!isGPSEnabled && !isNetworkEnabled) {
                    // location service disabled
                    return;
                } else {
                    boolean canGetLocation = true;
                    // if GPS Enabled get lat/long using GPS Services
                    if (isGPSEnabled) {
                        if (locationManager != null) {
                            AdLogUtil.LOG.d("Positioning through the GPS");
//                            if ( CoreUtil.getContext().checkSelfPermission(Manifest.permission.ACCESS_FINE_LOCATION) != PackageManager.PERMISSION_GRANTED
//                                    && checkSelfPermission(Manifest.permission.ACCESS_COARSE_LOCATION) != PackageManager.PERMISSION_GRANTED) {
//                                return;
//                            }
                            location = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
                            updateGPSCoordinates(location);
                        }
                    }
                    // First get location from Network Provider
                    if (isNetworkEnabled) {
                        if (location == null) {
                            AdLogUtil.LOG.d( "Positioning through the network");
                            if (locationManager != null) {
                                location = locationManager.getLastKnownLocation(LocationManager.NETWORK_PROVIDER);
                                updateGPSCoordinates(location);
                            }
                        }
                    }
                }
            }
        } catch (Throwable e) {
            AdLogUtil.LOG.d( "Location Impossible to connect to LocationManager");
        }
        if (location != null) {
            updateGPSCoordinates(location);
        }
    }

    private static void updateGPSCoordinates(Location location) {
        if (location != null) {
            /**
             * because of time consummation, do not get country code
             * @by 王纪清 on 2017/4/17.
             */
            latitude = location.getLatitude();
            longitude = location.getLongitude();
            accu = (int) location.getAccuracy();
            coordTime = location.getTime();
            try {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(coordTime);
                coordTimeStr = format.format(date);
            }catch (Exception e){
                AdLogUtil.LOG.e(e.getMessage());
            }
        }
    }
}