package com.cloud.hisavana.sdk.common.util;


import android.content.Context;
import android.content.pm.PackageInfo;


/**
 * 处理包相关的工具类
 */
public class PackageUtil {

    /**
     * 判断是否存在高版本的应用
     *
     * @param context     上下文
     * @param packageName 包名
     * @param minCode     待比较的小版本
     * @return 返回true表示当前存在的应用版本大于minCode
     */
    public static boolean isExistHighVersion(Context context, String packageName, int minCode) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        } catch (Throwable e) {
            e.printStackTrace();
        }
        if (packageInfo != null) {
            int code = packageInfo.versionCode;
            return code >= minCode;
        } else {
            return false;
        }
    }

    /**
     * 当前包对应的应用是否存在
     *
     * @param context     上下文
     * @param packageName 包名
     * @return 返回true表示应用存在
     */
    public static boolean isPackageExist(Context context, String packageName) {
        PackageInfo packageInfo;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        } catch (Throwable e) {
            packageInfo = null;
        }
        return packageInfo != null;
    }

    /**
     * check is exist fb application
     *
     * @param context
     * @return
     */
    public static boolean checkExistFB(Context context) {
        final String fbPkg = "com.facebook.katana";
        return checkApkExist(context, fbPkg, 0)
                || checkApkExist(context, "com.facebook.lite", 0);
    }

    /**
     * @param context
     * @param packageName
     * @param minCode
     * @return
     */
    public static boolean checkApkExist(Context context, String packageName, int minCode) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        } catch (Throwable e) {
        }
        if (packageInfo != null) {
            int code = packageInfo.versionCode;
            return code >= minCode;
        } else {
            return false;
        }
    }
}