/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.http;

import android.content.Context;
import android.util.Log;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.ADOkHttpClient;
import com.cloud.hisavana.sdk.common.http.RequestBase;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.http.HttpClient;
import com.transsion.http.builder.ImageRequestBuilder;
import com.transsion.http.impl.HttpCallbackImpl;
import com.transsion.http.impl.IHttpCallback;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class DownLoadRequest
extends RequestBase<DrawableResponseListener> {
    private AdsDTO adsDTO;
    private int m_type;
    private String url = "";
    private int isPreCache = 1;

    public DownLoadRequest setAdsDTO(AdsDTO ads, int type) {
        this.adsDTO = ads;
        this.m_type = type;
        return this;
    }

    public DownLoadRequest setUrl(String url) {
        this.url = url;
        return this;
    }

    public DownLoadRequest setListener(DrawableResponseListener listener) {
        this.mListener = listener;
        return this;
    }

    public DownLoadRequest setPreCache(int preCache) {
        this.isPreCache = preCache;
        return this;
    }

    @Override
    public void netRequestPreExecute() {
        this.netRequestPosExecute();
    }

    @Override
    protected void netRequestPosExecute() {
        try {
            this.downloadStart(1);
            ((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)((ImageRequestBuilder)HttpClient.image((Context)CoreUtil.getContext()).log(false)).cache(true).connectTimeout(15000)).readTimeout(20000)).url(this.url)).build().execute((IHttpCallback)new HttpCallbackImpl(true){

                public void onSuccess(int statusCode, byte[] data) {
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, data, null);
                    }
                    DownLoadRequest.this.downloadSuccess(1);
                }

                public void onFailure(int statusCode, byte[] bytes, Throwable throwable) {
                    if (DownLoadRequest.this.mListener != null) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(statusCode, bytes, throwable);
                    }
                    DownLoadRequest.this.downloadError(1, throwable.getMessage());
                }

                public void onSuccess(int statusCode, byte[] responseBody, String filePath) {
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, statusCode, responseBody, filePath);
                    }
                    DownLoadRequest.this.downloadSuccess(1);
                }
            });
        }
        catch (Throwable e2) {
            AdLogUtil.LOG.e((Object)Log.getStackTraceString((Throwable)e2));
        }
    }

    private void switchOkhttp() {
        OkHttpClient client = ADOkHttpClient.getInstance().getOkHttpClient();
        this.downloadStart(2);
        Request request = new Request.Builder().get().url(this.url).build();
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e2) {
                AdLogUtil.imgLog("onFailure_IOException" + e2.toString());
                if (DownLoadRequest.this.mListener != null) {
                    ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(new TaErrorCode(0, e2.getMessage()));
                }
                DownLoadRequest.this.downloadError(2, e2.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response != null && response.isSuccessful() && response.body() != null) {
                    if (response.request() != null) {
                        AdLogUtil.imgLog("onResponse = " + response.request().url());
                    }
                    byte[] bytes = response.body().bytes();
                    if (DownLoadRequest.this.mListener != null && DownLoadRequest.this.mListener instanceof DrawableResponseListener) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestSuccess(DownLoadRequest.this.isPreCache, response.code(), bytes, null);
                    }
                    DownLoadRequest.this.downloadSuccess(2);
                } else {
                    if (DownLoadRequest.this.mListener != null) {
                        ((DrawableResponseListener)DownLoadRequest.this.mListener).onServerRequestFailure(new TaErrorCode(0, "response != null && response.isSuccessful() && response.body()!=null"));
                    }
                    DownLoadRequest.this.downloadError(2, "response == null || !response.isSuccessful() || response.body()==null");
                }
            }
        });
    }

    private void downloadStart(int download_way) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 1, "", this.m_type);
    }

    private void downloadSuccess(int download_way) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 2, "", this.m_type);
    }

    private void downloadError(int download_way, String errorMsg) {
        AthenaTracker.trackImageDownload(this.adsDTO, download_way, 3, errorMsg, this.m_type);
    }
}

