package com.cloud.hisavana.sdk.config;
/* Top Secret */

import com.cloud.hisavana.sdk.common.constant.Constants;

public class AdxServerConfig {

    public static final int RELEASE = 0;
    public static final int DEV = 2;
    public static final int TEST = 1;
    public static final int MOCK = 3;
    public static final int MOCK_ZX = 4;

    private static int app_Modle = RELEASE;

    public static int getAppModle() {
        return app_Modle;
    }

    //release版本关闭此接口
    public static void setAppModle(int app_Modle) {
        AdxServerConfig.app_Modle = app_Modle;
    }

    public static String getServerUrl() {
        switch (AdxServerConfig.getAppModle()) {
            case AdxServerConfig.RELEASE:
                return Constants.HOST.ADN_RELEASE_SERVER_ADDRESS;
            case AdxServerConfig.TEST:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
            case AdxServerConfig.DEV:
                return Constants.HOST.ADN_DEV_SERVER_ADDRESS;
            case AdxServerConfig.MOCK:
                return Constants.HOST.ADN_MOCK_SERVER_ADDRESS;
            case AdxServerConfig.MOCK_ZX:
                return Constants.HOST.ADN_MOCK_SERVER_ADDRESS_ZX;
            default:
                return Constants.HOST.ADN_TEST_SERVER_ADDRESS;
        }
    }

    public static String getServerApi() {
        switch (AdxServerConfig.getAppModle()) {
            case AdxServerConfig.RELEASE:
                return Constants.HOST.API;
            case AdxServerConfig.TEST:
                return Constants.HOST.API;
            case AdxServerConfig.DEV:
                return Constants.HOST.API;
            default:
                return Constants.HOST.API;
        }
    }

    private static boolean FOR_AUTO_TEST = false;

    public static boolean isForAutoTest() {
        return FOR_AUTO_TEST;
    }

    /**
     * 设置是广告落地页跳转 true 跳转到浏览器 false跳转到webview 跑自动化tctp需要设置成true
     * @param forAutoTest
     */
    public static void setForAutoTest(boolean forAutoTest) {
        FOR_AUTO_TEST = forAutoTest;
    }
}
