/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import com.transsion.core.CoreUtil;
import com.transsion.core.log.ObjectLogUtils;

public class AdLogUtil {
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("TA_SDK").setLogHeadSwitch(true).setBorderSwitch(false).create();
    public static ObjectLogUtils NET_LOG = new ObjectLogUtils.Builder().setGlobalTag("AD_NET_LOG").setLogHeadSwitch(true).setBorderSwitch(false).create();
    private final String gloableTag = "ADSDK";
    private final ObjectLogUtils logUtils = new ObjectLogUtils.Builder().setGlobalTag("ADSDK").setLogSwitch(true).setBorderSwitch(false).create();
    private int mLoggingLevel = 2;
    private static AdLogUtil adLogUtil = null;
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int WTF = 8;
    public static final int JSON = 9;

    public static void splashLog(String msg) {
        LOG.i("TA_SDK_splash_log", new Object[]{"splashLog: " + msg});
    }

    public static void measureLog(String msg) {
        LOG.i("TA_SDK_measure_log", new Object[]{"log: " + msg});
    }

    public static void imgLog(String msg) {
        LOG.i("TA_SDK_img_log", new Object[]{"log: " + msg});
    }

    public static void nativeLog(String msg) {
        LOG.i("TA_SDK_native_log", new Object[]{"log: " + msg});
    }

    public static void trackLog(String msg) {
        LOG.i("TA_SDK_track_log", new Object[]{"log: " + msg});
    }

    public static void defaultLog(String msg) {
        LOG.i("TA_SDK_ad_default_log", new Object[]{"log: " + msg});
    }

    public static void adLoadLog(String msg) {
        LOG.i("TA_SDK_ad_load_log", new Object[]{"log: " + msg});
    }

    public static void adChoicesLog(String msg) {
        LOG.i("TA_SDK_ad_choices_log", new Object[]{"log: " + msg});
    }

    public static void netLog(String msg) {
        NET_LOG.i((Object)msg);
    }

    private AdLogUtil() {
        this.logUtils.setInvokeLayer(3);
    }

    public void setLogSwitch(boolean isDebug) {
        this.logUtils.getBuilder().setLogSwitch(isDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized AdLogUtil Log() {
        if (adLogUtil != null) return adLogUtil;
        Class<AdLogUtil> clazz = AdLogUtil.class;
        synchronized (AdLogUtil.class) {
            if (adLogUtil != null) return adLogUtil;
            adLogUtil = new AdLogUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return adLogUtil;
        }
    }

    private boolean shouldLog(int logLevel) {
        return logLevel >= this.mLoggingLevel;
    }

    public void log(int logLevel, String tag, String msg) {
        this.logWithThrowable(logLevel, tag, msg, null);
    }

    public void logWithThrowable(int logLevel, String tag, String msg, Throwable t) {
        if (this.shouldLog(logLevel)) {
            tag = "ADSDK__" + tag;
            switch (logLevel) {
                case 2: {
                    if (t != null) {
                        this.logUtils.v(tag, new Object[]{msg, t});
                        break;
                    }
                    this.logUtils.v(tag, new Object[]{msg});
                    break;
                }
                case 5: {
                    if (t != null) {
                        this.logUtils.w(tag, new Object[]{msg, t});
                        break;
                    }
                    this.logUtils.w(tag, new Object[]{msg});
                    break;
                }
                case 6: {
                    if (t != null) {
                        this.logUtils.e(tag, new Object[]{msg, t});
                        break;
                    }
                    this.logUtils.e(tag, new Object[]{msg});
                    break;
                }
                case 3: {
                    if (t != null) {
                        this.logUtils.d(tag, new Object[]{msg, t});
                        break;
                    }
                    this.logUtils.d(tag, new Object[]{msg});
                    break;
                }
                case 4: {
                    if (t != null) {
                        this.logUtils.i(tag, new Object[]{msg, t});
                        break;
                    }
                    this.logUtils.i(tag, new Object[]{msg});
                    break;
                }
                case 9: {
                    this.logUtils.json(tag, msg);
                    break;
                }
            }
        }
    }

    public void v(String tag, String msg) {
        this.log(2, tag, msg);
    }

    public void v(String tag, String msg, Throwable t) {
        this.logWithThrowable(2, tag, msg, null);
    }

    public void d(String tag, String msg) {
        this.log(3, tag, msg);
    }

    public void d(String tag, int id) {
        String msg = CoreUtil.getContext().getString(id);
        this.log(3, tag, msg);
    }

    public void d(String tag, String msg, Throwable t) {
        this.log(3, tag, msg);
    }

    public void i(String tag, String msg) {
        this.log(4, tag, msg);
    }

    public void i(String tag, String msg, Throwable t) {
        this.logWithThrowable(4, tag, msg, null);
    }

    public void w(String tag, String msg) {
        this.log(5, tag, msg);
    }

    public void w(String tag, String msg, Throwable t) {
        this.logWithThrowable(5, tag, msg, null);
    }

    public void e(String tag, String msg) {
        msg = "******" + msg + "******";
        this.log(6, tag, msg);
    }

    public void e(String tag, String msg, Throwable t) {
        msg = "******" + msg + "******";
        this.logWithThrowable(6, tag, msg, null);
    }

    public void wtf(String tag, String msg) {
        this.log(8, tag, msg);
    }

    public void wtf(String tag, String msg, Throwable t) {
        this.logWithThrowable(8, tag, msg, null);
    }

    public void json(String tag, String msg) {
        this.logWithThrowable(9, tag, msg, null);
    }
}

