package com.cloud.hisavana.sdk.common.activity;
/* Top Secret */

import static com.transsion.core.CoreUtil.getContext;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.webkit.SslErrorHandler;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.ProgressBar;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * usage
 *
 * @author peng.sun
 * @data 2018/08/16
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */

public class TAdExposureActivity extends Activity {

    private WebView webView;
    private ProgressBar bar;
    private boolean isRedirected = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.tad_exposure_activity);
        bar = findViewById(R.id.pb_progress);
        initWebView();
    }

    private void initWebView() {
        String url = getIntent().getStringExtra("url");

        if (url != null && url.startsWith("https://play.google.com/store/apps/")) {
            url = url.replaceAll("https://play.google.com/store/apps/", "market://");
            startGp(url);
            return;
        } else if (url != null && url.startsWith("market://")) {
            startGp(url);
            return;
        }

        webView = (WebView) findViewById(R.id.wv_webview);
        webView.getSettings().setJavaScriptEnabled(true);
        webView.getSettings().setJavaScriptCanOpenWindowsAutomatically(true);
        webView.getSettings().setSupportZoom(true);
        webView.getSettings().setUseWideViewPort(true);
        webView.getSettings().setLoadWithOverviewMode(true);
        webView.getSettings().setDisplayZoomControls(true);
        webView.getSettings().setAppCacheEnabled(true);
        webView.getSettings().setDomStorageEnabled(true);
        webView.setWebChromeClient(new WebChromeClient() {
            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                if (newProgress == 100) {
                    bar.setVisibility(View.GONE);
                } else {
                    if (View.GONE == bar.getVisibility()) {
                        bar.setVisibility(View.VISIBLE);
                    }
                }
            }
        });
        webView.setWebViewClient(new WebViewClient() {
            /**
             * 多页面在同一个WebView中打开，就是不新建activity或者调用系统浏览器打开
             */
            @Override
            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                //AdLogUtil.LOG.d("shouldOverrideUrlLoading url=" + url);
                AdLogUtil.trackLog("shouldOverrideUrlLoading url=" + url);
                return goToNext(view, url);
            }

            @Override
            public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {

                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
                    if (request != null && request.getUrl() != null) {
                        if (!TextUtils.isEmpty(request.getUrl().toString())) {
                            AdLogUtil.LOG.d("shouldOverrideUrlLoading url=" + request.getUrl().toString());
                            return goToNext(view, request.getUrl().toString());
                        }
                    }
                }
                return true;
            }

            @Override
            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }

            @Override
            public void onPageFinished(WebView view, String url) {
                super.onPageFinished(view, url);
                if (!isRedirected) {
                    //  数据上报位置
                    AdLogUtil.LOG.d("onPageFinished" + ":" + webView == null ? "" : webView.getUrl());
                    if (bar != null && bar.getVisibility() != View.GONE) {
                        bar.setVisibility(View.GONE);
                    }

                    //String title = view.getTitle();
                    //if (!TextUtils.isEmpty(title)) {
                    //    tvTitle.setText(title);
                    //}
                    //if (!TextUtils.isEmpty(view.getUrl())) {
                    //    tvUrl.setText(view.getUrl());
                    //}
                }
                isRedirected = false;
            }

            /**
             *# android7.0 https无法正常显示修复
             */
            @Override
            public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
//                AdLogUtil.LOG.d( "sslerror " + error.getPrimaryError());
//                handler.proceed();
//                super.onReceivedSslError(view, handler, error);
                AdLogUtil.LOG.d("sslerror " + error.getPrimaryError());
                final AlertDialog.Builder builder = new AlertDialog.Builder(TAdExposureActivity.this);
                builder.setMessage(R.string.web_ssl_error);
                builder.setPositiveButton("continue", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        handler.proceed();
                    }
                });
                builder.setNegativeButton("cancel", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialog, int which) {
                        handler.cancel();
                        finish();
                    }
                });
                final AlertDialog dialog = builder.create();
                dialog.show();
            }
        });

        // 判断是 AdChoices 还是 Ad 点击事件
        if (getIntent() != null && getIntent().getBooleanExtra("isAdClick", false)) {

            // 广告点击事件  --> url 埋点数据
            DownUpPointBean pointBean = (DownUpPointBean) getIntent().getSerializableExtra("pointBean");
            // 第三方归因服务
            String clickid = getIntent().getStringExtra("clickid");
            url = TrackingManager.processUrl(url, pointBean,clickid);
            Map<String, String > map = new HashMap() ;
            map.put( "Accept-Timezone" , "UTC") ;
            webView.loadUrl(url ,map);
        }else{
            webView.loadUrl(url);
        }
    }

    private void startGp(String url) {
        try {
            Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
            intent.setPackage("com.android.vending");
            intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
            getContext().startActivity(intent);
            TAdExposureActivity.this.finish();
        } catch (Throwable e) {
        }
    }

    public boolean goToNext(WebView view, String url) {
        Log.d("TAG", "webview get redirect url is:" + url);
        if (url != null && (!(url.startsWith("http:") || url.startsWith("https:")))) {
            try {
                //处理intent协议
                if (url.startsWith("intent://")) {
                    Intent intent;
                    intent = Intent.parseUri(url, Intent.URI_INTENT_SCHEME);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    intent.setComponent(null);
                    intent.setSelector(null);
                    List<ResolveInfo> resolves = getContext().getPackageManager().queryIntentActivities(intent, 0);
                    if (resolves.size() > 0) {
                        getContext().startActivity(intent);
                    }
                } else {
                    Intent intent = new Intent(Intent.ACTION_VIEW, Uri.parse(url));
                    intent.setPackage("com.android.vending");
                    intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                    getContext().startActivity(intent);
                    TAdExposureActivity.this.finish();
                    //final Intent intent = new Intent(Intent.ACTION_VIEW,
                    //        Uri.parse(url));
                    //intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_SINGLE_TOP);
                    //startActivity(intent);
                }
            } catch (URISyntaxException e) {
                //pass
            } catch (Throwable e) {
                AdLogUtil.LOG.e("No App to open receive the intent");
            }
        } else {
            view.loadUrl(url);
        }
        return true;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == KeyEvent.KEYCODE_BACK && webView != null && webView.canGoBack()) {
            webView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @Override
    protected void onDestroy() {
        if (webView != null) {
            ViewParent parent = webView.getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(webView);
            }
            webView.stopLoading();
            // 退出时调用此方法，移除绑定的服务，否则某些特定系统会报错
            webView.getSettings().setJavaScriptEnabled(false);
            webView.clearHistory();
            webView.removeAllViews();
            webView.destroy();
        }
        super.onDestroy();
    }
}

