package com.cloud.hisavana.sdk.common.util;


import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;

import com.transsion.core.CoreUtil;

import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * 处理应用相关的工具类
 */
public class ApplicationUtil {
    private static String firstInstallTime;

    /**
     * 获取客户端首次安装时间（时间戳）
     */
    public static String getInstallTime() {
        if (TextUtils.isEmpty(firstInstallTime) && CoreUtil.getContext().getApplicationContext() != null) {
            try {
                PackageManager manager = CoreUtil.getContext().getApplicationContext().getPackageManager();
                PackageInfo info = manager.getPackageInfo(CoreUtil.getContext().getApplicationContext().getPackageName(), 0);
                //获取应用第一次安装的时间
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
                Date date = new Date(info.firstInstallTime);
                firstInstallTime = format.format(date);

            } catch (Exception e) {
                AdLogUtil.LOG.d("get installTime is error: " + e.getMessage());
            }
        }
        return firstInstallTime;
    }
}