package com.cloud.hisavana.sdk.common.activity;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.ad.base.PlatformUtil;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.DownLoadRequest;
import com.cloud.hisavana.sdk.common.http.listener.DrawableResponseListener;
import com.cloud.hisavana.sdk.common.tracking.DownUpPointBean;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSession;
import com.cloud.hisavana.sdk.common.tranmeasure.MeasureSessionManager;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.common.widget.TranCircleImageView;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.transsion.core.CoreUtil;
import com.transsion.core.utils.ScreenUtil;


/**
 * sdk 1.5需求
 * https://k8sajlplqs.feishu.cn/docs/doccn6cruUTiZb7fHsDeRjO8MYg
 * https://k8sajlplqs.feishu.cn/docs/doccnFsETC3o5MMiLdockCZ3Ucc#
 * <p>
 * 模板广告
 */
public class TAdInterstitialActivity extends Activity {

    // 布局里面的View
    private TranCircleImageView ivImg;  // Banner 主图
    private ImageView ivAdChoices;      // 广告来源
    private ImageView ivIcon;           // icon
    private LinearLayout llRoot;        // 内容部分
    private TextView tvName;            // 标题
    private TextView tvDescription;     // 介绍
    private TextView tvBtn;             // 按钮

    // 传递过来的数据
    private AdsDTO mAdBean = null;
    private String broadCastPrefix = ""; // 广播用的

    /**
     * 埋点 坐标点
     */
    private float downX = -1;
    private float downY = -1;
    private float upX = -1;
    private float upY = -1;

    // 优化多次点击
    private long oldTime;

    private static final String TAG_CLOSE = "ad_close";

    /**
     * broadcast constants
     */
    public static final String ERROR_CODE = "error_code";
    public static final String ERROR_MSG = "error_msg";
    public static final String LANDING_URL = "ad_clicked_url";


    // =============================================================================================


    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        setTitle(null);
        super.onCreate(savedInstanceState);

        // 传递过来的数据
        if (getIntent() != null) {
            broadCastPrefix = (String) getIntent().getStringExtra("BroadCastPrefix");
            mAdBean = (AdsDTO) getIntent().getSerializableExtra("mAdBean");
        }

        if (null == mAdBean || null == mAdBean.materialStyle) {
            AdLogUtil.LOG.d("TAdInterstitialActivity --> null == mAdBean || null == mAdBean.materialStyle");
            this.finish();
            return;
        }

        AdLogUtil.LOG.d("TAdInterstitialActivity --> 当前样式为=" + mAdBean.materialStyle);

        // 根据不同的模板显示不同的布局
        switch (mAdBean.materialStyle) {
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1101:
                setContentView(R.layout.activity_t_ad_interstitial_1101_layout);
                break;
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1102:
                setContentView(R.layout.activity_t_ad_interstitial_1102_layout);
                break;
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1103:
                setContentView(R.layout.activity_t_ad_interstitial1103_layout);
                break;
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1106:
                setContentView(R.layout.activity_t_ad_interstitial_1106_layout);
                break;
            case Constants.INTERSTITIAL_MATERIAL_STYLE_FA14:
                setContentView(R.layout.activity_t_ad_interstitial_1104_1105_layout);
                break;
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1107:
                setContentView(R.layout.activity_t_ad_interstitial_1107_layout);
                break;
            default:
                finish();
                AdLogUtil.LOG.w("TAdTemplateActivity --> 没有匹配到 materialStyle --> 配置错误 materialStyle=" + mAdBean.materialStyle);
                return;
        }

        // 全屏显示 必须在setContentViw之后设置全屏。否则不会生效。
        getWindow().setLayout(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        //设置点击外部空白处可以关闭Activity true:可以关闭 false:不能关闭
        this.setFinishOnTouchOutside(false);

        // 初始化 通用控件
        initView();
        // 下载图片
        downloadImg();
        // 动态显示布局
        setServerDeliveryStyle();
    }

    @Override
    public void onBackPressed() {
        AdLogUtil.LOG.d("sendBroadcast(TAG_CLOSE);");
        sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
        super.onBackPressed();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        MeasureSessionManager.getInstance().destroySession(mAdBean);
        if (ivImg != null) {
            if (ivImg.getDrawable() != null) {
                if (ivImg.getDrawable() instanceof BitmapDrawable) {
                    BitmapDrawable bd = (BitmapDrawable) ivImg.getDrawable();
                    if (bd != null) {
                        Bitmap bitmap = bd.getBitmap();
                        if (bitmap != null && !bitmap.isRecycled()) {
                            bitmap.recycle();
                        }
                    }
                    ivImg.setImageDrawable(null);
                } else if (ivImg.getDrawable() != null) {
                    ivImg.setImageDrawable(null);
                }
            }
        }
    }


    // =============================================================================================


    /**
     * 初始化 View
     */
    private void initView() {

        ivImg = findViewById(R.id.ivImg);
        ivAdChoices = findViewById(R.id.ivAdChoices);
        llRoot = findViewById(R.id.llRoot);
        ivIcon = findViewById(R.id.ivIcon);
        tvName = findViewById(R.id.tvName);
        tvDescription = findViewById(R.id.tvDescription);
        tvBtn = findViewById(R.id.tvBtn);

        // 取消 点击事件
        findViewById(R.id.ivCancel).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                v.setTag(TAG_CLOSE);
                asyncAction(v, null);
                finish();
            }
        });

        // 内容布局 整体点击事件
        if (null != llRoot) {
            llRoot.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    asyncAction(v, null);
                }
            });
        }

        // 广告来源 点击事件
        ivAdChoices.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent showIntent = new Intent();
                sendBroadcast(Constants.ACTION_INTERSTITIAL_ADCHOICE_CLICK, showIntent);
                PlatformUtil.startPageByWebView(CoreUtil.getContext(), mAdBean.adChoiceClickUrl);
            }
        });

        // 注册View的显示测量
        MeasureSession session = MeasureSessionManager.getInstance().getMeasureSession(mAdBean);
        session.registerView(ivImg, impressionListener);
    }

    /**
     * 下载图片
     */
    private void downloadImg() {

        // 下载主图片
        DownLoadRequest downLoadRequest = new DownLoadRequest()
                .setPreCache(Constants.ImageLoadType.IMAGE_RAM_INCLUDED)
                .setListener(new DrawableResponseListener() {
                    @Override
                    public void onRequestSuccess(int statusCode, byte[] data, AdImage adMedia) {
                        if (adMedia == null || adMedia.isAdImageRecycled()) {
                            onAdError(statusCode, "bitmap is null");
                            TAdInterstitialActivity.this.finish();
                            return;
                        }

                        if (null != ivImg) {
                            adMedia.attachView(ivImg);
                            // 点击事件
                            ivImg.setOnTouchListener(new TAdOnTouchListener());
                            ivImg.setOnClickListener(new View.OnClickListener() {
                                @Override
                                public void onClick(View v) {
                                    asyncAction(v, null);
                                }
                            });
                        }

                    }

                    @Override
                    protected void onRequestError(TaErrorCode adError) {
                        if (null != adError) {
                            onAdError(adError.getErrorCode(), adError.getErrorMessage());
                        }else{
                            onAdError(1000, "adError.getErrorMessage()");
                        }
                        TAdInterstitialActivity.this.finish();
                    }

                }).setUrl(mAdBean.getAdImgUrl()).setAdsDTO(mAdBean, AthenaTracker.M_TYPE_LARGE_IMG);
        AdLogUtil.LOG.d("use image to show ad adm is:= " + mAdBean.getAdImgUrl());
        downLoadRequest.netRequestPreExecute();

        //广告来源
        ImageDownloadHelper.loadImageView(mAdBean.adChoiceImageUrl,
                ivAdChoices, mAdBean, AthenaTracker.M_TYPE_AD_CHOICE_VIEW, null);

        // 下载icon
        if (null != ivIcon && null != mAdBean.nativeBean) {
            ImageDownloadHelper.loadImageView(mAdBean.nativeBean.getLogoUrl(),
                    ivIcon, mAdBean, AthenaTracker.M_TYPE_LOGO, null);
        }
    }

    /**
     * 服务器动态下发广告样式
     */
    private void setServerDeliveryStyle() {

        // I1107 不需要做任何操作的

        if (null == mAdBean || null == mAdBean.nativeBean) {
            return;
        }

        // 布局内容填充
        switch (mAdBean.materialStyle) {
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1101:
            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1103:
                tvName.setText(mAdBean.nativeBean.getTitleTxt());
                tvDescription.setText(mAdBean.nativeBean.getDescriptionTxt());
                tvBtn.setText(mAdBean.nativeBean.getButtonTxt());
                // 字重
                TextPaint tp1 = tvName.getPaint();
                tp1.setStrokeWidth(2.0f);
                tp1.setStyle(Paint.Style.FILL_AND_STROKE);
                break;

            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1106:
            case Constants.INTERSTITIAL_MATERIAL_STYLE_FA14:
                tvName.setText(mAdBean.nativeBean.getTitleTxt());
                tvDescription.setText(mAdBean.nativeBean.getDescriptionTxt());
                tvBtn.setText(mAdBean.nativeBean.getButtonTxt());
                // 字重
                TextPaint tp2 = tvDescription.getPaint();
                tp2.setStrokeWidth(2.0f);
                tp2.setStyle(Paint.Style.FILL_AND_STROKE);
                break;

            case Constants.INTERSTITIAL_MATERIAL_STYLE_I1102:
                tvName.setText(mAdBean.nativeBean.getTitleTxt());
                tvBtn.setText(mAdBean.nativeBean.getButtonTxt());
                TextPaint tp = tvName.getPaint();
                tp.setStrokeWidth(2.0f);
                tp.setStyle(Paint.Style.FILL_AND_STROKE);
                break;
        }

    }


    // =============================================================================================


    /**
     * 曝光测量 监听器
     */
    private MeasureSession.AdImpressionListener impressionListener = new MeasureSession.AdImpressionListener<Object>() {
        @Override
        public void onViewImpressed(Object key) {
            AdLogUtil.LOG.d("view has impression");
            AdLogUtil.LOG.d("track = onAdShow");
            Intent showIntent = new Intent();
            sendBroadcast(Constants.ACTION_INTERSTITIAL_SHOW, showIntent);
        }
    };

    /**
     * 主要是为了获取触摸点 数据
     */
    private class TAdOnTouchListener implements View.OnTouchListener {

        @Override
        public boolean onTouch(View v, MotionEvent event) {
            switch (event.getAction()) {
                case MotionEvent.ACTION_DOWN:
                    downX = event.getX();
                    downY = event.getY();
                    break;

                case MotionEvent.ACTION_UP:
                    upX = event.getX();
                    upY = event.getY();
                    break;
            }
            return false;
        }
    }

    /**
     * view分别有两种，一种渲染广告的view，一种是关闭按钮
     * view.getTag()用来区别点击的view属于哪一种view，响应不同行为
     * ad_close view 关闭广告，点击日志上报
     * ad view 响应点击，跳转着陆页或者deeplink，点击日志上报
     * 2秒内发生的重复点击不做处理，避免点击响应问题
     *
     * @param view 发生点击事件的view
     * @author 韦明微
     * @time 2017/4/10 17:02
     */
    private void asyncAction(View view, String admUrl) {
        try {
            AdLogUtil.LOG.d("asyncAction");
            long currentTime = System.currentTimeMillis();
            if (currentTime - oldTime > 2 * 1000) {
                if (view.getTag() instanceof String && TAG_CLOSE.equals(view.getTag())) {
                    sendBroadcast(Constants.ACTION_INTERSTITIAL_CLOSE, null);
                    if (!isFinishing()) {
                        finish();
                    }
                } else {
                    Intent intent = new Intent();
                    // 点击的坐标点
                    intent.putExtra("pointBean", new DownUpPointBean(downX, downY, upX, upY,
                            view.getMeasuredHeight(), view.getMeasuredWidth()));
                    if (!TextUtils.isEmpty(admUrl)) {  //adm
                        intent.putExtra(LANDING_URL, admUrl);
                    }
                    sendBroadcast(Constants.ACTION_INTERSTITIAL_CLICK, intent);
                }
                oldTime = currentTime;
            }
        } catch (Throwable e) {
            AdLogUtil.LOG.d(e.getLocalizedMessage());
        }
    }

    /**
     * 发送广播
     *
     * @param action
     * @param intent
     */
    private void sendBroadcast(String action, Intent intent) {
        if (intent == null) {
            intent = new Intent();
        }
        intent.setAction(broadCastPrefix + action);
        AdLogUtil.LOG.d("sendBroadcast action: " + intent.getAction());
        sendBroadcast(intent);
    }

    /**
     * 如果错误就发送错误回调
     *
     * @param errorCode
     * @param msg
     */
    private void onAdError(int errorCode, String msg) {
        Intent errorIntent = new Intent();
        errorIntent.putExtra(ERROR_MSG, msg);
        errorIntent.putExtra(ERROR_CODE, errorCode);
        sendBroadcast(Constants.ACTION_INTERSTITIAL_ERROR, errorIntent);
    }

}
