package com.cloud.hisavana.sdk.common.tranmeasure;

import android.view.View;

import com.cloud.hisavana.sdk.common.tracking.TrackingManager;
import com.cloud.hisavana.sdk.common.tracking.TrackingUtil;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;

import java.lang.ref.WeakReference;


/**
 * 封装了一下 需要 监控的 行为
 */
public class MeasureSession<T> {

    /**
     * 数据 --> 绑定在需要监控的View上的数据
     */
    private T mKey;

    protected AdImpressionListener<T> mImpressionListener;
    private WeakReference<View> mAdView;
    private boolean mIsImpression = false;
    protected MeasureInfo mMeasureInfo;
    private boolean mIsAdValid = true;

    /**
     * 这个才是用来监控的实际操作者
     */
    private ImpressionValidChecker mImpressionValidChecker = null;


    // =============================================================================================


    public MeasureSession(T key) {
        mMeasureInfo = new MeasureInfo();
        mMeasureInfo.minImpressionTime = 1000;
        mMeasureInfo.minVisiblePercent = 50;
        mMeasureInfo.minVisiblePx = 0;
        this.mKey = key;
        mImpressionValidChecker = new ImpressionValidChecker(this);
    }

    /**
     * 注册一个需要监控的行为
     *
     * @param adView    目标View
     * @param listener  回调
     */
    public void registerView(View adView, AdImpressionListener<T> listener) {
        AdLogUtil.measureLog("MeasureSession registerView,isImpression = " + mIsImpression);
        if (!mIsImpression) {
            mAdView = new WeakReference<>(adView);
            mImpressionListener = listener;
            MeasureSessionManager.getInstance().registerSession(this);
        }
    }

    /**
     * 是否是同一个对象
     */
    protected boolean isHit(T key) {
        return mKey == key;
    }

    public void setAdValid(boolean isAdValid){
        this.mIsAdValid = isAdValid;
    }
    public boolean getAdValid(){
        return mIsAdValid;
    }

    /**
     * 监控的目标View
     */
    protected View getAdView() {
        if (mAdView != null) {
            return mAdView.get();
        }
        return null;
    }


    /**
     * 结束监控行为
     */
    public void finish() {
        if (mAdView != null) {
            mAdView.clear();
        }

        if (null!= mImpressionValidChecker){
            mImpressionValidChecker.beforeFinish2Impression();
        }

        // 取消注册
        MeasureSessionManager.getInstance().unregisterSession(this);
    }

    /**
     * 测量 --> 最后都是分发到这里处理的
     */
    protected void measure() {
//        if (mIsImpression) {
            //AdLogUtil.measureLog("Current Ad have impressed.");
            //return;
//        }

        //AdLogUtil.measureLog("MeasureSession --> measure");
        if (mImpressionValidChecker.checkValid() && mImpressionListener != null) {
            // 成功回调
            mImpressionListener.onViewImpressed(mKey);

            //展示过就不在检测展示
            mIsImpression = true;
            AdLogUtil.measureLog("trigger the impression event  mIsImpression = true;");

            // 第三方归因服务
            if (mKey instanceof AdsDTO){
                TrackingManager.clickTrackingUrlsExposure(((AdsDTO) mKey).showTrackingUrls, TrackingUtil.getTriggerId());
            }

            // 所有的曝光 在一个生命周期里面只曝光一次
            // TODO 不能在这里 会造成 高并发
            //MeasureSessionManager.getInstance().destroySession(mKey);
        }

    }

    /**
     * 返回数据类
     */
    protected T getmKey() {
        return mKey;
    }


    // =============================================================================================


    /**
     * 达到要求的时候的回调
     */
    public interface AdImpressionListener<T> {
        void onViewImpressed(T key);
    }
}
