package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;

import com.cloud.hisavana.sdk.BuildConfig;
import com.cloud.hisavana.sdk.R;
import com.transsion.core.CoreUtil;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;

import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

/**
 * AES 对称加密算法，加解密工具类
 * https://github.com/shaojiankui/AES-Java-iOS-Android
 */
public class AESUtils {


    /**
     * 密钥 加密需要的密码  yBO4cgMRBRjGTICp
     * 拆分四个部分保存  yBO4  cgMR  BRjG  TICp
     */
    private static String key = "";

    /**
     * 安全的获取 AES 密钥
     */
    private static String getSelfKey() {
        // 第一部分
        if (TextUtils.isEmpty(key)) {
            String s1 = BuildConfig.AES_UTILS_KEY;
            String s2 = get2PartSelfKey(1, 2);
            String s3 = getBK3();
            String s4 = get4String();
            key = s1 + s2 + s3 + s4;
        }

        return key;
    }

    private static String getAesType(){
        String first = "AES/";
        String second = "ECB/";
        String third = "PKCS5Padding";
        return first+second+third;
    }

    private static String get2PartSelfKey(int x, int y) {

        for (int i = 1; i <= x * y; i++) {
            if (i % x == 0 && i % y == 0)
                return "cgMR";
        }

        return "cgMR";
    }

    private static String getBK3() {
        return "BRjG";
    }

    private static String get4String() {
        return CoreUtil.getContext().getResources().getString(R.string.bk4);
    }


    // =============================================================================================


    /**
     * 加密
     *
     * @param string
     * @return
     */
    public static String encrypt(String string) {
        if (TextUtils.isEmpty(string)) {
            return null;
        }

        // 1.aes加密
        byte[] encryptResult = encrypt2Byte(string);
        // 2.加密的结果 --> toString
        String encryptResultStr = parseByte2HexStr(encryptResult);
        return encryptResultStr;
    }


    /**
     * AES加密字符串
     *
     * @param content 需要被加密的字符串
     * @return 密文
     */
    private static byte[] encrypt2Byte(String content) {
        if (TextUtils.isEmpty(content)) {
            return null;
        }

        try {
            byte[] raw = getSelfKey().getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(getAesType());//"算法/模式/补码方式"
            cipher.init(Cipher.ENCRYPT_MODE, skeySpec);
            byte[] result = cipher.doFinal(content.getBytes("utf-8"));
            return result;
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        } catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }


    // =============================================================================================


    /**
     * 解密
     *
     * @param content
     * @return
     */
    public static String decrypt(String content) {
        if (TextUtils.isEmpty(content)) {
            return null;
        }

        byte[] decryptFrom = parseHexStr2Byte(content);
        byte[] decrypt = decrypt(decryptFrom);
        if (decrypt != null && decrypt.length != 0) {
            return new String(decrypt);
        }
        return null;
    }

    /**
     * 解密AES加密过的字符串
     *
     * @param content AES加密过过的内容
     * @return 明文
     */
    private static byte[] decrypt(byte[] content) {
        try {
            byte[] raw = getSelfKey().getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(getAesType());
            cipher.init(Cipher.DECRYPT_MODE, skeySpec);

            try {
                byte[] original = cipher.doFinal(content);
                return original;
            } catch (Exception e) {
                System.out.println(e.toString());
                return null;
            }

        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        } catch (NoSuchPaddingException e) {
            e.printStackTrace();
        } catch (InvalidKeyException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return null;
    }


    // =============================================================================================


    /**
     * 将Byte数组转换成16进制的字符串
     *
     * @param buf byte[]
     * @return
     */
    public static String parseByte2HexStr(byte buf[]) {
        if (null == buf) {
            return null;
        }

        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; i++) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    /**
     * 将16进制字符串转换成byte数组
     *
     * @param hexStr str
     * @return
     */
    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }

        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; i++) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte) (high * 16 + low);
        }
        return result;
    }

}
