package com.cloud.hisavana.sdk.internal.interstitial;
/* Top Secret */


import com.cloud.hisavana.sdk.ad.AdxInterstitial;
import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.common.adapter.IInterstitial;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.Preconditions;
import com.cloud.hisavana.sdk.internal.base.BaseAd;

import java.util.List;

/**
 * 插屏广告
 *
 * @author 孙志刚.
 * @date 2016/12/8.
 * ==================================
 * Copyright (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class TranInterstitial extends BaseAd {

    private InterstitialGemini mPlatform;

    private IInterstitial mInterstitial;
    private AdsDTO mAdBean = null;


    // =============================================================================================


    /**
     * 构造方法
     *
     * @param placementId
     */
    public TranInterstitial(String placementId) {
        super(Constants.AdType.INTERSTITIAL, placementId);

        mInterstitial = new AdxInterstitial(placementId);
        mInterstitial.setAdListener(mInternalListener);
        mPlatform = new InterstitialGemini(this);
    }


    // =============================================================================================


    @Override
    protected boolean loadPolyAd() {
        return mInterstitial.loadAd(mRequestId);
    }

    @Override
    public void setPlacementId(String placementId) {
        this.mPlacementId = placementId;
        mInterstitial.setPlacementId(placementId);
    }

    @Override
    protected void onAdResponseStub(List<AdsDTO> adBeanList) {
        mAdBean = adBeanList.get(0);

        if (mAdBean == null) {
            AdLogUtil.LOG.w("mAdBean is null,terminate flow");
            return;
        }

        AdLogUtil.LOG.d("loadPlatformAd on start load ad ");
        mPlatform.loadAd();
    }


    // =============================================================================================


    public boolean isAdValid() {
        return AdsConfig.isAdValid(mAdBean);
    }

    public double getBidPrice() {
        if (mAdBean != null) {
            return mAdBean.getBidPrice();
        }
        return 0;
    }

    public long getResidualExpirationTime() {
        return mInterstitial.getResidualExpirationTime();
    }

    AdsDTO adBean() {
        return mAdBean;
    }

    IInterstitial polyInterstitial() {
        return mInterstitial;
    }

    public void show() {
        Preconditions.checkIsOnMainThread();
        if (mAdBean == null) {
            AdLogUtil.LOG.w("adBean = null");
            return;
        }
        boolean isAdValid = isAdValid();
        //打底广告是否有效，是看打底广告的有效期
        if (isDefaultAd) isAdValid = true;
        if (isAdValid && !mShowed) {
            if (mLoaded) {
                mPlatform.show();
            }
        } else {
            AdLogUtil.LOG.w("ad not condition to use");
        }
    }

    public boolean isLoaded() {
        return mLoaded;
    }

    @Override
    public void destroy() {
        Preconditions.runOnMainThread(new Preconditions.Callback() {
            @Override
            public void onRun() {
                mInterstitial.destroy();
                TranInterstitial.super.destroy();
                mPlatform.destroy();
            }
        });
    }

    @Override
    public int getAdType() {
        return Constants.AdType.INTERSTITIAL;
    }

}
