/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.text.TextUtils;
import com.cloud.hisavana.sdk.R;
import com.transsion.core.CoreUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    private static String key = "";

    private static String getSelfKey() {
        if (TextUtils.isEmpty((CharSequence)key)) {
            String s1 = "yBO4";
            String s2 = AESUtils.get2PartSelfKey(1, 2);
            String s3 = AESUtils.getBK3();
            String s4 = AESUtils.get4String();
            key = s1 + s2 + s3 + s4;
        }
        return key;
    }

    private static String getAesType() {
        String first = "AES/";
        String second = "ECB/";
        String third = "PKCS5Padding";
        return first + second + third;
    }

    private static String get2PartSelfKey(int x, int y) {
        for (int i2 = 1; i2 <= x * y; ++i2) {
            if (i2 % x != 0 || i2 % y != 0) continue;
            return "cgMR";
        }
        return "cgMR";
    }

    private static String getBK3() {
        return "BRjG";
    }

    private static String get4String() {
        return CoreUtil.getContext().getResources().getString(R.string.bk4);
    }

    public static String encrypt(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        byte[] encryptResult = AESUtils.encrypt2Byte(string2);
        String encryptResultStr = AESUtils.parseByte2HexStr(encryptResult);
        return encryptResultStr;
    }

    private static byte[] encrypt2Byte(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        try {
            byte[] raw = AESUtils.getSelfKey().getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AESUtils.getAesType());
            cipher.init(1, skeySpec);
            byte[] result = cipher.doFinal(content.getBytes("utf-8"));
            return result;
        }
        catch (NoSuchPaddingException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchAlgorithmException e3) {
            e3.printStackTrace();
        }
        catch (UnsupportedEncodingException e4) {
            e4.printStackTrace();
        }
        catch (InvalidKeyException e5) {
            e5.printStackTrace();
        }
        catch (IllegalBlockSizeException e6) {
            e6.printStackTrace();
        }
        catch (BadPaddingException e7) {
            e7.printStackTrace();
        }
        return null;
    }

    public static String decrypt(String content) {
        if (TextUtils.isEmpty((CharSequence)content)) {
            return null;
        }
        byte[] decryptFrom = AESUtils.parseHexStr2Byte(content);
        byte[] decrypt = AESUtils.decrypt(decryptFrom);
        if (decrypt != null && decrypt.length != 0) {
            return new String(decrypt);
        }
        return null;
    }

    private static byte[] decrypt(byte[] content) {
        try {
            byte[] raw = AESUtils.getSelfKey().getBytes("utf-8");
            SecretKeySpec skeySpec = new SecretKeySpec(raw, "AES");
            Cipher cipher = Cipher.getInstance(AESUtils.getAesType());
            cipher.init(2, skeySpec);
            try {
                byte[] original = cipher.doFinal(content);
                return original;
            }
            catch (Exception e2) {
                System.out.println(e2.toString());
                return null;
            }
        }
        catch (NoSuchAlgorithmException e3) {
            e3.printStackTrace();
        }
        catch (NoSuchPaddingException e4) {
            e4.printStackTrace();
        }
        catch (InvalidKeyException e5) {
            e5.printStackTrace();
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public static String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < buf.length; ++i2) {
            String hex = Integer.toHexString(buf[i2] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i2 = 0; i2 < hexStr.length() / 2; ++i2) {
            int high = Integer.parseInt(hexStr.substring(i2 * 2, i2 * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i2 * 2 + 1, i2 * 2 + 2), 16);
            result[i2] = (byte)(high * 16 + low);
        }
        return result;
    }
}

