/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.R;
import com.transsion.core.CoreUtil;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AESUtils {
    public static final int GCM_IV_LENGTH = 12;
    public static final int GCM_TAG_LENGTH = 16;
    private static final String CHARSET = "UTF8";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DEFAULT_CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    private static String key = "";

    private static String garbleSalt() {
        if (TextUtils.isEmpty((CharSequence)key)) {
            String s1 = "sOWGI8Lv";
            String s2 = AESUtils.get2PartSelfKey(1, 2);
            String s3 = AESUtils.getBK3();
            String s4 = AESUtils.get4String();
            key = s1 + s2 + s3 + s4;
        }
        return key;
    }

    private static String get2PartSelfKey(int x, int y) {
        for (int i2 = 1; i2 <= x * y; ++i2) {
            if (i2 % x != 0 || i2 % y != 0) continue;
            return "FnvyH19r";
        }
        return "FnvyH19r";
    }

    private static String getBK3() {
        return "s2DytdII";
    }

    private static String get4String() {
        return CoreUtil.getContext().getResources().getString(R.string.bk4);
    }

    @RequiresApi(api=19)
    public static String encrypt(String privateString) {
        String key = AESUtils.garbleSalt();
        try {
            byte[] raw = key.getBytes();
            byte[] iv = new byte[12];
            new SecureRandom().nextBytes(iv);
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)skeySpec, ivSpec);
            byte[] ciphertext = cipher.doFinal(privateString.getBytes(CHARSET));
            byte[] encrypted = new byte[iv.length + ciphertext.length];
            System.arraycopy(iv, 0, encrypted, 0, iv.length);
            System.arraycopy(ciphertext, 0, encrypted, iv.length, ciphertext.length);
            return AESUtils.parseByte2HexStr(encrypted);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    @RequiresApi(api=19)
    public static String decrypt(String encrypted) {
        String key = AESUtils.garbleSalt();
        try {
            byte[] raw = key.getBytes();
            SecretKeySpec skeySpec = new SecretKeySpec(raw, KEY_ALGORITHM);
            byte[] decoded = AESUtils.parseHexStr2Byte(encrypted);
            byte[] iv = Arrays.copyOfRange(decoded, 0, 12);
            Cipher cipher = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
            GCMParameterSpec ivSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)skeySpec, ivSpec);
            byte[] ciphertext = cipher.doFinal(decoded, 12, decoded.length - 12);
            return new String(ciphertext, CHARSET);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        if (null == buf) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < buf.length; ++i2) {
            String hex = Integer.toHexString(buf[i2] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i2 = 0; i2 < hexStr.length() / 2; ++i2) {
            int high = Integer.parseInt(hexStr.substring(i2 * 2, i2 * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i2 * 2 + 1, i2 * 2 + 2), 16);
            result[i2] = (byte)(high * 16 + low);
        }
        return result;
    }
}

