/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.os.Build;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import java.util.Locale;

public class UserAgentUtil {
    private static String ua = "";

    public static void init() {
        try {
            if (TextUtils.isEmpty((CharSequence)ua)) {
                ua = UserAgentUtil.getDefaultUserAgent();
                AdLogUtil.LOG.d((Object)"ua is not empty");
            }
        }
        catch (Throwable e2) {
            AdLogUtil.LOG.e((Object)("init is error , error infor is :=" + e2.getMessage()));
        }
    }

    public static String getUserAgent() {
        try {
            if (UserAgentUtil.checkAgent()) {
                AdLogUtil.LOG.d((Object)("call getUserAgent to get ua ,ua :=" + ua));
                return ua;
            }
            AdLogUtil.LOG.d((Object)"ua is empty");
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            AdLogUtil.LOG.e((Object)("UserAgentUtil getUserAgent is error , error infor is :=" + e2.getMessage()));
        }
        return "";
    }

    private static String getDefaultUserAgent() {
        String id2;
        String model;
        String UA = "Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36";
        Locale locale = Locale.getDefault();
        StringBuffer buffer = new StringBuffer();
        String version = Build.VERSION.RELEASE;
        if (version.length() > 0) {
            buffer.append(version);
        } else {
            buffer.append("1.0");
        }
        buffer.append("; ");
        String language = locale.getLanguage();
        if (language != null) {
            buffer.append(language.toLowerCase());
            String country = locale.getCountry();
            if (country != null) {
                buffer.append("-");
                buffer.append(country.toLowerCase());
            }
        } else {
            buffer.append("en");
        }
        if ("REL".equals(Build.VERSION.CODENAME) && (model = Build.MODEL).length() > 0) {
            buffer.append("; ");
            buffer.append(model);
        }
        if ((id2 = Build.ID).length() > 0) {
            buffer.append(" Build/");
            buffer.append(id2);
        }
        return String.format("Mozilla/5.0 (Linux; Android %s;) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/55.0.2883.91 Mobile Safari/537.36", buffer.toString());
    }

    private static boolean checkAgent() {
        try {
            if (TextUtils.isEmpty((CharSequence)ua)) {
                UserAgentUtil.init();
            }
            if (!(ua.contains("windows NT") || ua.contains("Macintosh") || ua.contains("Dalvik"))) {
                return true;
            }
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            AdLogUtil.LOG.e((Object)("checkAgent is error , error msg is :=" + e2.getMessage()));
        }
        return false;
    }
}

