package com.cloud.hisavana.sdk.api.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.webkit.JavascriptInterface;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.cloud.hisavana.sdk.R;
import com.cloud.hisavana.sdk.common.bean.AdImage;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.widget.TAdWebView;
import com.cloud.hisavana.sdk.common.widget.TranCircleImageView;

public class MediaView extends FrameLayout {

    private TranCircleImageView mImageView = null;
    private TAdWebView mTAdWebView = null;
    private int mime;
    private boolean isplay;
    private boolean mIsAttached;

    public MediaView(@NonNull Context context) {
        this(context, null);
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void init(int mime) {
        this.mime = mime;
        initView();
    }

    private void initView() {
        if (mImageView == null) {
            mImageView = new TranCircleImageView(getContext());
        }
        if (this.indexOfChild(mImageView) < 0) {
            addView(mImageView, getFramParams(LayoutParams.MATCH_PARENT, LayoutParams.MATCH_PARENT));
        }
        if (mime == Constants.MIME.GIF) {
            if (mImageView.getLayoutParams() != null) {
                mImageView.getLayoutParams().height = ViewGroup.LayoutParams.WRAP_CONTENT;
            }
        }
    }

    @SuppressLint("JavascriptInterface")
    private void initWebView() {
        if (mTAdWebView == null) {
            mTAdWebView = new TAdWebView(getContext());
            mTAdWebView.setTag(Constants.ImageTag.IMAGE_WEBVIEW);
            mTAdWebView.setWebViewClient(new VideoWebViewClient());

            WebSettings webSettings = mTAdWebView.getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setAllowFileAccessFromFileURLs(true);
            webSettings.setCacheMode(WebSettings.LOAD_DEFAULT);
            webSettings.setDatabaseEnabled(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setAppCacheEnabled(true);
            mTAdWebView.addJavascriptInterface(new VideoLoadInterface(), Constants.JAVASCRIPT_INTERFACE);
        }
    }

    private class VideoLoadInterface {

        @JavascriptInterface
        public void startPlay() {
            if (mime == Constants.MIME.VIDEO) {
                isplay = true;
            }
        }
    }

    public boolean isAttached() {
        return mIsAttached;
    }

    public void setMediaView(AdImage mediaBean, ImageView.ScaleType scaleType) {
        if (mediaBean == null) {
            return;
        }
        mIsAttached = mediaBean.attachView(mImageView);
        mImageView.setScaleType(scaleType);
//        mIsAttached = getScrollManager().attachView(mImageView,mediaBean);
    }

    private class VideoWebViewClient extends WebViewClient {

        @Override
        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            onLoadError(view);
        }

        @RequiresApi(api = Build.VERSION_CODES.M)
        @Override
        public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
            super.onReceivedError(view, request, error);
            onLoadError(view);
        }
    }

    private void onLoadError(WebView view) {
        if (view != null) {
            if (!isplay) {
                view.destroy();
                ViewGroup.LayoutParams layoutParams = getLayoutParams();
                if (layoutParams != null) {
                    layoutParams.height = getHeight();
                    removeAllViews();
                    setLayoutParams(layoutParams);
                    addErrorIcon();
                }
            }
        }
    }

    private void addErrorIcon() {
        LayoutParams framParams = getFramParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
        final LinearLayout linearLayout = new LinearLayout(getContext());
        linearLayout.setOrientation(LinearLayout.VERTICAL);
        linearLayout.setGravity(Gravity.CENTER_HORIZONTAL);
        linearLayout.setLayoutParams(framParams);

        ImageView errorIcon = new ImageView(getContext());
        errorIcon.setBackgroundResource(R.drawable.ad_error);

        TextView errorText = new TextView(getContext());
        errorText.setText(R.string.ad_video_error);
        errorText.setTextColor(Color.WHITE);

        linearLayout.addView(errorIcon, getFramParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));
        linearLayout.addView(errorText, getFramParams(LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT));

        addView(linearLayout, framParams);
    }

    private LayoutParams getFramParams(int width, int height) {
        LayoutParams iconParams = new LayoutParams(width, height);
        iconParams.gravity = Gravity.CENTER;
        return iconParams;
    }


    public void destroy() {
        if (mTAdWebView != null) {
            mTAdWebView.destroy();
            mTAdWebView = null;
        }

        removeAllViews();
    }

    /**
     * 设置大图圆角
     *
     * @param topLeftRadius
     * @param topRightRadius
     * @param bottomLeftRadius
     * @param bottomRightRadius
     */
    public void setRadius(float topLeftRadius, float topRightRadius, float bottomLeftRadius, float bottomRightRadius) {
        if (mImageView != null) {
            mImageView.setTopLeftRadius(topLeftRadius);
            mImageView.setTopRightRadius(topRightRadius);
            mImageView.setBottomLeftRadius(bottomLeftRadius);
            mImageView.setBottomRightRadius(bottomRightRadius);
            if (topLeftRadius == 0
                    && topRightRadius == 0
                    && bottomLeftRadius == 0
                    && bottomRightRadius == 0) {
                mImageView.setCircle(false);
            } else {
                mImageView.setCircle(true);
            }
            //  重绘
            mImageView.invalidate();
        }
    }
}
