package com.cloud.hisavana.sdk.common.tranmeasure;

import android.view.View;

/**
 * 有效曝光面积百分比
 */
public class MinVisiblePercent extends VisibilityChecker{

    /**
     * 返回 当前 目标View的 可见百分比
     */
    @Override
    protected int checkVisiblity(MeasureInfo measureInfo, View adView) {
        if(adView == null || measureInfo == null){
            //return AD_VIEW_INVISIBLE;
            return 0;
        }

        // 在window中可见一个像素 true 否则 false
        if (!adView.getGlobalVisibleRect(mClipRect)) {
            //return AD_VIEW_INVISIBLE;
            return 0;
        }
        final long visibleViewArea = (long) mClipRect.height() * mClipRect.width();
        final long totalViewArea = (long) adView.getHeight() * adView.getWidth();

        if (totalViewArea <= 0) {
            //return AD_VIEW_INVISIBLE;
            return 0;
        }

        //最小可见百分比
        int flag = 100 * visibleViewArea >= measureInfo.minVisiblePercent * totalViewArea ? AD_VIEW_VISIBLE : AD_VIEW_INVISIBLE;
//        if(flag == VIEW_INVISIBLE && mLocation[1] >= 0 && mLocation[1] <= mWindowHeight){
//            flag = VIEW_SCROLL_RIM;
//        }
        //return flag;
        // 将计算得到的可见百分比上传
        return (int) (100 * visibleViewArea/totalViewArea);
    }
}
