package com.cloud.hisavana.sdk.api.adx;


import android.support.annotation.NonNull;

import com.cloud.hisavana.sdk.api.listener.TaRequest;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.internal.interstitial.TranInterstitial;

/**
 * Created by jianbing.yu on 2019/2/22.
 *
 * 媒体入口
 */
public class AInterstitial {

    private static final String TAG = "InterstitialApi";
    private TranInterstitial mInterstitial = null;

    /**
     * 构造方法
     *
     * @param placementId
     */
    public AInterstitial(String placementId) {
        mInterstitial = new TranInterstitial(placementId);
    }


    // =============================================================================================


    /**
     * 设置是否是打底广告
     *
     * @param isDefaultAd
     */
    public void setDefaultAd(boolean isDefaultAd) {
        if (isNullApi()) {
            return;
        }
        mInterstitial.setDefaultAd(isDefaultAd);
    }

    /**
     * 设置placementid
     *
     * @param placementId
     */
    public void setPlacementId(String placementId) {
        if (isNullApi()) {
            return;
        }
        mInterstitial.setPlacementId(placementId);
    }

    public void setAdRequest(@NonNull TaRequest taRequest) {
        if (isNullApi()) {
            return;
        }
        mInterstitial.setAdRequest(taRequest);
    }

    public double getBidPrice(){
        if (isNullApi()) {
            return 0;
        }
        return mInterstitial.getBidPrice();
    }

    public boolean isAdValid() {
        if (isNullApi()) {
            return false;
        }
        return mInterstitial.isAdValid();
    }

    public void loadAd(String requestId) {
        if (isNullApi()) {
            return;
        }
        mInterstitial.loadAd(requestId);
    }

    public void show() {
        if (isNullApi()) {
            return;
        }
        mInterstitial.show();
    }

    public boolean isLoaded() {
        if (isNullApi()) {
            return false;
        }
        return mInterstitial.isLoaded();
    }

    public void destroy() {
        if (isNullApi()) {
            return;
        }
        mInterstitial.destroy();
    }

    private boolean isNullApi() {
        if (mInterstitial == null) {
            AdLogUtil.LOG.e(TAG, "no api found");
            return true;
        }
        return false;
    }
}
