package com.cloud.hisavana.sdk.common.util;


import android.util.Log;

import com.transsion.core.CoreUtil;
import com.transsion.core.log.ObjectLogUtils;

/**
 * Created by peng.sun by 2017/6/29
 * ========================================
 * CopyRight (c) 2016 TRANSSION.Co.Ltd.
 * All rights reserved.
 */
public class AdLogUtil {
    public static ObjectLogUtils LOG = new ObjectLogUtils.Builder().setGlobalTag("TA_SDK").setLogHeadSwitch(true).setBorderSwitch(false).create();
    //打印网络加载日志
    public static ObjectLogUtils NET_LOG = new ObjectLogUtils.Builder().setGlobalTag("AD_NET_LOG").setLogHeadSwitch(true).setBorderSwitch(false).create();

    /**
     * 开屏广告 流程日志
     */
    public static void splashLog(String msg) {
        LOG.i("TA_SDK_splash_log", "splashLog: " + msg);
    }

    /**
     * View显示监测
     */
    public static void measureLog(String msg) {
        LOG.i("TA_SDK_measure_log", "log: " + msg);
    }

    /**
     * OKHttp 相关日志
     */
    public static void imgLog(String msg) {
        LOG.i("TA_SDK_img_log", "log: " + msg);
    }

    /**
     * native 广告流程
     */
    public static void nativeLog(String msg) {
        LOG.i("TA_SDK_native_log", "log: " + msg);
    }

    /**
     * 302 上报
     */
    public static void trackLog(String msg) {
        LOG.i("TA_SDK_track_log", "log: " + msg);
    }

    /**
     * default 广告流程
     */
    public static void defaultLog(String msg) {
        LOG.i("TA_SDK_ad_default_log", "log: " + msg);
    }

    /**
     * 请求广告流程
     */
    public static void adLoadLog(String msg) {
        LOG.i("TA_SDK_ad_load_log", "log: " + msg);
    }

    /**
     * AdChoices流程
     */
    public static void adChoicesLog(String msg) {
        LOG.i("TA_SDK_ad_choices_log", "log: " + msg);
    }


    /**
     * 网络请求 输出 url \ response \ error msg
     */
    public static void netLog(String msg) { NET_LOG.i(msg); }

    // =================下面的代码是从聚合COPY过来的 合并为一个log 工具类 ==================================


    private final String gloableTag = "ADSDK";
    private final ObjectLogUtils logUtils;
    private int mLoggingLevel = VERBOSE;
    private static AdLogUtil adLogUtil = null;
    /**
     * 常量
     */
    public static final int VERBOSE = 2;
    public static final int DEBUG = 3;
    public static final int INFO = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;
    public static final int WTF = 8;
    public static final int JSON = 9;


    /**
     * 构造函数
     */
    private AdLogUtil() {
        logUtils = new ObjectLogUtils.Builder().setGlobalTag("ADSDK").setLogSwitch(true).setBorderSwitch(false).create();
        logUtils.setInvokeLayer(3);
    }

    public void setLogSwitch(boolean isDebug){
        logUtils.getBuilder().setLogSwitch(isDebug);
    }

    /**
     * 线程安全的单例
     *
     * @return
     */
    public static synchronized AdLogUtil Log() {
        if (adLogUtil == null) {
            synchronized (AdLogUtil.class) {
                if (adLogUtil == null) {
                    adLogUtil = new AdLogUtil();
                }
            }
        }
        return adLogUtil;
    }

    /**
     * 辅助方法 不做修改
     *
     * @param logLevel
     * @return
     */
    private boolean shouldLog(int logLevel) {
        return logLevel >= mLoggingLevel;
    }

    public void log(int logLevel, String tag, String msg) {
        logWithThrowable(logLevel, tag, msg, null);
    }

    /**
     * 真正的显示方法
     *
     * @param logLevel
     * @param tag
     * @param msg
     * @param t
     */
    public void logWithThrowable(int logLevel, String tag, String msg, Throwable t) {
        if (shouldLog(logLevel)) {
            tag = gloableTag + "__" + tag;
            switch (logLevel) {
                case VERBOSE:
                    if (t != null) {
                        logUtils.v(tag, msg, t);
                    } else {
                        logUtils.v(tag, msg);
                    }
                    break;
                case WARN:
                    if (t != null) {
                        logUtils.w(tag, msg, t);
                    } else {
                        logUtils.w(tag, msg);
                    }
                    break;
                case ERROR:
                    if (t != null) {
                        logUtils.e(tag, msg, t);
                    } else {
                        logUtils.e(tag, msg);
                    }
                    break;
                case DEBUG:
                    if (t != null) {
                        logUtils.d(tag, msg, t);
                    } else {
                        logUtils.d(tag, msg);
                    }
                    break;
                case INFO:
                    if (t != null) {
                        logUtils.i(tag, msg, t);
                    } else {
                        logUtils.i(tag, msg);
                    }
                    break;

                case JSON:
                    logUtils.json(tag, msg);
                    break;

                default:
                    break;
            }
        }
    }

    public void v(String tag, String msg) {
        log(VERBOSE, tag, msg);
    }

    public void v(String tag, String msg, Throwable t) {
        logWithThrowable(VERBOSE, tag, msg, null);
    }

    public void d(String tag, String msg) {
        log(DEBUG, tag, msg);
    }


    public void d(String tag, int id) {
        String msg = CoreUtil.getContext().getString(id);
        log(DEBUG, tag, msg);
    }

    public void d(String tag, String msg, Throwable t) {
        log(DEBUG, tag, msg);
    }

    public void i(String tag, String msg) {
        log(INFO, tag, msg);
    }

    public void i(String tag, String msg, Throwable t) {
        logWithThrowable(INFO, tag, msg, null);
    }

    public void w(String tag, String msg) {
        log(WARN, tag, msg);
    }

    public void w(String tag, String msg, Throwable t) {
        logWithThrowable(WARN, tag, msg, null);
    }

    public void e(String tag, String msg) {
        msg = "******" + msg + "******";
        log(ERROR, tag, msg);
    }

    public void e(String tag, String msg, Throwable t) {
        msg = "******" + msg + "******";
        logWithThrowable(ERROR, tag, msg, null);
    }

    public void wtf(String tag, String msg) {
        log(WTF, tag, msg);
    }

    public void wtf(String tag, String msg, Throwable t) {
        logWithThrowable(WTF, tag, msg, null);
    }

    public void json(String tag, String msg) {
        logWithThrowable(JSON, tag, msg, null);
    }


}
