package com.cloud.hisavana.sdk.common.tranmeasure;

import android.view.View;

public class MinVisiblePx extends VisibilityChecker{
    @Override
    protected int checkVisiblity(MeasureInfo measureInfo, View adView) {
        if(adView == null || measureInfo == null){
            return AD_VIEW_INVISIBLE;
        }
        if (!adView.getGlobalVisibleRect(mClipRect)) {
            return AD_VIEW_INVISIBLE;
        }
        final long visibleViewArea = (long) mClipRect.height() * mClipRect.width();
        final long totalViewArea = (long) adView.getHeight() * adView.getWidth();

        if (totalViewArea <= 0) {
            return AD_VIEW_INVISIBLE;
        }
        int flag = visibleViewArea >= measureInfo.minVisiblePx ? AD_VIEW_VISIBLE : AD_VIEW_INVISIBLE;
        return flag;
    }
}
