/*
 * Decompiled with CFR 0.152.
 */
package com.cloud.hisavana.sdk.common.util;

import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.core.CoreUtil;
import com.transsion.core.deviceinfo.DeviceInfo;
import com.transsion.core.log.LogUtils;
import com.transsion.core.pool.TranssionPoolManager;
import com.transsion.core.utils.EncoderUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingQueue;

public class DeviceUtil {
    private static String mAndroidIdMd5 = "";
    private static String mAndroidIdMd5ToLowerCase = "";
    private static String mAndroidIdSHA1 = "";
    private static String mImeiMd5 = "";
    private static String mImeiSHA1 = "";
    private static String ip;
    private static String mGAId;

    public static String getMCC() {
        String imsi = DeviceInfo.getIMSI();
        AdLogUtil.LOG.d((Object)("imsi is " + imsi));
        if (!TextUtils.isEmpty((CharSequence)imsi) && imsi.length() >= 4) {
            String mcc = imsi.substring(0, 3);
            AdLogUtil.LOG.d((Object)("mcc is " + mcc));
            return mcc;
        }
        return "";
    }

    public static String getMNC() {
        String imsi = DeviceInfo.getIMSI();
        AdLogUtil.LOG.d((Object)("imsi is " + imsi));
        if (!TextUtils.isEmpty((CharSequence)imsi) && imsi.length() >= 4) {
            String mnc = imsi.substring(3);
            AdLogUtil.LOG.d((Object)("mnc is " + mnc));
            return mnc;
        }
        return "";
    }

    public static String getCarrier() {
        return DeviceInfo.getIMSI();
    }

    public static String getMachineImeiMD5() {
        if (!TextUtils.isEmpty((CharSequence)mImeiMd5)) {
            TelephonyManager manager = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
            Class<?> clazz = manager.getClass();
            try {
                Method getImei = clazz.getDeclaredMethod("getImei", Integer.TYPE);
                getImei.setAccessible(true);
                mImeiMd5 = (String)getImei.invoke((Object)manager, new Object[0]);
            }
            catch (Exception e2) {
                mImeiMd5 = "";
            }
            mImeiMd5 = TextUtils.isEmpty((CharSequence)mImeiMd5) ? "" : EncoderUtil.EncoderByAlgorithm((String)mImeiMd5, (String)"MD5");
        }
        return mImeiMd5;
    }

    public static String getMachineImeiSha1() {
        if (!TextUtils.isEmpty((CharSequence)mImeiSHA1)) {
            TelephonyManager manager = (TelephonyManager)CoreUtil.getContext().getApplicationContext().getSystemService("phone");
            Class<?> clazz = manager.getClass();
            try {
                Method getImei = clazz.getDeclaredMethod("getImei", Integer.TYPE);
                getImei.setAccessible(true);
                mImeiSHA1 = (String)getImei.invoke((Object)manager, new Object[0]);
            }
            catch (Exception e2) {
                mImeiSHA1 = "";
            }
            mImeiSHA1 = TextUtils.isEmpty((CharSequence)mImeiSHA1) ? "" : EncoderUtil.EncoderByAlgorithm((String)mImeiSHA1, (String)"SHA-1");
        }
        return mImeiSHA1;
    }

    private static String getPseudo_UniqueID() {
        return "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.DISPLAY.length() % 10 + Build.HOST.length() % 10 + Build.ID.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10 + Build.TAGS.length() % 10 + Build.TYPE.length() % 10 + Build.USER.length() % 10;
    }

    public static String getLocale() {
        return Locale.getDefault().getLanguage() + "-" + Locale.getDefault().getCountry();
    }

    public static String getLocaleString() {
        Context context = CoreUtil.getContext();
        if (context.getResources() != null && context.getResources().getConfiguration() != null) {
            Locale locale = context.getResources().getConfiguration().locale;
            String localeStr = "";
            localeStr = localeStr + locale.getCountry() + "|";
            localeStr = localeStr + locale.getLanguage() + "|";
            localeStr = localeStr + locale.getDisplayCountry() + "|";
            localeStr = localeStr + locale.getDisplayLanguage() + "|";
            localeStr = localeStr + locale.getDisplayName() + "|";
            localeStr = localeStr + locale.getISO3Country() + "|";
            localeStr = localeStr + locale.getISO3Language();
            return localeStr;
        }
        return "";
    }

    public static String getLocalMacAddress() {
        String mac = "";
        if (Build.VERSION.SDK_INT >= 23) {
            mac = DeviceUtil.getMacAddr();
            AdLogUtil.LOG.d((Object)"get mac from M+");
        } else {
            WifiInfo info;
            WifiManager wifi = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
            if (wifi != null && (info = wifi.getConnectionInfo()) != null) {
                mac = info.getMacAddress();
            }
            AdLogUtil.LOG.d((Object)"normal get mac");
        }
        AdLogUtil.LOG.d((Object)("mac is " + mac));
        return mac;
    }

    private static String getMacAddr() {
        try {
            ArrayList<NetworkInterface> all = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface nif : all) {
                if (!nif.getName().equalsIgnoreCase("wlan0") && !nif.getName().equalsIgnoreCase("eth0")) continue;
                byte[] macBytes = nif.getHardwareAddress();
                if (macBytes == null || macBytes.length == 0) {
                    return "";
                }
                StringBuilder res1 = new StringBuilder();
                for (byte b2 : macBytes) {
                    res1.append(String.format("%02X:", b2));
                }
                if (res1.length() > 0) {
                    res1.deleteCharAt(res1.length() - 1);
                }
                return res1.toString();
            }
        }
        catch (Throwable e2) {
            AdLogUtil.LOG.d((Object)("get mac is error: " + e2.getMessage()));
        }
        return "";
    }

    private static String getProperties(String name, String defValue) {
        String value = defValue;
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            Method method = clazz.getDeclaredMethod("get", String.class);
            value = (String)method.invoke(null, name);
        }
        catch (ClassNotFoundException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchMethodException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e4) {
            e4.printStackTrace();
        }
        catch (Throwable e5) {
            e5.printStackTrace();
        }
        return value;
    }

    public static boolean isGoVersion() {
        try {
            return "1".equals(DeviceUtil.getProperties("os.go.support", "")) || Build.DISPLAY.toUpperCase().contains("-GO-");
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static String getUUID() {
        return UUID.randomUUID().toString();
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static String getGmtTimeZone() {
        int timeZone = TimeZone.getDefault().getOffset(System.currentTimeMillis()) / 3600000;
        AdLogUtil.LOG.d((Object)("current time zone is : " + timeZone));
        return String.valueOf(timeZone);
    }

    public static String getAndroidIDMd5() {
        if (!TextUtils.isEmpty((CharSequence)mAndroidIdMd5)) {
            return mAndroidIdMd5;
        }
        Context context = CoreUtil.getContext();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").trim();
        mAndroidIdMd5 = TextUtils.isEmpty((CharSequence)androidId) ? "" : EncoderUtil.EncoderByAlgorithm((String)androidId, (String)"MD5");
        return mAndroidIdMd5;
    }

    public static String getAndroidIDMd5ToLowerCase() {
        if (TextUtils.isEmpty((CharSequence)mAndroidIdMd5ToLowerCase)) {
            Context context = CoreUtil.getContext();
            String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").trim();
            if (!TextUtils.isEmpty((CharSequence)androidId)) {
                androidId.toLowerCase();
            }
            String string2 = mAndroidIdMd5ToLowerCase = TextUtils.isEmpty((CharSequence)androidId) ? "" : EncoderUtil.EncoderByAlgorithm((String)androidId, (String)"MD5");
            if (!TextUtils.isEmpty((CharSequence)mAndroidIdMd5ToLowerCase)) {
                mAndroidIdMd5ToLowerCase.toLowerCase();
            }
        }
        return mAndroidIdMd5ToLowerCase;
    }

    public static String getAndroidIDSHA1() {
        if (!TextUtils.isEmpty((CharSequence)mAndroidIdSHA1)) {
            return mAndroidIdSHA1;
        }
        Context context = CoreUtil.getContext();
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id").trim();
        mAndroidIdSHA1 = TextUtils.isEmpty((CharSequence)androidId) ? "" : EncoderUtil.EncoderByAlgorithm((String)androidId, (String)"SHA-1");
        return mAndroidIdSHA1;
    }

    public static String getGsmCellLocation() {
        try {
            TelephonyManager tel = (TelephonyManager)CoreUtil.getContext().getSystemService("phone");
            CellLocation cel = tel.getCellLocation();
            if (cel == null) {
                return "";
            }
            int cid = 0;
            int lac = 0;
            if (tel.getPhoneType() == 2) {
                CdmaCellLocation cdmaCellLocation = (CdmaCellLocation)cel;
                cid = cdmaCellLocation.getBaseStationId();
                lac = cdmaCellLocation.getNetworkId();
            } else {
                GsmCellLocation gsmCellLocation = (GsmCellLocation)cel;
                if (gsmCellLocation != null) {
                    cid = gsmCellLocation.getCid();
                    lac = gsmCellLocation.getLac();
                }
            }
            return cid + "|" + lac;
        }
        catch (Exception e2) {
            AdLogUtil.LOG.d((Object)("get GsmCellLocation is error: " + e2.getMessage()));
            return "";
        }
    }

    public static String getIp() {
        try {
            ConnectivityManager conMann = (ConnectivityManager)CoreUtil.getContext().getApplicationContext().getSystemService("connectivity");
            NetworkInfo mobileNetworkInfo = conMann.getNetworkInfo(0);
            NetworkInfo wifiNetworkInfo = conMann.getNetworkInfo(1);
            if (mobileNetworkInfo.isConnected()) {
                ip = DeviceUtil.getLocalIpAddress();
            } else if (wifiNetworkInfo.isConnected()) {
                WifiManager wifiManager = (WifiManager)CoreUtil.getContext().getApplicationContext().getSystemService("wifi");
                WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                int ipAddress = wifiInfo.getIpAddress();
                ip = DeviceUtil.intToIp(ipAddress);
            }
        }
        catch (Exception ex) {
            AdLogUtil.LOG.d((Object)("\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + ex.getMessage()));
        }
        return ip;
    }

    private static boolean isValidIp4Address(String hostName) {
        try {
            return Inet4Address.getByName(hostName) != null;
        }
        catch (UnknownHostException ex) {
            AdLogUtil.LOG.d((Object)("\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + ex.getMessage()));
            return false;
        }
    }

    private static String getLocalIpAddress() {
        String ipaddress = "";
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nif = en.nextElement();
                Enumeration<InetAddress> inet = nif.getInetAddresses();
                while (inet.hasMoreElements()) {
                    InetAddress ip = inet.nextElement();
                    if (ip.isLoopbackAddress() || !DeviceUtil.isValidIp4Address(ip.getHostAddress())) continue;
                    ipaddress = ip.getHostAddress();
                }
            }
        }
        catch (SocketException e2) {
            AdLogUtil.LOG.d((Object)("\u83b7\u53d6\u672c\u5730ip\u5730\u5740\u5931\u8d25 " + e2.getMessage()));
        }
        return ipaddress;
    }

    public static String intToIp(int ipInt) {
        StringBuilder sb = new StringBuilder();
        sb.append(ipInt & 0xFF).append(".");
        sb.append(ipInt >> 8 & 0xFF).append(".");
        sb.append(ipInt >> 16 & 0xFF).append(".");
        sb.append(ipInt >> 24 & 0xFF);
        return sb.toString();
    }

    public static String getGAId() {
        if (mGAId == null || mGAId.length() == 0) {
            mGAId = AdxPreferencesHelper.getInstance().getString("device_util_ga_id");
            TranssionPoolManager.getInstance().addTask(new Runnable(){

                @Override
                public void run() {
                    try {
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(CoreUtil.getContext());
                        if (null != adInfo) {
                            if (!adInfo.getId().equals(mGAId)) {
                                mGAId = adInfo.getId();
                                AdxPreferencesHelper.getInstance().putString("device_util_ga_id", mGAId);
                            }
                            LogUtils.i((Object)("gaid is " + mGAId));
                        }
                    }
                    catch (Exception var2) {
                        var2.printStackTrace();
                    }
                }
            });
        }
        return mGAId;
    }

    static {
        mGAId = "";
    }

    private static class AdvertisingIdClient {
        AdvertisingIdClient() {
        }

        static AdInfo getAdvertisingIdInfo(Context context) throws Exception {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                throw new IllegalStateException("Cannot be called from the main thread");
            }
            PackageManager pm = context.getPackageManager();
            pm.getPackageInfo("com.android.vending", 0);
            AdvertisingConnection connection = new AdvertisingConnection();
            Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
            intent.setPackage("com.google.android.gms");
            if (context.bindService(intent, (ServiceConnection)connection, 1)) {
                AdInfo var5;
                try {
                    AdInfo adInfo;
                    AdvertisingInterface adInterface = new AdvertisingInterface(connection.getBinder());
                    var5 = adInfo = new AdInfo(adInterface.getId(), adInterface.isLimitAdTrackingEnabled(true));
                }
                catch (Exception var10) {
                    throw var10;
                }
                finally {
                    context.unbindService((ServiceConnection)connection);
                }
                return var5;
            }
            throw new IOException("Google Play connection failed");
        }

        public static final class AdInfo {
            private final String advertisingId;
            private final boolean limitAdTrackingEnabled;

            AdInfo(String advertisingId, boolean limitAdTrackingEnabled) {
                this.advertisingId = advertisingId;
                this.limitAdTrackingEnabled = limitAdTrackingEnabled;
            }

            public String getId() {
                return this.advertisingId;
            }

            public boolean isLimitAdTrackingEnabled() {
                return this.limitAdTrackingEnabled;
            }
        }

        private static final class AdvertisingConnection
        implements ServiceConnection {
            boolean retrieved = false;
            private final LinkedBlockingQueue<IBinder> queue = new LinkedBlockingQueue(1);

            private AdvertisingConnection() {
            }

            public void onServiceConnected(ComponentName name, IBinder service) {
                try {
                    this.queue.put(service);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }

            public void onServiceDisconnected(ComponentName name) {
            }

            public IBinder getBinder() throws InterruptedException {
                if (this.retrieved) {
                    throw new IllegalStateException();
                }
                this.retrieved = true;
                return this.queue.take();
            }
        }

        private static final class AdvertisingInterface
        implements IInterface {
            private IBinder binder;

            AdvertisingInterface(IBinder pBinder) {
                this.binder = pBinder;
            }

            public IBinder asBinder() {
                return this.binder;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getId() throws RemoteException {
                String id;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    this.binder.transact(1, data, reply, 0);
                    reply.readException();
                    id = reply.readString();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return id;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            boolean isLimitAdTrackingEnabled(boolean paramBoolean) throws RemoteException {
                boolean limitAdTracking;
                Parcel data = Parcel.obtain();
                Parcel reply = Parcel.obtain();
                try {
                    data.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                    data.writeInt(paramBoolean ? 1 : 0);
                    this.binder.transact(2, data, reply, 0);
                    reply.readException();
                    limitAdTracking = 0 != reply.readInt();
                }
                finally {
                    reply.recycle();
                    data.recycle();
                }
                return limitAdTracking;
            }
        }
    }
}

