package com.cloud.hisavana.sdk.ad.base;


import android.text.TextUtils;
import android.util.Log;

import com.cloud.hisavana.sdk.api.config.AdsConfig;
import com.cloud.hisavana.sdk.api.config.SspAd;
import com.cloud.hisavana.sdk.common.athena.AthenaTracker;
import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.constant.TaErrorCode;
import com.cloud.hisavana.sdk.common.http.AdServerRequest;
import com.cloud.hisavana.sdk.common.http.ServicesTimeUtil;
import com.cloud.hisavana.sdk.common.http.listener.CommonResponseListener;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.common.util.BlurBgUtils;
import com.cloud.hisavana.sdk.common.util.ImageDownloadHelper;
import com.cloud.hisavana.sdk.config.AdxServerConfig;
import com.cloud.hisavana.sdk.data.bean.request.AdxImpBean;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.bean.response.AdsDTO;
import com.cloud.hisavana.sdk.data.bean.response.DiskAdBean;
import com.cloud.hisavana.sdk.data.control.AdBodyPersistenceHelper;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;
import com.transsion.json.Tson;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 加载打底广告
 */
public class AdxDefault {

    private AdServerRequest adServerRequest;
    private List<AdsDTO> mAdBeans = null;
    private AdxImpBean adxImpBean;
    //结束回调
    private LoadListerner loadListerner;
    private AtomicInteger imageCounter;
    private AtomicInteger imageList;


    // =============================================================================================


    public AdxDefault(AdxImpBean adxImpBean) {
        this.adxImpBean = adxImpBean;
        this.adxImpBean.defaultAd = true;
    }


    // =============================================================================================


    public interface LoadListerner {
        void loadComplete(boolean isSuccess);
    }

    public void setLoadListerner(LoadListerner loadListerner) {
        this.loadListerner = loadListerner;
    }


    // =============================================================================================


    /**
     * 加载广告
     */
    public boolean loadAd() {
        if (adxImpBean == null) {
            return false;
        }
        AdLogUtil.defaultLog("preload default ad,id: " + adxImpBean.pmid);
        List<AdsDTO> mDefaultAdBeans = getDefaultAdItem(adxImpBean.pmid, false);
        if (mDefaultAdBeans != null && mDefaultAdBeans.size() >= 2) {
            // 打底id对应的时效内广告条数大于等于2 不请求
            if (loadListerner != null) loadListerner.loadComplete(false);
            AdLogUtil.defaultLog("打底id对应的时效内广告条数大于等于2 不请求");
            return true;
        }
        reset();
        adServerRequest = new AdServerRequest().setListener(new CommonResponseListener<AdResponseBody>() {
            @Override
            protected void onRequestSuccess(int statusCode, AdResponseBody response) {

                // 保存服务器时间
                ServicesTimeUtil.saveServicesTime(response);

                //打底广告的处理
                if (response != null && response.getCode() == Constants.ResponseCode.BUSINESS_SUCCESS_CODE) {
                    AdLogUtil.defaultLog("AdxDefault - got data from net, response is :" + response.toString());

                    if (response.data != null
                            && response.data.ads != null
                            && response.data.ads.size() > 0) {

                        mAdBeans = response.data.ads;
                        if (!TextUtils.equals(response.data.codeSeatId, adxImpBean.pmid)) {
                            AdLogUtil.defaultLog("****** AdxDefault - response pmid is diffrent with request's ******");
                            if (loadListerner != null) loadListerner.loadComplete(false);
                            return;
                        }

                        if (adxImpBean.adt != response.data.getCodeSeatType()) {
                            AdLogUtil.defaultLog("****** AdxDefault - response adt is diffrent with request's ******");
                            if (loadListerner != null) loadListerner.loadComplete(false);
                            return;
                        }
                        Iterator<AdsDTO> it = mAdBeans.iterator();
                        while (it.hasNext()) {
                            final AdsDTO adBean = it.next();
                            //isAdValid(adBean)判断请求回来的打底广告是否有效
                            if (adBean == null || !isAdValid(adBean)) {
                                AdLogUtil.defaultLog("****** AdxDefault - default ad is null,remove from list ******");
                                it.remove();
                                continue;
                            }

                            if (response.data.getCodeSeatType() == Constants.AdType.NATIVE && (adBean.nativeBean == null
                                    || adBean.nativeBean.mainImages == null
                                    || adBean.nativeBean.mainImages.size() == 0
                                    || TextUtils.isEmpty(adBean.nativeBean.mainImages.get(0).url))) {
                                AdLogUtil.defaultLog("****** AdxDefault - Native ad's image is empty,remove from list ******");
                                it.remove();
                                continue;
                            }

                            adBean.codeSeatId = response.data.codeSeatId;
                            adBean.codeSeatType = response.data.getCodeSeatType();
                            adBean.rid = response.data.requestId;
                            adBean.fill_ts = System.currentTimeMillis();
                            adBean.cacheTime = response.data.getCacheTime();
                            adBean.isDefaultAd = 1;
                            adBean.abTest = response.data.abTest;
                            adBean.extInfo = response.data.extInfo;
                        }
                        if (mAdBeans.size() > 0) {
                            DealAdResponse(mAdBeans);
                        } else {
                            if (loadListerner != null) loadListerner.loadComplete(false);
                        }

                    } else {
                        //结束回调，开始下一条请求
                        if (loadListerner != null) loadListerner.loadComplete(false);
                    }
                } else {
                    //业务错误
                    if (null != response) {
                        AdLogUtil.defaultLog("AdxDefault - error,response code is :" + response.getCode() + "," +
                                "response msg is " + response.message);
                    } else {
                        AdLogUtil.defaultLog("AdxDefault - load ad error,null == response");
                    }

                    //结束回调，开始下一条请求
                    if (loadListerner != null) loadListerner.loadComplete(false);
                }
            }

            @Override
            protected void onRequestError(TaErrorCode adError) {
                AdLogUtil.defaultLog("****** AdxDefault - default ds list is empty" + adError.getErrorMessage() + " ******");

                loadListerner.loadComplete(false);
            }

        }).setPostBody(new AdServerRequest.IAdPostBody() {
            @Override
            public String getPostBody() {
                return PostBody.getAdPostBody(adxImpBean, null);
            }
        })
                .setDebug(SspAd.isDebug())
                .setUrl(AdxServerConfig.getServerUrl() + AdxServerConfig.getServerApi())
                .setPlacementId(adxImpBean.pmid);

        if (adServerRequest != null) {
            adServerRequest.netRequestPreExecute();
        }
        return true;
    }

    /**
     * 重置
     */
    private void reset() {
        if (adServerRequest != null) {
            AdLogUtil.defaultLog("AdxDefault - Called default ad more than once. Auto reset request.");
            adServerRequest.cancelRequest();
            adServerRequest = null;
        }
    }

    /**
     * 打底广告请求结果处理
     */
    private void DealAdResponse(final List<AdsDTO> adBeans) {
        if (null == adBeans) {
            AdLogUtil.defaultLog("****** null == adBeans ******");
            return;
        }

        AdLogUtil.defaultLog("AdxDefault - DealAdResponse begin + adBeans.size()" + adBeans.size());

        // 记录一下 一共有多少条数据
        imageCounter = new AtomicInteger(adBeans.size());
        imageList = new AtomicInteger();
        // 循环处理每一条数据 下载每一个素材对应的图片
        for (final AdsDTO adItem : adBeans) {
            if (adItem == null) {
                AdLogUtil.defaultLog("****** AdxDefault - adItem is null,terminate flow ******");
                continue;
            }
            List<String> imageUrls = new ArrayList<>();
            String imageUrl = "";
            //如果是native广告类型
            //todo native存在多条一期不会出现
            if (adItem.getCodeSeatType() == Constants.AdType.NATIVE) {
                if (adItem.nativeBean != null
                        && adItem.nativeBean.mainImages != null
                        && adItem.nativeBean.mainImages.size() > 0) {
                    imageUrl = adItem.nativeBean.mainImages.get(0).url;
                }
                //加载icon
                if (adItem.nativeBean.logo != null && !TextUtils.isEmpty(adItem.nativeBean.logo.url)) {
                    List<String> logoUrls = new ArrayList<>();
                    logoUrls.add(adItem.nativeBean.logo.url);
                    ImageDownloadHelper.preCacheSplashImages(logoUrls, adItem, AthenaTracker.M_TYPE_LOGO, null);
                }
            } else {
                // 1.5 版本升级调整
                //imageUrl = adItem.imageUrl;
                imageUrl = adItem.getAdImgUrl();
            }
            if (!TextUtils.isEmpty(imageUrl)) {
                imageUrls.add(imageUrl);
            } else {
                continue;
            }
            // 广告数据加载成功之后 开始下载图片 缓存到本地
            ImageDownloadHelper.preCacheSplashImages(imageUrls, adItem, AthenaTracker.M_TYPE_LARGE_IMG, new ImageDownloadHelper.ImageListener() {
                @Override
                public void onImagesCached(byte[] data) {
                    // 设置标识 当前图片缓存成功
                    adItem.imageIsDownload = true;
                    // 刷新一下 数据源 用于记录当前有多少图片下载成功
                    imageList.incrementAndGet();
                    refreshAdResponse(adBeans);
                }

                @Override
                public void onImagesFailedToCache(TaErrorCode errorCode) {
                    // 图片下载失败 整个广告数据都不保存
                    AdLogUtil.defaultLog("****** AdxDefault - Default Ad cache failed ******");
                    // 刷新一下 数据源
                    refreshAdResponse(adBeans);
                }
            });
        }
    }

    /**
     * 处理打底广告素材
     *
     * @param adBeans
     */
    private synchronized void refreshAdResponse(List<AdsDTO> adBeans) {
        if (null == adBeans) {
            return;
        }

        int count = imageCounter.decrementAndGet();

        // 所有的请求都回来了 成功+失败
        if (count == 0) {
            if (imageList.get() > 0) {
                // 图片下载完成之后 将图片下载成功的 广告数据保存到本地
                List<AdsDTO> list = new ArrayList<>();
                for (AdsDTO ad : adBeans) {
                    if (ad.getImageIsDownload()) {
                        list.add(ad);
                    }
                }

                AdLogUtil.defaultLog("AdxDefault - refreshAdResponse begin + adBeans.size() = " + adBeans.size() +
                        "AdxDefault - refreshAdResponse + list.size() = " + list.size());

                // 将图片下载成功的数据保存到本地
                cacheDefaultAdList(list.get(0).codeSeatId, list, true);
            } else {
                AdLogUtil.defaultLog("****** AdxDefault - doAdResponse error 没有一条数据请求成功 ******");
            }
        }
        //结束回调，开始下一条请求
        if (loadListerner != null) loadListerner.loadComplete(true);
    }

    /**
     * 缓存 List 数据
     *
     * @param mPlacementId 代码位id
     * @param adItem
     * @param isNetwork
     */
    public static void cacheDefaultAdList(String mPlacementId, List<AdsDTO> adItem, boolean isNetwork) {

        if (adItem != null && adItem.size() > 0) {
            try {
                DiskAdBean diskAdBean = new DiskAdBean();
                String jsonStr = AdBodyPersistenceHelper.getInstance().getString(mPlacementId + "_Default", "[]");
                // 如果是网络请求 && 缓存中有原始数据  追加之后在保存
                if (isNetwork && !TextUtils.isEmpty(jsonStr) && !"[]".equals(jsonStr)) {
                    DiskAdBean diskAdBean2 = Tson.fromJson(jsonStr, DiskAdBean.class);
                    List<AdsDTO> object = diskAdBean2.list;
                    // 追加
                    if (object != null) {
                        AdLogUtil.defaultLog("AdxDefault - cacheDefaultAdList， diskAdBean2-" + object.size());

                        object.addAll(adItem);
                        diskAdBean.list = object;
                    } else {
                        diskAdBean.list = adItem;
                    }
                } else {
                    diskAdBean.list = adItem;
                }
                // 将数据保存到磁盘 todo
                AdBodyPersistenceHelper.getInstance().putString(mPlacementId + "_Default", Tson.toJson(diskAdBean));

                AdLogUtil.defaultLog("AdxDefault - cachedefault item cache success， diskAdBean-" + diskAdBean.list.size());
            } catch (Throwable e) {
                AdLogUtil.defaultLog(Log.getStackTraceString(e));
            }
        } else {
            AdLogUtil.defaultLog("AdxDefault - cachedefaultAd Item is null");
            AdBodyPersistenceHelper.getInstance().putString(mPlacementId + "_Default", "[]");
        }
    }

    /**
     * 获取有效的打底广告数据，并且刷新缓存
     * isShow 判断是否是取数据用来曝光的
     */
    public static List<AdsDTO> getDefaultAdItem(String mPlacementId, boolean isShow) {
        AdLogUtil.defaultLog("AdxDefault - getDefaultAdItem begin,isPreload: " + !isShow);

        String jsonStr = AdBodyPersistenceHelper.getInstance().getString(mPlacementId + "_Default", null);
        List<AdsDTO> list = new ArrayList<>();
        List<AdsDTO> showlist = new ArrayList<>();
        if (!TextUtils.isEmpty(jsonStr) && !"[]".equals(jsonStr)) {
            try {
                // 1.取出数据
                DiskAdBean diskAdBean = Tson.fromJson(jsonStr, DiskAdBean.class);
                if (diskAdBean == null || diskAdBean.list == null) {
                    return null;
                }
                List<AdsDTO> dtoList = diskAdBean.list;
                // 2.时效内广告排查（打底广告到期时间和打底广告曝光次数）
                for (AdsDTO ob : dtoList) {
                    if (isAdValid(ob)) {
                        list.add(ob);
                    } else if (ob != null) {
                        BlurBgUtils.deleteBlurBgFromFile(ob.getAdImgUrl());
                    }
                }
                AdLogUtil.defaultLog("AdxDefault - valid default num :" + list.size());

                // 是取到第一个未曝光过的打底广告，如果都被曝光过，取第1个
                // 曝光次数递减
                if (list.size() > 0 && isShow) {
                    for (int i = 0; i < list.size(); i++) {
                        //取到第一个未曝光过的打底广告
                        if (!list.get(i).getExpiration()) {
                            list.get(i).isExpiration = true;
                            list.get(i).defaultAdShowCount = list.get(i).getDefaultAdShowCount() - 1;
                            showlist.add(list.get(i));
                            break;
                        }
                    }
                    if (showlist.size() == 0) {
                        for (int i = 1; i < list.size(); i++) {
                            //所有的打底广告是否曝光标识置false
                            list.get(i).isExpiration = false;
                        }
                        list.get(0).defaultAdShowCount = list.get(0).getDefaultAdShowCount() - 1;
                        showlist.add(list.get(0));
                    }
                }
                if (isShow || list.size() != dtoList.size()) {
                    // 3.数据变化后，将检查后的数据保存起来
                    AdxDefault.cacheDefaultAdList(mPlacementId, list, false);
                }
            } catch (Throwable e) {
                AdLogUtil.defaultLog("AdxDefault - getDefaultAdItemError" + Log.getStackTraceString(e));
            }
        }
        AdLogUtil.defaultLog(
                "AdxDefault - getDefaultAdItem end,isPreload: " + !isShow + ",list: " + (isShow ? showlist.toString() : list.toString()));

        return isShow ? showlist : list;
    }

    /**
     * 打底广告是否在时效内
     * 打底广告到期时间defaultAdExpirationTime和曝光次数defaultAdShowCount
     */
    private static boolean isAdValid(AdsDTO adItem) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
        long defaultAdExpirationTime;
        try {
            defaultAdExpirationTime = format.parse(adItem.defaultAdExpirationTime).getTime();
        } catch (Exception e) {
            return false;
        }
        return System.currentTimeMillis() < defaultAdExpirationTime && adItem.getDefaultAdShowCount() > 0;
    }

    public void destroy() {
        reset();
        AdLogUtil.defaultLog("AdxDefault - adx ad destroy");
    }
}
