package com.cloud.hisavana.sdk.data.bean.response;

import com.transsion.json.annotations.TserializedName;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author: wenjing.luo
 * @date: 2021/8/5
 * ==================================
 * Copyright (c) 2021 TRANSSION.Co.Ltd.
 * All rights reserved.
 * <p>
 * 广告返回数据bean
 */
public class AdsDTO implements Serializable {

    public Integer id;//自增id
    public Long advertiserId;//广告主id
    public Long planId;//计划id
    public String planType;//1.5版本新增 计划类型
    public Long adGroupId;//广告组id
    public Long adCreativeId;//广告创意id
    @TserializedName(name = "cost")
    public Integer price;//价格(美分）/CPM
    public String packageName;
    @TserializedName(name = "clickUrl")
    public String landingPageUrl;
    public String deepLinkUrl;//应用深链接地址
    public String showTrackingSecretKey;//曝光加密串

    @TserializedName(name = "clickTrackingUrls")
    public ArrayList<String> clickTrackingUrls;//当广告被点击后，触发此字段中的tracking url
    @TserializedName(name = "showTrackingUrls")
    public ArrayList<String> showTrackingUrls;

    public String adChoiceImageUrl;//广告平台标志图片地址 商标
    public String adChoiceClickUrl;//广告平台标志链接地址 点击商标后的落地
    public String adChoiceLegalText;//广告平台标志法律条文 不用
    public String defaultAdExpirationTime;//打底广告到期时间,时间格式同上
    public Integer defaultAdShowCount;//打底广告曝光次数

    // 1.5版本之后 弃用，保留字段兼容老版本
    @Deprecated
    public String imageUrl;//图片链接
    @Deprecated
    public Integer imageWidth;
    @Deprecated
    public Integer imageHeight;

    /**
     * 获取 图片的地址
     *
     * @return
     */
    public String getAdImgUrl() {
        String url = "";
        if (null != nativeBean && null != nativeBean.mainImages && nativeBean.mainImages.size() > 0) {
            url = nativeBean.mainImages.get(0).url;
        }
        return url;
    }

    public Integer getAdImageWidth() {
        Integer width=0;
        if (null != nativeBean && null != nativeBean.mainImages && nativeBean.mainImages.size() > 0) {
            width = nativeBean.mainImages.get(0).width;
        }
        return width;
    }

    public Integer getAdImageHeight() {
        Integer height=0;
        if (null != nativeBean && null != nativeBean.mainImages && nativeBean.mainImages.size() > 0) {
            height = nativeBean.mainImages.get(0).height;
        }
        return height;
    }


    @TserializedName(name = "nativeObject")
    public NativeBean nativeBean;
    public List<AbTestDTO> abTest;
    public String extInfo;


    public String scale;//1.5版本新增 广告尺寸
    public String advSeatType;//1.5版本新增 广告位类型 通过这个判断使用老版本还是新版本广告样式
    public String materialStyle;//1.5版本新增 广告样式


    public String codeSeatId;
    public Integer codeSeatType;
    public Integer cacheTime;//缓存时长：开屏-4、其他-1 （小时）
    public Integer isDefaultAd;//是否是打底广告
    public String rid;//请求时的requestId
    public Long fill_ts;//刚请求回数据的时间
    public Long imp_ts;//track使用
    public String uuid;//在native广告中用到
    //广告过期时间配置 (分钟)
    public Integer splashCountTime = 4; // 倒计时 5S 第4 秒开始才可以点击跳转
    public Boolean isACReady;//adchoice是否预加载成功
    //图片是否下载成功
    public Boolean imageIsDownload;
    //取打底广告时用到，取未曝光过的打底广告
    //如果都被曝光过，则全置为false，从第一个开始取
    public Boolean isExpiration;
    public Integer actualShowRate;//广告素材实际曝光比例
    public Integer isEffectiveShow;//是否有效曝光 1/0 1=有效 0=无效
    public Integer isDefaultAdFirstShow = 0;//是否初次曝光（仅在打底广告时记录）   1=是 0=否 int
    public Double bidPrice;

    @Override
    public String toString() {
        return "AdsDTO{" +
                "id=" + id +
                ", advertiserId=" + advertiserId +
                ", planId=" + planId +
                ", adGroupId=" + adGroupId +
                ", adCreativeId=" + adCreativeId +
                ", price=" + price +
                ", packageName='" + packageName + '\'' +
                ", landingPageUrl='" + landingPageUrl + '\'' +
                ", deepLinkUrl='" + deepLinkUrl + '\'' +
                ", showTrackingSecretKey='" + showTrackingSecretKey + '\'' +
                ", clickTrackingUrls=" + clickTrackingUrls +
                ", showTrackingUrls=" + showTrackingUrls +
                ", adChoiceImageUrl='" + adChoiceImageUrl + '\'' +
                ", adChoiceClickUrl='" + adChoiceClickUrl + '\'' +
                ", adChoiceLegalText='" + adChoiceLegalText + '\'' +
                ", imageUrl='" + imageUrl + '\'' +
                ", imageWidth=" + imageWidth +
                ", imageHeight=" + imageHeight +
                ", nativeBean=" + nativeBean +
                ", codeSeatId='" + codeSeatId + '\'' +
                ", codeSeatType=" + codeSeatType +
                ", cacheTime=" + cacheTime +
                ", isDefaultAd=" + isDefaultAd +
                ", rid='" + rid + '\'' +
                ", imp_ts=" + imp_ts +
                ", uuid='" + uuid + '\'' +
                ", splashCountTime=" + splashCountTime +
                ", isACReady=" + isACReady +
                ", imageIsDownload=" + imageIsDownload +
                ", isExpiration=" + isExpiration +
                ", actualShowRate=" + actualShowRate +
                ", isEffectiveShow=" + isEffectiveShow +
                ", fill_ts=" + fill_ts +
                ", defaultAdExpirationTime='" + defaultAdExpirationTime +
                ", defaultAdShowCount=" + defaultAdShowCount +
                ", isDefaultAdFirstShow=" + isDefaultAdFirstShow +
                '}';
    }

    public String toStringShort() {
        return "\nAdsDTO{" +
                "id=" + id +
                ", codeSeatType='" + codeSeatType + '\'' +
                ", defaultAdExpirationTime='" + defaultAdExpirationTime + '\'' +
                ", defaultAdShowCount=" + defaultAdShowCount +
                ", isExpiration=" + isExpiration +
                '}';
    }

    public double getBidPrice() {
        return  bidPrice == null ? 0 : bidPrice;
    }

    public Integer getId() {
        return id == null ? 0 : id;
    }

    public Long getAdvertiserId() {
        return advertiserId == null ? 0 : advertiserId;
    }

    public Long getPlanId() {
        return planId == null ? 0 : planId;
    }

    public Long getAdGroupId() {
        return adGroupId == null ? 0 : adGroupId;
    }

    public Long getAdCreativeId() {
        return adCreativeId == null ? 0 : adCreativeId;
    }

    public Integer getPrice() {
        return price == null ? 0 : price;
    }

    public Integer getDefaultAdShowCount() {
        return defaultAdShowCount == null ? 0 : defaultAdShowCount;
    }


    public Integer getCodeSeatType() {
        return codeSeatType == null ? 0 : codeSeatType;
    }

    public Integer getCacheTime() {
        return cacheTime == null ? 0 : cacheTime;
    }

    public Integer getIsDefaultAd() {
        return isDefaultAd == null ? 0 : isDefaultAd;
    }

    public Long getFill_ts() {
        return fill_ts == null ? 0 : fill_ts;
    }

    public Long getImp_ts() {
        return imp_ts == null ? 0 : imp_ts;
    }

    public Integer getSplashCountTime() {
        return splashCountTime == null ? 0 : splashCountTime;
    }

    public Boolean getACReady() {
        return isACReady == null ? false : isACReady;
    }

    public Boolean getImageIsDownload() {
        return imageIsDownload == null ? false : imageIsDownload;
    }

    public Boolean getExpiration() {
        return isExpiration == null ? false : isExpiration;
    }

    public Integer getActualShowRate() {
        return actualShowRate == null ? 0 : actualShowRate;
    }

    public Integer getIsEffectiveShow() {
        return isEffectiveShow == null ? 0 : isEffectiveShow;
    }

    public Integer getIsDefaultAdFirstShow() {
        return isDefaultAdFirstShow == null ? 0 : isDefaultAdFirstShow;
    }

}
