package com.cloud.hisavana.sdk.common.http;

import android.util.Log;

import com.cloud.hisavana.sdk.common.constant.Constants;
import com.cloud.hisavana.sdk.common.util.AdLogUtil;
import com.cloud.hisavana.sdk.data.bean.response.AdResponseBody;
import com.cloud.hisavana.sdk.data.control.AdxPreferencesHelper;

import java.text.SimpleDateFormat;

public class ServicesTimeUtil {


    /**
     * 保存服务端的时间戳
     */
    public static void saveServicesTime(AdResponseBody body) {

        if (null == body || null == body.getData()) {
            return;
        }

        try {
            // 服务器时间
            String tt = body.getData().getTime();
            // 服务器时间转换成时间戳
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss SSS Z");
            long defaultAdExpirationTime = format.parse(tt).getTime();
            // 将差值保存起来
            AdxPreferencesHelper.getInstance().putLong(Constants.SERVICES_TIME_DIFFERENCE_VALUE,
                    System.currentTimeMillis() - defaultAdExpirationTime);
        } catch (Exception e) {
            AdLogUtil.Log().e(Log.getStackTraceString(e));
        }
    }

}
